/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import forestry.api.core.ForestryBlock;
import forestry.api.core.IResupplyHandler;
import forestry.api.storage.BackpackManager;
import forestry.core.Proxy;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.plugins.NativePlugin;
import forestry.storage.GuiHandlerStorage;
import forestry.storage.ItemApiaristBackpack;
import forestry.storage.ItemBackpack;
import forestry.storage.ItemBackpackAdventurer;
import forestry.storage.ItemBackpackBuilder;
import forestry.storage.ItemBackpackDigger;
import forestry.storage.ItemBackpackForester;
import forestry.storage.ItemBackpackHunter;
import forestry.storage.ItemBackpackMiner;
import forestry.storage.PickupHandlerStorage;
import forestry.storage.ResupplyHandler;
import forge.IGuiHandler;
import forge.IPickupHandler;
import java.util.ArrayList;

public class PluginForestryStorage
extends NativePlugin {
    private ArrayList minerItems;
    private ArrayList diggerItems;
    private ArrayList foresterItems;
    private ArrayList hunterItems;
    private ArrayList adventurerItems;
    private ArrayList builderItems;

    @Override
    public boolean isAvailable() {
        return !Config.disableStorage;
    }

    @Override
    public String getDescription() {
        return "Native Storage";
    }

    @Override
    public void preInit() {
        super.preInit();
        this.createBackpackArrays();
    }

    @Override
    public IPickupHandler getPickupHandler() {
        return new PickupHandlerStorage();
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return new GuiHandlerStorage();
    }

    @Override
    public IResupplyHandler getResupplyHandler() {
        return new ResupplyHandler();
    }

    @Override
    protected void registerPackages() {
    }

    @Override
    protected void registerItems() {
        ForestryItem.apiaristBackpack = new ItemApiaristBackpack(Config.getOrCreateIntProperty("apiaristBag", "item", 13048)).a("apiaristBag");
        ForestryItem.minerBackpack = new ItemBackpackMiner(Config.getOrCreateIntProperty("minerBag", "item", 13049), 1).a("minerBag");
        ForestryItem.diggerBackpack = new ItemBackpackDigger(Config.getOrCreateIntProperty("diggerBag", "item", 13050), 1).a("diggerBag");
        ForestryItem.foresterBackpack = new ItemBackpackForester(Config.getOrCreateIntProperty("foresterBag", "item", 13051), 1).a("foresterBag");
        ForestryItem.hunterBackpack = new ItemBackpackHunter(Config.getOrCreateIntProperty("hunterBag", "item", 13052), 1).a("hunterBag");
        ForestryItem.adventurerBackpack = new ItemBackpackAdventurer(Config.getOrCreateIntProperty("adventurerBackpack", "item", 13096), 1).a("adventurerBackpack");
        ForestryItem.builderBackpack = new ItemBackpackBuilder(Config.getOrCreateIntProperty("builderBackpack", "item", 13106), 1).a("builderBackpack");
        ForestryItem.minerBackpackT2 = new ItemBackpackMiner(Config.getOrCreateIntProperty("minerBagT2", "item", 13088), 2).a("minerBagT2");
        ForestryItem.diggerBackpackT2 = new ItemBackpackDigger(Config.getOrCreateIntProperty("diggerBagT2", "item", 13089), 2).a("diggerBagT2");
        ForestryItem.foresterBackpackT2 = new ItemBackpackForester(Config.getOrCreateIntProperty("foresterBagT2", "item", 13090), 2).a("foresterBagT2");
        ForestryItem.hunterBackpackT2 = new ItemBackpackHunter(Config.getOrCreateIntProperty("hunterBagT2", "item", 13091), 2).a("hunterBagT2");
        ForestryItem.adventurerBackpackT2 = new ItemBackpackAdventurer(Config.getOrCreateIntProperty("adventurerBackpackT2", "item", 13097), 2).a("adventurerBackpackT2");
        ForestryItem.builderBackpackT2 = new ItemBackpackBuilder(Config.getOrCreateIntProperty("builderBackpackT2", "item", 13107), 2).a("builderBackpackT2");
        PickupHandlerStorage.backpacks = new ItemBackpack[]{(ItemBackpack)ForestryItem.apiaristBackpack, (ItemBackpack)ForestryItem.minerBackpack, (ItemBackpack)ForestryItem.diggerBackpack, (ItemBackpack)ForestryItem.foresterBackpack, (ItemBackpack)ForestryItem.hunterBackpack, (ItemBackpack)ForestryItem.adventurerBackpack, (ItemBackpack)ForestryItem.builderBackpack};
    }

    @Override
    protected void registerBackpackItems() {
        this.minerItems.add(new aan(pb.ap));
        this.minerItems.add(new aan(pb.I));
        this.minerItems.add(new aan(yr.m));
        this.minerItems.add(new aan(pb.aw));
        this.minerItems.add(new aan(yr.n));
        this.minerItems.add(new aan(pb.G));
        this.minerItems.add(new aan(yr.p));
        this.minerItems.add(new aan(pb.H));
        this.minerItems.add(new aan(yr.o));
        this.minerItems.add(new aan(pb.N));
        this.minerItems.add(new aan(pb.aN));
        this.minerItems.add(new aan(yr.aC));
        this.minerItems.add(new aan(yr.aW, 1, 4));
        this.minerItems.add(new aan(yr.aT));
        this.minerItems.add(ForestryItem.ingotCopper);
        this.minerItems.add(ForestryItem.ingotTin);
        this.minerItems.add(ForestryItem.ingotBronze);
        this.diggerItems.add(new aan(pb.v));
        this.diggerItems.add(new aan(pb.w));
        this.diggerItems.add(new aan(pb.E));
        this.diggerItems.add(new aan(pb.Q));
        this.diggerItems.add(new aan(pb.F));
        this.diggerItems.add(new aan(yr.ap));
        this.diggerItems.add(new aan(pb.bb));
        this.diggerItems.add(new aan(yr.aI));
        this.diggerItems.add(new aan(pb.bc));
        this.foresterItems.add(new aan(pb.y, 1, -1));
        this.foresterItems.add(new aan((pb)pb.ag));
        this.foresterItems.add(new aan((pb)pb.af));
        this.foresterItems.add(new aan(pb.J, 1, -1));
        this.foresterItems.add(new aan(yr.S));
        this.foresterItems.add(new aan((pb)pb.ae));
        this.foresterItems.add(new aan((pb)pb.ad));
        this.foresterItems.add(new aan((pb)pb.K, 1, -1));
        this.foresterItems.add(new aan(pb.aV));
        this.foresterItems.add(new aan((pb)pb.X, 1, -1));
        this.foresterItems.add(new aan(pb.bu));
        this.foresterItems.add(new aan(yr.j));
        this.foresterItems.add(new aan(yr.at));
        this.foresterItems.add(new aan(yr.br));
        this.foresterItems.add(new aan(yr.bg));
        this.foresterItems.add(new aan(yr.bh));
        this.hunterItems.add(new aan(yr.L));
        this.hunterItems.add(new aan(yr.M));
        this.hunterItems.add(new aan(yr.bw));
        this.hunterItems.add(new aan(yr.bo));
        this.hunterItems.add(new aan(yr.aX));
        this.hunterItems.add(new aan(yr.K));
        this.hunterItems.add(new aan(yr.bm));
        this.hunterItems.add(new aan(yr.bp));
        this.hunterItems.add(new aan(yr.bq));
        this.hunterItems.add(new aan(yr.l));
        this.hunterItems.add(new aan(yr.aq));
        this.hunterItems.add(new aan(yr.ar));
        this.hunterItems.add(new aan(yr.bi));
        this.hunterItems.add(new aan(yr.bj));
        this.hunterItems.add(new aan(yr.bk));
        this.hunterItems.add(new aan(yr.bl));
        this.hunterItems.add(new aan(yr.aF));
        this.hunterItems.add(new aan(yr.aP));
        this.hunterItems.add(new aan(yr.bn));
        this.hunterItems.add(new aan(yr.bu));
        this.hunterItems.add(new aan(yr.bv));
        this.hunterItems.add(new aan(yr.aM));
        this.hunterItems.add(new aan(yr.aW, 1, 0));
        this.hunterItems.add(new aan(pb.ab));
        this.hunterItems.add(new aan(pb.ab, 1, -1));
        this.hunterItems.add(new aan(yr.bA));
        this.hunterItems.add(new aan(yr.bx));
        this.hunterItems.add(new aan(yr.bB));
        this.hunterItems.add(new aan(yr.aU));
        this.hunterItems.add(new aan(yr.aV));
        this.builderItems.add(new aan(pb.aq));
        this.builderItems.add(new aan(pb.bm, 1, -1));
        this.builderItems.add(new aan(pb.t));
        this.builderItems.add(new aan(pb.al));
        this.builderItems.add(new aan(pb.x, 1, -1));
        this.builderItems.add(new aan(pb.bA));
        this.builderItems.add(new aan(pb.bB));
        this.builderItems.add(new aan(pb.ak));
        this.builderItems.add(new aan(pb.aH));
        this.builderItems.add(new aan(pb.at));
        this.builderItems.add(new aan(pb.aj));
        this.builderItems.add(new aan(pb.bw));
        this.builderItems.add(new aan(pb.bC));
        this.builderItems.add(new aan(pb.bx));
        this.builderItems.add(new aan(pb.M));
        this.builderItems.add(new aan(pb.bq));
        this.builderItems.add(new aan(pb.aZ));
        this.builderItems.add(new aan(pb.bv));
        this.builderItems.add(new aan(pb.bp));
    }

    @Override
    protected void registerRecipes() {
        Proxy.addRecipe(new aan(ForestryItem.apiaristBackpack), new Object[]{"X#X", "VYV", "X#X", Character.valueOf('#'), pb.ab, Character.valueOf('X'), yr.K, Character.valueOf('V'), yr.D, Character.valueOf('Y'), new aan(ForestryBlock.mill, 1, 3)});
        Proxy.addRecipe(new aan(ForestryItem.minerBackpack), new Object[]{"X#X", "VYV", "X#X", Character.valueOf('#'), pb.ab, Character.valueOf('X'), yr.K, Character.valueOf('V'), yr.o, Character.valueOf('Y'), pb.au});
        Proxy.addRecipe(new aan(ForestryItem.diggerBackpack), new Object[]{"X#X", "VYV", "X#X", Character.valueOf('#'), pb.ab, Character.valueOf('X'), yr.K, Character.valueOf('V'), pb.t, Character.valueOf('Y'), pb.au});
        Proxy.addRecipe(new aan(ForestryItem.foresterBackpack), new Object[]{"X#X", "VYV", "X#X", Character.valueOf('#'), pb.ab, Character.valueOf('X'), yr.K, Character.valueOf('V'), pb.J, Character.valueOf('Y'), pb.au});
        Proxy.addRecipe(new aan(ForestryItem.hunterBackpack), new Object[]{"X#X", "VYV", "X#X", Character.valueOf('#'), pb.ab, Character.valueOf('X'), yr.K, Character.valueOf('V'), yr.L, Character.valueOf('Y'), pb.au});
        Proxy.addRecipe(new aan(ForestryItem.adventurerBackpack), new Object[]{"X#X", "VYV", "X#X", Character.valueOf('#'), pb.ab, Character.valueOf('X'), yr.K, Character.valueOf('V'), yr.aX, Character.valueOf('Y'), pb.au});
        Proxy.addRecipe(new aan(ForestryItem.builderBackpack), new Object[]{"X#X", "VYV", "X#X", Character.valueOf('#'), pb.ab, Character.valueOf('X'), yr.K, Character.valueOf('V'), yr.aI, Character.valueOf('Y'), pb.au});
    }

    private void createBackpackArrays() {
        BackpackManager.backpackItems = new ArrayList[6];
        this.minerItems = new ArrayList();
        BackpackManager.backpackItems[0] = this.minerItems;
        this.diggerItems = new ArrayList();
        BackpackManager.backpackItems[1] = this.diggerItems;
        this.foresterItems = new ArrayList();
        BackpackManager.backpackItems[2] = this.foresterItems;
        this.hunterItems = new ArrayList();
        BackpackManager.backpackItems[3] = this.hunterItems;
        this.adventurerItems = new ArrayList();
        BackpackManager.backpackItems[4] = this.adventurerItems;
        this.builderItems = new ArrayList();
        BackpackManager.backpackItems[5] = this.builderItems;
    }

    @Override
    protected void registerCrates() {
    }
}

