/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import forestry.api.recipes.RecipeManagers;
import forestry.core.GadgetManager;
import forestry.core.config.Config;
import forestry.factory.GuiHandlerFactory;
import forestry.factory.MachineBottler;
import forestry.factory.MachineCarpenter;
import forestry.factory.MachineCentrifuge;
import forestry.factory.MachineDistillation;
import forestry.factory.MachineFermenter;
import forestry.factory.MachineMoistener;
import forestry.factory.MachineSqueezer;
import forestry.factory.PackagesFactory;
import forestry.plugins.NativePlugin;
import forge.IGuiHandler;

public class PluginForestryFactory
extends NativePlugin {
    @Override
    public boolean isAvailable() {
        return !Config.disableFactory;
    }

    @Override
    public String getDescription() {
        return "Native Factory";
    }

    @Override
    public void preInit() {
        super.preInit();
        RecipeManagers.carpenterManager = new MachineCarpenter.RecipeManager();
        RecipeManagers.moistenerManager = new MachineMoistener.RecipeManager();
        RecipeManagers.centrifugeManager = new MachineCentrifuge.RecipeManager();
        RecipeManagers.stillManager = new MachineDistillation.RecipeManager();
        RecipeManagers.bottlerManager = new MachineBottler.RecipeManager();
        RecipeManagers.squeezerManager = new MachineSqueezer.RecipeManager();
        RecipeManagers.fermenterManager = new MachineFermenter.RecipeManager();
    }

    @Override
    public void postInit() {
        super.postInit();
        MachineCarpenter.initialize();
        MachineMoistener.initialize();
        MachineCentrifuge.initialize();
        MachineDistillation.initialize();
        MachineBottler.initialize();
        MachineSqueezer.initialize();
        MachineFermenter.initialize();
    }

    @Override
    protected void registerPackages() {
        GadgetManager.registerMachinePackage(0, PackagesFactory.getFermenterPackage());
        GadgetManager.registerMachinePackage(1, PackagesFactory.getStillPackage());
        GadgetManager.registerMachinePackage(2, PackagesFactory.getBottlerPackage());
        GadgetManager.registerMachinePackage(3, PackagesFactory.getRaintankPackage());
        GadgetManager.registerMachinePackage(5, PackagesFactory.getCarpenterPackage());
        GadgetManager.registerMachinePackage(6, PackagesFactory.getMoistenerPackage());
        GadgetManager.registerMachinePackage(8, PackagesFactory.getCentrifugePackage());
        GadgetManager.registerMachinePackage(9, PackagesFactory.getSqueezerPackage());
        GadgetManager.registerMillPackage(1, PackagesFactory.getRainmakerPackage());
    }

    @Override
    protected void registerItems() {
    }

    @Override
    protected void registerBackpackItems() {
    }

    @Override
    protected void registerRecipes() {
    }

    @Override
    protected void registerCrates() {
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return new GuiHandlerFactory();
    }
}

