/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import forestry.api.core.ForestryBlock;
import forestry.api.cultivation.CropProviders;
import forestry.core.GadgetManager;
import forestry.core.Proxy;
import forestry.core.config.Config;
import forestry.cultivation.BlockFirSapling;
import forestry.cultivation.BlockHarvester;
import forestry.cultivation.BlockPlanter;
import forestry.cultivation.GuiHandlerCultivation;
import forestry.cultivation.ItemFirSapling;
import forestry.cultivation.PackagesCultivation;
import forestry.cultivation.ProxyCultivation;
import forestry.cultivation.providers.CropProviderCacti;
import forestry.cultivation.providers.CropProviderHerbaceous;
import forestry.cultivation.providers.CropProviderMushroom;
import forestry.cultivation.providers.CropProviderNetherwart;
import forestry.cultivation.providers.CropProviderReeds;
import forestry.cultivation.providers.CropProviderSapling;
import forestry.cultivation.providers.CropProviderSeeds;
import forestry.plugins.NativePlugin;
import forge.IBonemealHandler;
import forge.IGuiHandler;
import forge.MinecraftForge;

public class PluginForestryCultivation
extends NativePlugin {
    @Override
    public boolean isAvailable() {
        return !Config.disableCultivation;
    }

    @Override
    public String getDescription() {
        return "Native Cultivation";
    }

    @Override
    public void preInit() {
        super.preInit();
        ForestryBlock.firsapling = new BlockFirSapling(Config.getOrCreateBlockIdProperty("firsapling", 202), 15).a("firsapling");
        ForestryBlock.planter = new BlockPlanter(Config.getOrCreateBlockIdProperty("planter", 201)).a("planter");
        ForestryBlock.harvester = new BlockHarvester(Config.getOrCreateBlockIdProperty("harvester", 203)).a("harvester");
        Proxy.registerBlock(ForestryBlock.firsapling, ItemFirSapling.class);
    }

    @Override
    public void doInit() {
        super.doInit();
        this.registerCropProviders();
        MinecraftForge.registerBonemealHandler((IBonemealHandler)((BlockFirSapling)ForestryBlock.firsapling));
        ProxyCultivation.registerPlanterTE();
        ProxyCultivation.registerHarvesterTE();
    }

    @Override
    protected void registerPackages() {
        GadgetManager.registerPlanterPackage(0, PackagesCultivation.getArboretumPackage());
        GadgetManager.registerPlanterPackage(1, PackagesCultivation.getFarmPackage());
        GadgetManager.registerPlanterPackage(2, PackagesCultivation.getPlantationPackage());
        GadgetManager.registerPlanterPackage(3, PackagesCultivation.getPumpkinFarmPackage());
        GadgetManager.registerPlanterPackage(4, PackagesCultivation.getBogPeatPackage());
        GadgetManager.registerPlanterPackage(5, PackagesCultivation.getMushroomFarmPackage());
        GadgetManager.registerPlanterPackage(6, PackagesCultivation.getNetherFarmPackage());
        GadgetManager.registerHarvesterPackage(0, PackagesCultivation.getLoggerPackage());
        GadgetManager.registerHarvesterPackage(1, PackagesCultivation.getCombinePackage());
        GadgetManager.registerHarvesterPackage(2, PackagesCultivation.getRubberHarvesterPackage());
        GadgetManager.registerHarvesterPackage(3, PackagesCultivation.getPumpkinHarvesterPackage());
        GadgetManager.registerHarvesterPackage(4, PackagesCultivation.getTurbaryPackage());
        GadgetManager.registerHarvesterPackage(5, PackagesCultivation.getCactiHarvesterPackage());
        GadgetManager.registerHarvesterPackage(6, PackagesCultivation.getMushroomPickerPackage());
        GadgetManager.registerHarvesterPackage(7, PackagesCultivation.getReedHarvesterPackage());
        GadgetManager.registerHarvesterPackage(8, PackagesCultivation.getNetherCombinePackage());
        GadgetManager.registerMillPackage(0, PackagesCultivation.getForesterPackage());
        GadgetManager.registerMillPackage(2, PackagesCultivation.getTreetapPackage());
    }

    @Override
    protected void registerItems() {
    }

    @Override
    protected void registerBackpackItems() {
    }

    @Override
    protected void registerRecipes() {
    }

    private void registerCropProviders() {
        CropProviders.arborealCrops.add(new CropProviderSapling());
        CropProviders.cerealCrops.add(new CropProviderSeeds());
        CropProviders.infernalCrops.add(new CropProviderNetherwart());
        CropProviders.herbaceousCrops.add(new CropProviderHerbaceous());
        CropProviders.succulentCrops.add(new CropProviderCacti());
        CropProviders.poaleCrops.add(new CropProviderReeds());
        CropProviders.fungalCrops.add(new CropProviderMushroom());
    }

    @Override
    protected void registerCrates() {
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return new GuiHandlerCultivation();
    }
}

