/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory;

import forestry.api.core.ForestryBlock;
import forestry.core.MachineFactory;
import forestry.core.MachinePackage;
import forestry.core.RenderProxy;
import forestry.core.config.ForestryItem;
import forestry.core.utils.CraftingIngredients;
import forestry.core.utils.EnergyConfiguration;
import forestry.factory.MachineBottler;
import forestry.factory.MachineCarpenter;
import forestry.factory.MachineCentrifuge;
import forestry.factory.MachineDistillation;
import forestry.factory.MachineFermenter;
import forestry.factory.MachineMoistener;
import forestry.factory.MachineRaintank;
import forestry.factory.MachineSqueezer;
import forestry.factory.MillRainmaker;

public class PackagesFactory {
    public static final EnergyConfiguration energyConfigDefaultMachine = new EnergyConfiguration(1000, 5, 40, 75, 500);
    public static final EnergyConfiguration energyConfigDefaultBottler = new EnergyConfiguration(10, 5, 100, 60, 400);

    public static MachinePackage getFermenterPackage() {
        MachinePackage pack = new MachinePackage((MachineFactory)new MachineFermenter.Factory(), "Fermenter", RenderProxy.getRenderDefaultMachine("/gfx/blocks/fermenter_"), new CraftingIngredients(1, new Object[]{"X#X", "#Y#", "X#X", Character.valueOf('#'), pb.M, Character.valueOf('X'), ForestryItem.gearBronze, Character.valueOf('Y'), ForestryItem.sturdyMachine}));
        pack.energyConfig = new EnergyConfiguration(500, 5, 100, 80, 400);
        return pack;
    }

    public static MachinePackage getStillPackage() {
        MachinePackage pack = new MachinePackage((MachineFactory)new MachineDistillation.Factory(), "Still", RenderProxy.getRenderDefaultMachine("/gfx/blocks/still_"), new CraftingIngredients(1, new Object[]{"X#X", "#Y#", "X#X", Character.valueOf('#'), pb.M, Character.valueOf('X'), yr.aC, Character.valueOf('Y'), ForestryItem.sturdyMachine}));
        pack.energyConfig = new EnergyConfiguration(100, 5, 100, 25, 540);
        return pack;
    }

    public static MachinePackage getBottlerPackage() {
        CraftingIngredients recipe = null;
        recipe = new CraftingIngredients(1, new Object[]{"X#X", "#Y#", "X#X", Character.valueOf('#'), pb.M, Character.valueOf('X'), ForestryItem.canEmpty, Character.valueOf('Y'), ForestryItem.sturdyMachine});
        MachinePackage pack = new MachinePackage((MachineFactory)new MachineBottler.Factory(), "Bottler", RenderProxy.getRenderDefaultMachine("/gfx/blocks/bottler_", true, false), recipe);
        pack.energyConfig = energyConfigDefaultBottler;
        return pack;
    }

    public static MachinePackage getCarpenterPackage() {
        MachinePackage pack = new MachinePackage((MachineFactory)new MachineCarpenter.Factory(), "Carpenter", RenderProxy.getRenderDefaultMachine("/gfx/blocks/carpenter_", true, false), new CraftingIngredients(1, new Object[]{"X#X", "XYX", "X#X", Character.valueOf('#'), pb.M, Character.valueOf('X'), ForestryItem.ingotBronze, Character.valueOf('Y'), ForestryItem.sturdyMachine}));
        pack.energyConfig = new EnergyConfiguration(20, 1, 100, 25, 400);
        return pack;
    }

    public static MachinePackage getMoistenerPackage() {
        MachinePackage pack = new MachinePackage((MachineFactory)new MachineMoistener.Factory(), "Moistener", RenderProxy.getRenderDefaultMachine("/gfx/blocks/moistener_", true, false), new CraftingIngredients(1, new Object[]{"X#X", "#Y#", "X#X", Character.valueOf('#'), pb.M, Character.valueOf('X'), ForestryItem.gearCopper, Character.valueOf('Y'), new aan(ForestryBlock.machine, 1, 0)}));
        pack.energyConfig = new EnergyConfiguration(0, 0, 0, 0, 0);
        return pack;
    }

    public static MachinePackage getCentrifugePackage() {
        MachinePackage pack = new MachinePackage((MachineFactory)new MachineCentrifuge.Factory(), "Centrifuge", RenderProxy.getRenderDefaultMachine("/gfx/blocks/centrifuge_", false, false), new CraftingIngredients(1, new Object[]{"X#X", "XYX", "X#X", Character.valueOf('#'), pb.M, Character.valueOf('X'), ForestryItem.ingotCopper, Character.valueOf('Y'), new aan(ForestryItem.sturdyMachine)}));
        pack.energyConfig = new EnergyConfiguration(10, 1, 100, 25, 480);
        return pack;
    }

    public static MachinePackage getSqueezerPackage() {
        MachinePackage pack = new MachinePackage((MachineFactory)new MachineSqueezer.Factory(), "Squeezer", RenderProxy.getRenderDefaultMachine("/gfx/blocks/squeezer_", false, true), new CraftingIngredients(1, new Object[]{"X#X", "XYX", "X#X", Character.valueOf('#'), pb.M, Character.valueOf('X'), ForestryItem.ingotTin, Character.valueOf('Y'), new aan(ForestryItem.sturdyMachine)}));
        pack.energyConfig = new EnergyConfiguration(10, 5, 100, 25, 250);
        return pack;
    }

    public static MachinePackage getRaintankPackage() {
        MachinePackage pack = new MachinePackage((MachineFactory)new MachineRaintank.Factory(), "Raintank", RenderProxy.getRenderDefaultMachine("/gfx/blocks/raintank_", true, false), new CraftingIngredients(1, new Object[]{"X#X", "XYX", "X#X", Character.valueOf('#'), pb.M, Character.valueOf('X'), yr.o, Character.valueOf('Y'), ForestryItem.sturdyMachine}));
        pack.energyConfig = energyConfigDefaultBottler;
        return pack;
    }

    public static MachinePackage getRainmakerPackage() {
        byte charges = 8;
        MachinePackage pack = new MachinePackage((MachineFactory)new MillRainmaker.Factory(), "Rainmaker", RenderProxy.getRenderMill("/gfx/blocks/rainmaker_", charges), new CraftingIngredients(1, new Object[]{"X#X", "#Y#", "X#X", Character.valueOf('#'), pb.M, Character.valueOf('X'), ForestryItem.gearTin, Character.valueOf('Y'), ForestryItem.hardenedMachine}));
        pack.energyConfig = new EnergyConfiguration(0, 0, 0, 0, 0);
        return pack;
    }
}

