/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory;

import forestry.api.fuels.FuelManager;
import forestry.api.fuels.RainSubstrate;
import forestry.core.Machine;
import forestry.core.MachineFactory;
import forestry.core.Mill;
import forestry.core.Proxy;
import forestry.core.TileMill;
import forestry.core.utils.Orientations;

public class MillRainmaker
extends Mill {
    private int duration;
    private boolean reverse;

    public MillRainmaker(TileMill tile) {
        super(tile);
        this.tileMill = tile;
        this.speed = 0.01f;
    }

    @Override
    public String getName() {
        return "Rainmaker";
    }

    @Override
    public void openGui(yw player, io tile) {
        if (Proxy.isMultiplayerWorld()) {
            return;
        }
        if (player.ap.b() == null) {
            return;
        }
        int usedItemId = player.ap.b().c;
        if (FuelManager.rainSubstrate.containsKey(usedItemId) && this.charge == 0) {
            RainSubstrate substrate = (RainSubstrate)FuelManager.rainSubstrate.get(usedItemId);
            if (substrate.item.a(player.ap.b())) {
                this.addCharge(substrate);
                --player.ap.b().a;
            }
        }
        this.tileMill.sendNetworkUpdate();
    }

    @Override
    public void readFromNBT(ady nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.charge = nbttagcompound.f("Charge");
        this.progress = nbttagcompound.h("Progress");
        this.stage = nbttagcompound.f("Stage");
        this.duration = nbttagcompound.f("Duration");
        this.reverse = nbttagcompound.o("Reverse");
    }

    @Override
    public void writeToNBT(ady nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("Charge", this.charge);
        nbttagcompound.a("Progress", this.progress);
        nbttagcompound.a("Stage", this.stage);
        nbttagcompound.a("Duration", this.duration);
        nbttagcompound.a("Reverse", this.reverse);
    }

    public void addCharge(RainSubstrate substrate) {
        this.charge = 1;
        this.speed = substrate.speed;
        this.duration = substrate.duration;
        this.reverse = substrate.reverse;
    }

    @Override
    public void activate() {
        if (Proxy.isClient()) {
            this.tileMill.i.a((double)this.tileMill.j, (double)this.tileMill.k, (double)this.tileMill.l, "ambient.weather.thunder", 4.0f, (1.0f + (this.tileMill.i.r.nextFloat() - this.tileMill.i.r.nextFloat()) * 0.2f) * 0.7f);
            float f = (float)this.tile.j + 0.5f;
            float f1 = (float)this.tile.k + 0.0f + this.tile.i.r.nextFloat() * 6.0f / 16.0f;
            float f2 = (float)this.tile.l + 0.5f;
            float f3 = 0.52f;
            float f4 = this.tile.i.r.nextFloat() * 0.6f - 0.3f;
            Proxy.addEntityExplodeFX(this.tile.i, f - f3, f1, f2 + f4, 0.0f, 0.0f, 0.0f);
            Proxy.addEntityExplodeFX(this.tile.i, f + f3, f1, f2 + f4, 0.0f, 0.0f, 0.0f);
            Proxy.addEntityExplodeFX(this.tile.i, f + f4, f1, f2 - f3, 0.0f, 0.0f, 0.0f);
            Proxy.addEntityExplodeFX(this.tile.i, f + f4, f1, f2 + f3, 0.0f, 0.0f, 0.0f);
        }
        if (!Proxy.isMultiplayerWorld()) {
            if (this.reverse) {
                this.tile.i.B().b(false);
            } else {
                this.tile.i.B().b(true);
                this.tile.i.B().f(this.duration);
            }
            this.charge = 0;
            this.duration = 0;
            this.reverse = false;
            this.tileMill.sendNetworkUpdate();
        }
    }

    @Override
    public boolean doWork() {
        return false;
    }

    @Override
    public boolean addItem(aan stack, boolean doAdd, Orientations from) {
        if (this.charge != 0) {
            return false;
        }
        if (!FuelManager.rainSubstrate.containsKey(stack.c)) {
            return false;
        }
        RainSubstrate substrate = (RainSubstrate)FuelManager.rainSubstrate.get(stack.c);
        if (!substrate.item.a(stack)) {
            return false;
        }
        if (doAdd) {
            this.addCharge(substrate);
            --stack.a;
        }
        return true;
    }

    public static class Factory
    extends MachineFactory {
        @Override
        public Machine createMachine(kw tile) {
            return new MillRainmaker((TileMill)tile);
        }
    }
}

