/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory;

import forestry.api.recipes.ICentrifugeManager;
import forestry.api.recipes.RecipeManagers;
import forestry.core.EnumErrorCode;
import forestry.core.ForestryCore;
import forestry.core.Machine;
import forestry.core.MachineFactory;
import forestry.core.TileMachine;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.network.GuiId;
import forestry.core.triggers.ForestryTrigger;
import forestry.core.triggers.Trigger;
import forestry.core.utils.Orientations;
import forestry.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class MachineCentrifuge
extends Machine {
    private aan[] inventoryStacks = new aan[10];
    public Recipe currentRecipe;
    private int resourceSlot = 0;
    private int inventorySlot1 = 1;
    private Stack pendingProducts = new Stack();
    private int productionTime;
    private int timePerItem;

    public MachineCentrifuge(TileMachine tile) {
        super(tile);
        this.setHints((String[])Config.hints.get("centrifuge"));
    }

    @Override
    public String getName() {
        return StringUtil.localize("tile.machine.8");
    }

    @Override
    public void openGui(yw player, io tile) {
        player.openGui((BaseMod)ForestryCore.instance, GuiId.CentrifugeGUI.ordinal(), player.k, this.tile.j, this.tile.k, this.tile.l);
    }

    @Override
    public void writeToNBT(ady nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("ProductionTime", this.productionTime);
        nbttagcompound.a("TimePerItem", this.timePerItem);
        no nbttaglist = new no();
        for (int i = 0; i < this.inventoryStacks.length; ++i) {
            if (this.inventoryStacks[i] == null) continue;
            ady nbttagcompound1 = new ady();
            nbttagcompound1.a("Slot", (byte)i);
            this.inventoryStacks[i].b(nbttagcompound1);
            nbttaglist.a((gh)nbttagcompound1);
        }
        nbttagcompound.a("Items", (gh)nbttaglist);
        nbttaglist = new no();
        aan[] offspring = this.pendingProducts.toArray(new aan[this.pendingProducts.size()]);
        for (int i = 0; i < offspring.length; ++i) {
            if (offspring[i] == null) continue;
            ady nbttagcompound1 = new ady();
            nbttagcompound1.a("Slot", (byte)i);
            offspring[i].b(nbttagcompound1);
            nbttaglist.a((gh)nbttagcompound1);
        }
        nbttagcompound.a("PendingProducts", (gh)nbttaglist);
    }

    @Override
    public void readFromNBT(ady nbttagcompound) {
        ady nbttagcompound1;
        int i;
        super.readFromNBT(nbttagcompound);
        this.productionTime = nbttagcompound.f("ProductionTime");
        this.timePerItem = nbttagcompound.f("TimePerItem");
        no nbttaglist = nbttagcompound.n("Items");
        this.inventoryStacks = new aan[this.getSizeInventory()];
        for (i = 0; i < nbttaglist.d(); ++i) {
            nbttagcompound1 = (ady)nbttaglist.a(i);
            byte byte0 = nbttagcompound1.d("Slot");
            if (byte0 < 0 || byte0 >= this.inventoryStacks.length) continue;
            this.inventoryStacks[byte0] = aan.a((ady)nbttagcompound1);
        }
        nbttaglist = nbttagcompound.n("PendingProducts");
        for (i = 0; i < nbttaglist.d(); ++i) {
            nbttagcompound1 = (ady)nbttaglist.a(i);
            this.pendingProducts.add(aan.a((ady)nbttagcompound1));
        }
        this.checkRecipe();
    }

    @Override
    public void update() {
        if (this.tile.i.w() % 20L * 10L != 0L) {
            return;
        }
        this.checkRecipe();
        if (this.getErrorState() == EnumErrorCode.NORECIPE && this.currentRecipe != null) {
            this.setErrorState(EnumErrorCode.OK);
        }
    }

    @Override
    public boolean doWork() {
        this.checkRecipe();
        if (this.tryAddPending()) {
            return false;
        }
        if (!this.pendingProducts.isEmpty()) {
            return false;
        }
        if (this.productionTime <= 0) {
            return false;
        }
        if (this.currentRecipe == null) {
            return false;
        }
        --this.productionTime;
        if (this.productionTime > 0) {
            this.setErrorState(EnumErrorCode.OK);
            return true;
        }
        for (Map.Entry entry : this.currentRecipe.products.entrySet()) {
            if ((Integer)entry.getValue() >= 100) {
                this.pendingProducts.push(((aan)entry.getKey()).k());
                continue;
            }
            if (this.tile.i.r.nextInt(100) >= (Integer)entry.getValue()) continue;
            this.pendingProducts.push(((aan)entry.getKey()).k());
        }
        --this.inventoryStacks[this.resourceSlot].a;
        if (this.inventoryStacks[this.resourceSlot].a <= 0) {
            this.inventoryStacks[this.resourceSlot] = null;
        }
        this.checkRecipe();
        this.resetRecipe();
        this.tryAddPending();
        return true;
    }

    public void checkRecipe() {
        Recipe sameRec = RecipeManager.findMatchingRecipe(this.inventoryStacks[this.resourceSlot]);
        if (sameRec == null) {
            this.setErrorState(EnumErrorCode.NORECIPE);
        }
        if (this.currentRecipe != sameRec) {
            this.currentRecipe = sameRec;
            this.resetRecipe();
        }
    }

    private void resetRecipe() {
        if (this.currentRecipe == null) {
            this.productionTime = 0;
            this.timePerItem = 0;
            return;
        }
        this.productionTime = this.currentRecipe.timePerItem;
        this.timePerItem = this.currentRecipe.timePerItem;
    }

    private boolean tryAddPending() {
        if (this.pendingProducts.isEmpty()) {
            return false;
        }
        aan next = (aan)this.pendingProducts.peek();
        if (this.addProduct(next, true)) {
            this.pendingProducts.pop();
            return true;
        }
        this.setErrorState(EnumErrorCode.NOSPACE);
        return false;
    }

    private boolean addProduct(aan product, boolean all) {
        for (int i = this.inventorySlot1; i < this.inventoryStacks.length; ++i) {
            int space;
            if (this.inventoryStacks[i] == null) {
                this.inventoryStacks[i] = product;
                return true;
            }
            if (!this.inventoryStacks[i].a(product) || (space = this.inventoryStacks[i].c() - this.inventoryStacks[i].a) <= 0) continue;
            if (space >= product.a) {
                this.inventoryStacks[i].a += product.a;
                product.a = 0;
                return true;
            }
            if (all) continue;
            this.inventoryStacks[i].a = this.inventoryStacks[i].c();
            product.a -= space;
            return true;
        }
        return false;
    }

    @Override
    public boolean isWorking() {
        return this.currentRecipe != null;
    }

    @Override
    public boolean hasResourcesMin(float percentage) {
        if (this.inventoryStacks[this.resourceSlot] == null) {
            return false;
        }
        return (float)this.inventoryStacks[this.resourceSlot].a / (float)this.inventoryStacks[this.resourceSlot].c() > percentage;
    }

    @Override
    public boolean hasWork() {
        return this.currentRecipe != null;
    }

    public int getProgressScaled(int i) {
        if (this.timePerItem == 0) {
            return i;
        }
        return this.productionTime * i / this.timePerItem;
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.productionTime = j;
                break;
            }
            case 1: {
                this.timePerItem = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(dd container, wm iCrafting) {
        iCrafting.a(container, 0, this.productionTime);
        iCrafting.a(container, 1, this.timePerItem);
    }

    @Override
    public int getSizeInventory() {
        return this.inventoryStacks.length;
    }

    @Override
    public aan getStackInSlot(int i) {
        return this.inventoryStacks[i];
    }

    @Override
    public aan decrStackSize(int i, int j) {
        if (this.inventoryStacks[i] == null) {
            return null;
        }
        if (this.inventoryStacks[i].a <= j) {
            aan product = this.inventoryStacks[i];
            this.inventoryStacks[i] = null;
            return product;
        }
        aan product = this.inventoryStacks[i].a(j);
        if (this.inventoryStacks[i].a == 0) {
            this.inventoryStacks[i] = null;
        }
        return product;
    }

    @Override
    public void setInventorySlotContents(int i, aan itemstack) {
        this.inventoryStacks[i] = itemstack;
        if (itemstack != null && itemstack.a > this.getInventoryStackLimit()) {
            itemstack.a = this.getInventoryStackLimit();
        }
    }

    @Override
    public aan getStackInSlotOnClosing(int slot) {
        if (this.inventoryStacks[slot] == null) {
            return null;
        }
        aan toReturn = this.inventoryStacks[slot];
        this.inventoryStacks[slot] = null;
        return toReturn;
    }

    @Override
    public int getStartInventorySide(int side) {
        if (side == 0 || side == 1) {
            return this.resourceSlot;
        }
        return this.inventorySlot1;
    }

    @Override
    public int getSizeInventorySide(int side) {
        if (side == 0 || side == 1) {
            return 1;
        }
        return 9;
    }

    @Override
    public aan extractItem(boolean doRemove, Orientations from) {
        aan product = null;
        for (int i = this.inventorySlot1; i < this.inventoryStacks.length; ++i) {
            if (this.inventoryStacks[i] == null) continue;
            product = new aan(this.inventoryStacks[i].c, 1, this.inventoryStacks[i].i());
            if (!doRemove) break;
            this.decrStackSize(i, 1);
            break;
        }
        return product;
    }

    @Override
    public boolean addItem(aan stack, boolean doAdd, Orientations from) {
        if (this.inventoryStacks[this.resourceSlot] == null) {
            if (doAdd) {
                this.inventoryStacks[this.resourceSlot] = stack.k();
                stack.a = 0;
            }
            return true;
        }
        if (!this.inventoryStacks[this.resourceSlot].a(stack)) {
            return false;
        }
        int space = this.inventoryStacks[this.resourceSlot].c() - this.inventoryStacks[this.resourceSlot].a;
        if (space <= 0) {
            return false;
        }
        if (doAdd) {
            if (stack.a <= space) {
                this.inventoryStacks[this.resourceSlot].a += stack.a;
                stack.a = 0;
            } else {
                this.inventoryStacks[this.resourceSlot].a += space;
                stack.a -= space;
            }
        }
        return true;
    }

    @Override
    public LinkedList getCustomTriggers() {
        LinkedList<Trigger> res = new LinkedList<Trigger>();
        res.add(ForestryTrigger.lowResource25);
        res.add(ForestryTrigger.lowResource10);
        res.add(ForestryTrigger.hasWork);
        return res;
    }

    public static void initialize() {
        RecipeManagers.centrifugeManager.addRecipe(20, new aan(ForestryItem.beeComb, 1, 0), new aan(ForestryItem.beeswax), new aan(ForestryItem.honeyDrop), 90);
        RecipeManagers.centrifugeManager.addRecipe(20, new aan(ForestryItem.beeComb, 1, 1), new aan(ForestryItem.beeswax), new aan(yr.aW, 1, 3), 50);
        RecipeManagers.centrifugeManager.addRecipe(20, new aan(ForestryItem.beeComb, 1, 2), new aan(ForestryItem.refractoryWax), new aan(ForestryItem.phosphor), 90);
        RecipeManagers.centrifugeManager.addRecipe(20, new aan(ForestryItem.beeComb, 1, 3), new aan(ForestryItem.propolis), new aan(ForestryItem.honeyDrop), 40);
        RecipeManagers.centrifugeManager.addRecipe(20, new aan(ForestryItem.beeComb, 1, 5), new aan(ForestryItem.honeydew), new aan(ForestryItem.honeyDrop), 40);
        RecipeManagers.centrifugeManager.addRecipe(20, new aan(ForestryItem.beeComb, 1, 4), new aan[]{new aan(ForestryItem.beeswax), new aan(ForestryItem.honeyDrop), new aan(yr.aD), new aan(ForestryItem.pollen, 1, 1)}, new int[]{80, 70, 20, 20});
        RecipeManagers.centrifugeManager.addRecipe(20, new aan(ForestryItem.beeComb, 1, 6), new aan(ForestryItem.honeyDrop), new aan(ForestryItem.propolis, 1, 3), 80);
        RecipeManagers.centrifugeManager.addRecipe(20, new aan(ForestryItem.beeComb, 1, 7), new aan(ForestryItem.beeswax), new aan(ForestryItem.honeyDrop), 90);
        RecipeManagers.centrifugeManager.addRecipe(20, new aan(ForestryItem.beeComb, 1, 8), new aan[]{new aan(ForestryItem.honeyDrop), new aan(ForestryItem.propolis, 1, 2)}, new int[]{40, 100});
        RecipeManagers.centrifugeManager.addRecipe(20, new aan(ForestryItem.beeComb, 1, 9), new aan[0], new int[0]);
        RecipeManagers.centrifugeManager.addRecipe(20, new aan(ForestryItem.beeComb, 1, 10), new aan[]{new aan(ForestryItem.honeyDrop), new aan(ForestryItem.beeswax), new aan(yr.M)}, new int[]{20, 20, 90});
        RecipeManagers.centrifugeManager.addRecipe(80, new aan(ForestryItem.beeComb, 1, 11), new aan[]{new aan(ForestryItem.honeyDrop, 2, 1)}, new int[]{100});
        RecipeManagers.centrifugeManager.addRecipe(80, new aan(ForestryItem.beeComb, 1, 12), new aan[]{new aan(ForestryItem.honeyDrop, 1, 1)}, new int[]{100});
        RecipeManagers.centrifugeManager.addRecipe(400, new aan(ForestryItem.beeComb, 1, 13), new aan[]{new aan(ForestryItem.honeyDrop, 1, 2)}, new int[]{100});
        RecipeManagers.centrifugeManager.addRecipe(20, new aan(ForestryItem.beeComb, 1, 14), new aan[]{new aan(ForestryItem.honeyDrop), new aan(ForestryItem.beeswax), new aan(yr.T)}, new int[]{20, 20, 80});
        RecipeManagers.centrifugeManager.addRecipe(20, new aan(ForestryItem.beeComb, 1, 15), new aan(ForestryItem.beeswax), new aan(ForestryItem.honeyDrop), 90);
        RecipeManagers.centrifugeManager.addRecipe(5, new aan(ForestryItem.propolis, 1, 3), new aan[]{new aan(ForestryItem.craftingMaterial, 1, 2), new aan(ForestryItem.propolis)}, new int[]{50, 50});
    }

    public static class RecipeManager
    implements ICentrifugeManager {
        public static ArrayList recipes = new ArrayList();

        @Override
        public void addRecipe(int timePerItem, aan resource, HashMap products) {
            recipes.add(new Recipe(timePerItem, resource, products));
        }

        @Override
        public void addRecipe(int timePerItem, aan resource, aan[] produce, int[] chances) {
            HashMap<aan, Integer> products = new HashMap<aan, Integer>();
            int i = 0;
            for (aan prod : produce) {
                products.put(prod, chances[i]);
                ++i;
            }
            this.addRecipe(timePerItem, resource, products);
        }

        @Override
        public void addRecipe(int timePerItem, aan resource, aan primary, aan secondary, int chance) {
            HashMap<aan, Integer> products = new HashMap<aan, Integer>();
            products.put(primary, 100);
            if (secondary != null) {
                products.put(secondary, chance);
            }
            this.addRecipe(timePerItem, resource, products);
        }

        @Override
        public void addRecipe(int timePerItem, aan resource, aan primary) {
            HashMap<aan, Integer> products = new HashMap<aan, Integer>();
            products.put(primary, 100);
            this.addRecipe(timePerItem, resource, products);
        }

        public static Recipe findMatchingRecipe(aan item) {
            for (int i = 0; i < recipes.size(); ++i) {
                Recipe recipe = (Recipe)recipes.get(i);
                if (!recipe.matches(item)) continue;
                return recipe;
            }
            return null;
        }

        @Override
        public List getRecipes() {
            HashMap<aan[], aan[]> recipeList = new HashMap<aan[], aan[]>();
            for (Recipe recipe : recipes) {
                recipeList.put(new aan[]{recipe.resource}, recipe.products.keySet().toArray(new aan[0]));
            }
            return (List)((Object)recipeList);
        }
    }

    public static class Recipe {
        public final int timePerItem;
        public final aan resource;
        public final HashMap products;

        public Recipe(int timePerItem, aan resource, HashMap products) {
            this.timePerItem = timePerItem;
            this.resource = resource;
            this.products = products;
        }

        public boolean matches(aan res) {
            if (res == null && this.resource == null) {
                return true;
            }
            if (res == null && this.resource != null) {
                return false;
            }
            if (res != null && this.resource == null) {
                return false;
            }
            return this.resource.a(res);
        }
    }

    public static class Factory
    extends MachineFactory {
        @Override
        public Machine createMachine(kw tile) {
            return new MachineCentrifuge((TileMachine)tile);
        }
    }
}

