/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory;

import forestry.api.core.ForestryBlock;
import forestry.api.liquids.LiquidContainer;
import forestry.api.liquids.LiquidManager;
import forestry.api.liquids.LiquidStack;
import forestry.api.recipes.ICarpenterManager;
import forestry.api.recipes.ItemGenericCrate;
import forestry.api.recipes.RecipeManagers;
import forestry.core.EnumErrorCode;
import forestry.core.ForestryCore;
import forestry.core.Machine;
import forestry.core.MachineFactory;
import forestry.core.TileMachine;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.network.EntityNetData;
import forestry.core.network.GuiId;
import forestry.core.triggers.ForestryTrigger;
import forestry.core.triggers.Trigger;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.CarpenterRecipe;
import forestry.core.utils.Orientations;
import forestry.core.utils.ShapedRecipe;
import forestry.core.utils.StringUtil;
import forestry.core.utils.TankLevel;
import forestry.core.utils.TankSlot;
import forestry.core.utils.Utils;
import forestry.factory.ContainerCarpenter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class MachineCarpenter
extends Machine {
    @EntityNetData
    public TankSlot resourceTank = new TankSlot(10000);
    private aan[] inventoryStacks = new aan[11];
    public Recipe currentRecipe;
    public ContainerCarpenter activeContainer;
    public boolean consumeRecipe = false;
    private int packageTime;
    private int totalTime;
    private aan currentProduct;
    private aan pendingProduct;
    private int craftingSlot1 = 0;
    private int boxSlot = 9;
    private int productSlot = 10;
    private int throttle = 0;

    public aan getBoxStack() {
        return this.inventoryStacks[this.boxSlot];
    }

    public MachineCarpenter(TileMachine tile) {
        super(tile);
        this.setHints((String[])Config.hints.get("carpenter"));
    }

    @Override
    public String getName() {
        return StringUtil.localize("tile.machine.5");
    }

    @Override
    public void openGui(yw player, io tile) {
        player.openGui((BaseMod)ForestryCore.instance, GuiId.CarpenterGUI.ordinal(), player.k, this.tile.j, this.tile.k, this.tile.l);
    }

    @Override
    public void writeToNBT(ady nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("PackageTime", this.packageTime);
        nbttagcompound.a("PackageTotalTime", this.totalTime);
        ady NBTresourceSlot = new ady();
        this.resourceTank.writeToNBT(NBTresourceSlot);
        nbttagcompound.a("ResourceTank", (gh)NBTresourceSlot);
        no nbttaglist = new no();
        for (int i = 0; i < this.inventoryStacks.length; ++i) {
            if (this.inventoryStacks[i] == null) continue;
            ady nbttagcompound1 = new ady();
            nbttagcompound1.a("Slot", (byte)i);
            this.inventoryStacks[i].b(nbttagcompound1);
            nbttaglist.a((gh)nbttagcompound1);
        }
        nbttagcompound.a("Items", (gh)nbttaglist);
        if (this.pendingProduct != null) {
            ady nbttagcompoundP = new ady();
            this.pendingProduct.b(nbttagcompoundP);
            nbttagcompound.a("PendingProduct", (gh)nbttagcompoundP);
        }
        if (this.currentProduct != null) {
            ady nbttagcompoundC = new ady();
            this.currentProduct.b(nbttagcompoundC);
            nbttagcompound.a("CurrentProduct", (gh)nbttagcompoundC);
        }
    }

    @Override
    public void readFromNBT(ady nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.packageTime = nbttagcompound.f("PackageTime");
        this.totalTime = nbttagcompound.f("PackageTotalTime");
        this.resourceTank = new TankSlot(10000);
        if (nbttagcompound.c("ResourceTank")) {
            this.resourceTank.readFromNBT(nbttagcompound.m("ResourceTank"));
        }
        no nbttaglist = nbttagcompound.n("Items");
        this.inventoryStacks = new aan[this.getSizeInventory()];
        for (int i = 0; i < nbttaglist.d(); ++i) {
            ady nbttagcompound1 = (ady)nbttaglist.a(i);
            byte byte0 = nbttagcompound1.d("Slot");
            if (byte0 < 0 || byte0 >= this.inventoryStacks.length) continue;
            this.inventoryStacks[byte0] = aan.a((ady)nbttagcompound1);
        }
        if (nbttagcompound.c("PendingProduct")) {
            ady nbttagcompoundP = nbttagcompound.m("PendingProduct");
            this.pendingProduct = aan.a((ady)nbttagcompoundP);
        }
        if (nbttagcompound.c("CurrentProduct")) {
            ady nbttagcompoundP = nbttagcompound.m("CurrentProduct");
            this.currentProduct = aan.a((ady)nbttagcompoundP);
        }
        ContainerCarpenter container = new ContainerCarpenter(this.tile);
        this.currentRecipe = RecipeManager.findMatchingRecipe(this.getBoxStack(), container.craftMatrix);
    }

    @Override
    public void update() {
        LiquidContainer container;
        if (this.currentRecipe == null) {
            this.setErrorState(EnumErrorCode.NORECIPE);
        } else if (this.getErrorState() == EnumErrorCode.NORECIPE) {
            this.setErrorState(EnumErrorCode.OK);
        }
        ++this.throttle;
        if (this.throttle > 60) {
            this.throttle = 0;
        }
        if (this.inventoryStacks[this.boxSlot] != null && (container = LiquidManager.getLiquidContainer(this.inventoryStacks[this.boxSlot])) != null && RecipeManager.isResourceLiquid(container.liquid)) {
            this.inventoryStacks[this.boxSlot] = this.replenishByContainer(this.inventoryStacks[this.boxSlot], container, this.resourceTank);
            if (this.inventoryStacks[this.boxSlot].a <= 0) {
                this.inventoryStacks[this.boxSlot] = null;
            }
        }
        if (this.throttle != 10) {
            return;
        }
        io[] inventories = BlockUtil.getAdjacentInventories(this.tile.i, this.tile.Coords());
        if (inventories.length <= 0) {
            return;
        }
        block0: for (int i = 0; i < 9; ++i) {
            if (this.inventoryStacks[i] == null) continue;
            boolean restocked = false;
            if (this.inventoryStacks[i].a != 1) continue;
            for (io inventory : inventories) {
                inventory = Utils.getChest(inventory);
                int slots = inventory.a();
                if (restocked) continue block0;
                for (int j = 0; j < slots && !restocked; ++j) {
                    aan stack = inventory.k_(j);
                    if (stack == null || stack.a <= 0 || !stack.a(this.inventoryStacks[i])) continue;
                    ++this.inventoryStacks[i].a;
                    inventory.a(j, 1);
                    restocked = true;
                }
            }
        }
    }

    @Override
    public boolean doWork() {
        if (this.packageTime > 0) {
            --this.packageTime;
            if (this.currentRecipe == null || !this.currentProduct.c(this.currentRecipe.getCraftingResult())) {
                this.currentProduct = null;
                this.totalTime = 0;
                this.packageTime = 0;
                return false;
            }
            this.setErrorState(EnumErrorCode.OK);
            if (this.packageTime <= 0) {
                this.pendingProduct = this.currentProduct;
                this.currentProduct = null;
                this.totalTime = 0;
                if (this.currentRecipe.liquid != null) {
                    this.resourceTank.quantity -= ((Recipe)this.currentRecipe).liquid.liquidAmount;
                }
                for (int j = 0; j < 9; ++j) {
                    if (this.inventoryStacks[j] == null) continue;
                    if (this.inventoryStacks[j].a > 1) {
                        --this.inventoryStacks[j].a;
                        continue;
                    }
                    this.inventoryStacks[j] = null;
                }
                if (this.currentRecipe.box != null) {
                    if (this.inventoryStacks[this.boxSlot].a > 1) {
                        --this.inventoryStacks[this.boxSlot].a;
                    } else {
                        this.inventoryStacks[this.boxSlot] = null;
                    }
                }
                if (this.activeContainer != null) {
                    this.activeContainer.updateProductDisplay();
                }
                return this.tryAddPending();
            }
            return true;
        }
        if (this.pendingProduct != null) {
            return this.tryAddPending();
        }
        if (this.currentRecipe != null) {
            if (!this.validateResources()) {
                return false;
            }
            this.packageTime = this.totalTime = this.currentRecipe.packagingTime;
            this.currentProduct = this.currentRecipe.getCraftingResult();
            if (this.consumeRecipe) {
                this.consumeRecipe = false;
            }
            if (this.activeContainer != null) {
                this.activeContainer.updateProductDisplay();
            }
            return true;
        }
        this.setErrorState(EnumErrorCode.OK);
        return false;
    }

    private boolean validateResources() {
        if (this.currentRecipe.liquid != null && this.resourceTank.quantity < ((Recipe)this.currentRecipe).liquid.liquidAmount) {
            return false;
        }
        if (this.currentRecipe.box != null && this.inventoryStacks[this.boxSlot] == null) {
            return false;
        }
        boolean flag = false;
        for (int i = 0; i < 9; ++i) {
            if (this.inventoryStacks[i] == null) continue;
            if (this.consumeRecipe && this.inventoryStacks[i].a == 1 || this.inventoryStacks[i].a > 1) {
                flag = true;
                continue;
            }
            flag = false;
            break;
        }
        if (!flag) {
            this.setErrorState(EnumErrorCode.NORESOURCE);
        }
        return flag;
    }

    private boolean tryAddPending() {
        if (this.inventoryStacks[this.productSlot] == null) {
            this.inventoryStacks[this.productSlot] = this.pendingProduct.k();
            this.pendingProduct = null;
            return true;
        }
        if (this.inventoryStacks[this.productSlot].a(this.pendingProduct) && this.inventoryStacks[this.productSlot].a <= this.inventoryStacks[this.productSlot].c() - this.pendingProduct.a) {
            this.inventoryStacks[this.productSlot].a += this.pendingProduct.a;
            this.pendingProduct = null;
            return true;
        }
        this.setErrorState(EnumErrorCode.NOSPACE);
        return false;
    }

    @Override
    public boolean isWorking() {
        return this.packageTime > 0;
    }

    @Override
    public boolean hasWork() {
        if (this.currentRecipe == null) {
            return false;
        }
        if (this.inventoryStacks[this.productSlot] != null && this.inventoryStacks[this.productSlot].c() - this.inventoryStacks[this.productSlot].a < this.currentRecipe.getCraftingResult().a) {
            return false;
        }
        return this.validateResources();
    }

    public int getCraftingProgressScaled(int i) {
        if (this.totalTime == 0) {
            return 0;
        }
        return this.packageTime * i / this.totalTime;
    }

    public int getResourceScaled(int i) {
        return this.resourceTank.quantity * i / 10000;
    }

    @Override
    public TankLevel getPrimaryLevel() {
        return this.rateTankLevel(this.getResourceScaled(100));
    }

    @Override
    public int getSizeInventory() {
        return this.inventoryStacks.length;
    }

    @Override
    public aan getStackInSlot(int i) {
        return this.inventoryStacks[i];
    }

    @Override
    public void setInventorySlotContents(int i, aan itemstack) {
        this.inventoryStacks[i] = itemstack;
    }

    @Override
    public aan decrStackSize(int i, int j) {
        if (this.inventoryStacks[i] == null) {
            return null;
        }
        if (this.inventoryStacks[i].a <= j) {
            aan removed = this.inventoryStacks[i];
            this.inventoryStacks[i] = null;
            return removed;
        }
        aan removed = this.inventoryStacks[i].a(j);
        if (this.inventoryStacks[i].a == 0) {
            this.inventoryStacks[i] = null;
        }
        return removed;
    }

    @Override
    public aan getStackInSlotOnClosing(int slot) {
        if (this.inventoryStacks[slot] == null) {
            return null;
        }
        aan toReturn = this.inventoryStacks[slot];
        this.inventoryStacks[slot] = null;
        return toReturn;
    }

    @Override
    public int getStartInventorySide(int side) {
        if (side == 0) {
            return this.productSlot;
        }
        if (side == 1) {
            return this.boxSlot;
        }
        return this.craftingSlot1;
    }

    @Override
    public int getSizeInventorySide(int side) {
        if (side == 0) {
            return 1;
        }
        if (side == 1) {
            return 1;
        }
        return 9;
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.packageTime = j;
                break;
            }
            case 1: {
                this.totalTime = j;
                break;
            }
            case 2: {
                this.resourceTank.liquidId = j;
                break;
            }
            case 3: {
                this.resourceTank.quantity = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(dd container, wm iCrafting) {
        iCrafting.a(container, 0, this.packageTime);
        iCrafting.a(container, 1, this.totalTime);
        iCrafting.a(container, 2, this.resourceTank.liquidId);
        iCrafting.a(container, 3, this.resourceTank.quantity);
    }

    @Override
    public boolean addItem(aan stack, boolean doAdd, Orientations from) {
        if (from == Orientations.YPos || from == Orientations.YNeg) {
            if (this.getBoxStack() == null) {
                if (doAdd) {
                    this.inventoryStacks[this.boxSlot] = stack.k();
                    stack.a = 0;
                }
                return true;
            }
            if (!this.getBoxStack().a(stack)) {
                return false;
            }
            if (this.getBoxStack().a >= this.getBoxStack().a().f()) {
                return false;
            }
            int space = this.getBoxStack().a().f() - this.getBoxStack().a;
            if (space < stack.a) {
                return false;
            }
            if (doAdd) {
                this.getBoxStack().a += stack.a;
                stack.a = 0;
            }
            return true;
        }
        return this.addItemToCraftMatrix(stack, doAdd);
    }

    private boolean addItemToCraftMatrix(aan stack, boolean doAdd) {
        int minStackSize = 0;
        int stackToAdd = -1;
        for (int i = 0; i < 9; ++i) {
            int space;
            if (this.inventoryStacks[i] == null || !this.inventoryStacks[i].a(stack) || this.inventoryStacks[i].a >= this.inventoryStacks[i].c() || (space = this.inventoryStacks[i].c() - this.inventoryStacks[i].a) < stack.a) continue;
            if (minStackSize == 0) {
                minStackSize = this.inventoryStacks[i].a;
                stackToAdd = i;
                continue;
            }
            if (this.inventoryStacks[i].a >= minStackSize) continue;
            stackToAdd = i;
        }
        if (stackToAdd < 0) {
            return false;
        }
        if (doAdd) {
            this.inventoryStacks[stackToAdd].a += stack.a;
            stack.a = 0;
        }
        return true;
    }

    @Override
    public aan extractItem(boolean doRemove, Orientations from) {
        if (this.inventoryStacks[this.productSlot] == null) {
            return null;
        }
        if (this.inventoryStacks[this.productSlot].a <= 0) {
            return null;
        }
        aan product = new aan(this.inventoryStacks[this.productSlot].c, 1, this.inventoryStacks[this.productSlot].i());
        if (doRemove) {
            --this.inventoryStacks[this.productSlot].a;
            if (this.inventoryStacks[this.productSlot].a <= 0) {
                this.inventoryStacks[this.productSlot] = null;
            }
        }
        return product;
    }

    @Override
    public int fill(Orientations from, int quantity, int id, boolean doFill) {
        int used = this.resourceTank.fill(from, quantity, id, doFill);
        if (doFill && used > 0) {
            this.tile.sendNetworkUpdate();
        }
        return used;
    }

    @Override
    public int getCapacity() {
        return 10000;
    }

    @Override
    public TankSlot[] getContents() {
        return new TankSlot[]{this.resourceTank};
    }

    @Override
    public LinkedList getCustomTriggers() {
        LinkedList<Trigger> res = new LinkedList<Trigger>();
        res.add(ForestryTrigger.hasWork);
        return res;
    }

    public static void initialize() {
        RecipeManagers.carpenterManager.addRecipe(10, new LiquidStack(pb.B.bO, 250), null, new aan(ForestryItem.oakStick, 2), new Object[]{"#", "#", Character.valueOf('#'), pb.J});
        RecipeManagers.carpenterManager.addRecipe(5, new LiquidStack(pb.B.bO, 250), null, new aan(ForestryItem.woodPulp, 4), new Object[]{"#", Character.valueOf('#'), pb.J});
        RecipeManagers.carpenterManager.addRecipe(5, new LiquidStack(pb.B.bO, 250), null, new aan(yr.aK, 1), new Object[]{"#", "#", Character.valueOf('#'), ForestryItem.woodPulp});
        CarpenterRecipe humus = new CarpenterRecipe(5, new LiquidStack(pb.B.bO, 1000), null, new aan(ForestryBlock.soil, 9, 0), new Object[]{"###", "#X#", "###", Character.valueOf('#'), pb.v, Character.valueOf('X'), ForestryItem.mulch});
        ForestryCore.oreHandler.registerCarpenterRecipe(humus);
        CarpenterRecipe bogEarth = new CarpenterRecipe(5, new LiquidStack(pb.B.bO, 1000), null, new aan(ForestryBlock.soil, 8, 1), new Object[]{"#X#", "XYX", "#X#", Character.valueOf('#'), pb.v, Character.valueOf('X'), pb.E, Character.valueOf('Y'), ForestryItem.mulch});
        ForestryCore.oreHandler.registerCarpenterRecipe(bogEarth);
        CarpenterRecipe hardenedMachine = new CarpenterRecipe(75, new LiquidStack(pb.B.bO, 5000), null, new aan(ForestryItem.hardenedMachine), new Object[]{"# #", " Y ", "# #", Character.valueOf('#'), yr.n, Character.valueOf('Y'), ForestryItem.sturdyMachine});
        ForestryCore.oreHandler.registerCarpenterRecipe(hardenedMachine);
        CarpenterRecipe iodineCapsule = new CarpenterRecipe(5, new LiquidStack(pb.B.bO, 1000), null, new aan(ForestryItem.iodineCharge, 1), new Object[]{"Z#Z", "#Y#", "X#X", Character.valueOf('#'), ForestryItem.pollen, Character.valueOf('X'), yr.M, Character.valueOf('Y'), ForestryItem.canEmpty, Character.valueOf('Z'), ForestryItem.honeyDrop});
        ForestryCore.oreHandler.registerCarpenterRecipe(iodineCapsule);
        CarpenterRecipe dissipationCharge = new CarpenterRecipe(5, new LiquidStack(pb.B.bO, 1000), null, new aan(ForestryItem.craftingMaterial, 1, 4), new Object[]{"Z#Z", "#Y#", "X#X", Character.valueOf('#'), ForestryItem.royalJelly, Character.valueOf('X'), yr.M, Character.valueOf('Y'), ForestryItem.canEmpty, Character.valueOf('Z'), ForestryItem.honeydew});
        ForestryCore.oreHandler.registerCarpenterRecipe(dissipationCharge);
        RecipeManagers.carpenterManager.addRecipe(200, new LiquidStack(pb.B.bO, 1000), null, new aan(ForestryItem.minerBackpackT2), new Object[]{"WXW", "WTW", "WWW", Character.valueOf('X'), yr.n, Character.valueOf('W'), new aan(ForestryItem.craftingMaterial, 1, 3), Character.valueOf('T'), ForestryItem.minerBackpack});
        RecipeManagers.carpenterManager.addRecipe(200, new LiquidStack(pb.B.bO, 1000), null, new aan(ForestryItem.diggerBackpackT2), new Object[]{"WXW", "WTW", "WWW", Character.valueOf('X'), yr.n, Character.valueOf('W'), new aan(ForestryItem.craftingMaterial, 1, 3), Character.valueOf('T'), ForestryItem.diggerBackpack});
        RecipeManagers.carpenterManager.addRecipe(200, new LiquidStack(pb.B.bO, 1000), null, new aan(ForestryItem.foresterBackpackT2), new Object[]{"WXW", "WTW", "WWW", Character.valueOf('X'), yr.n, Character.valueOf('W'), new aan(ForestryItem.craftingMaterial, 1, 3), Character.valueOf('T'), ForestryItem.foresterBackpack});
        RecipeManagers.carpenterManager.addRecipe(200, new LiquidStack(pb.B.bO, 1000), null, new aan(ForestryItem.hunterBackpackT2), new Object[]{"WXW", "WTW", "WWW", Character.valueOf('X'), yr.n, Character.valueOf('W'), new aan(ForestryItem.craftingMaterial, 1, 3), Character.valueOf('T'), ForestryItem.hunterBackpack});
        RecipeManagers.carpenterManager.addRecipe(200, new LiquidStack(pb.B.bO, 1000), null, new aan(ForestryItem.adventurerBackpackT2), new Object[]{"WXW", "WTW", "WWW", Character.valueOf('X'), yr.n, Character.valueOf('W'), new aan(ForestryItem.craftingMaterial, 1, 3), Character.valueOf('T'), ForestryItem.adventurerBackpack});
        RecipeManagers.carpenterManager.addRecipe(200, new LiquidStack(pb.B.bO, 1000), null, new aan(ForestryItem.builderBackpackT2), new Object[]{"WXW", "WTW", "WWW", Character.valueOf('X'), yr.n, Character.valueOf('W'), new aan(ForestryItem.craftingMaterial, 1, 3), Character.valueOf('T'), ForestryItem.builderBackpack});
        RecipeManagers.carpenterManager.addRecipe(100, null, new aan(yr.bn, 1), new Object[]{" # ", "###", " # ", Character.valueOf('#'), new aan(ForestryItem.craftingMaterial, 1, 1)});
        RecipeManagers.carpenterManager.addRecipe(10, new LiquidStack(pb.B.bO, 500), null, new aan(ForestryItem.craftingMaterial, 1, 3), new Object[]{"###", "###", "###", Character.valueOf('#'), new aan(ForestryItem.craftingMaterial, 1, 2)});
        RecipeManagers.carpenterManager.addRecipe(5, new LiquidStack(pb.B.bO, 1000), null, new aan(ForestryItem.carton, 2), new Object[]{" # ", "# #", " # ", Character.valueOf('#'), ForestryItem.woodPulp});
        RecipeManagers.carpenterManager.addRecipe(20, new LiquidStack(pb.B.bO, 1000), null, new aan(ForestryItem.crate, 24), new Object[]{" # ", "# #", " # ", Character.valueOf('#'), pb.J});
        CarpenterRecipe kitPickaxe = new CarpenterRecipe(20, new LiquidStack(0, 0), new aan(ForestryItem.carton), new aan(ForestryItem.kitPickaxe), new Object[]{"###", " X ", " X ", Character.valueOf('#'), ForestryItem.ingotBronze, Character.valueOf('X'), ForestryItem.oakStick});
        ForestryCore.oreHandler.registerCarpenterRecipe(kitPickaxe);
        CarpenterRecipe kitShovel = new CarpenterRecipe(20, new LiquidStack(0, 0), new aan(ForestryItem.carton), new aan(ForestryItem.kitShovel), new Object[]{" # ", " X ", " X ", Character.valueOf('#'), ForestryItem.ingotBronze, Character.valueOf('X'), ForestryItem.oakStick});
        ForestryCore.oreHandler.registerCarpenterRecipe(kitShovel);
        RecipeManagers.carpenterManager.addRecipe(null, new aan(ForestryItem.ingotBronze.c, 2, ForestryItem.ingotBronze.j()), new Object[]{"#", Character.valueOf('#'), ForestryItem.brokenBronzePickaxe});
        RecipeManagers.carpenterManager.addRecipe(null, ForestryItem.ingotBronze, new Object[]{"#", Character.valueOf('#'), ForestryItem.brokenBronzeShovel});
        CarpenterRecipe beealyzer = new CarpenterRecipe(100, new LiquidStack(pb.B.bO, 2000), null, new aan(ForestryItem.beealyzer), new Object[]{"X#X", "X#X", "RDR", Character.valueOf('#'), pb.bq, Character.valueOf('X'), ForestryItem.ingotTin, Character.valueOf('R'), yr.aC, Character.valueOf('D'), yr.n});
        ForestryCore.oreHandler.registerCarpenterRecipe(beealyzer);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedWood);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedCobblestone);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedDirt);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedStone);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedBrick);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedCacti);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedSand);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedObsidian);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedNetherrack);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedSoulsand);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedSandstone);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedBogearth);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedHumus);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedNetherbrick);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedPeat);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedApatite);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedFertilizer);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedTin);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedCopper);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedBronze);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedWheat);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedMycelium);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedMulch);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedCookies);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedHoneycombs);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedBeeswax);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedPollen);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedPropolis);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedHoneydew);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedRoyalJelly);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedCocoaComb);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedRedstone);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedLapis);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedReeds);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedClay);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedGlowstone);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedApples);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedNetherwart);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedSimmeringCombs);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedStringyCombs);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedFrozenCombs);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedDrippingCombs);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedRefractoryWax);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedPhosphor);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedAsh);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedCharcoal);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedGravel);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedCoal);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedSeeds);
        RecipeManagers.carpenterManager.addCrating(ForestryItem.cratedSaplings);
    }

    public static class RecipeManager
    implements ICarpenterManager {
        private static ArrayList recipes = new ArrayList();

        @Override
        public void addCrating(ItemGenericCrate crated) {
            this.addCrating(crated.contained, new aan((yr)crated));
        }

        @Override
        public void addCrating(yr toCrate, yr crated) {
            this.addCrating(new aan(toCrate), new aan(crated));
        }

        @Override
        public void addCrating(aan toCrate, aan crated) {
            this.addRecipe(5, new LiquidStack(pb.B.bO, 100), new aan(ForestryItem.crate), crated, new Object[]{"###", "###", "###", Character.valueOf('#'), toCrate});
            this.addRecipe(null, new aan(toCrate.c, 9, toCrate.i()), new Object[]{"#", Character.valueOf('#'), crated});
        }

        @Override
        public void addRecipe(aan box, aan product, Object[] materials) {
            this.addRecipe(5, null, box, product, materials);
        }

        @Override
        public void addRecipe(int packagingTime, aan box, aan product, Object[] materials) {
            this.addRecipe(packagingTime, null, box, product, materials);
        }

        @Override
        public void addRecipe(int packagingTime, LiquidStack liquid, aan box, aan product, Object[] materials) {
            String s = "";
            int i = 0;
            int j = 0;
            int k = 0;
            if (materials[i] instanceof String[]) {
                String[] as = (String[])materials[i++];
                for (int l = 0; l < as.length; ++l) {
                    String s2 = as[l];
                    ++k;
                    j = s2.length();
                    s = s + s2;
                }
            } else {
                while (materials[i] instanceof String) {
                    String s1 = (String)materials[i++];
                    ++k;
                    j = s1.length();
                    s = s + s1;
                }
            }
            HashMap<Character, aan> hashmap = new HashMap<Character, aan>();
            while (i < materials.length) {
                Character character = (Character)materials[i];
                aan itemstack1 = null;
                if (materials[i + 1] instanceof yr) {
                    itemstack1 = new aan((yr)materials[i + 1]);
                } else if (materials[i + 1] instanceof pb) {
                    itemstack1 = new aan((pb)materials[i + 1], 1, -1);
                } else if (materials[i + 1] instanceof aan) {
                    itemstack1 = (aan)materials[i + 1];
                }
                hashmap.put(character, itemstack1);
                i += 2;
            }
            aan[] aitemstack = new aan[j * k];
            for (int i1 = 0; i1 < j * k; ++i1) {
                char c = s.charAt(i1);
                aitemstack[i1] = hashmap.containsKey(Character.valueOf(c)) ? ((aan)hashmap.get(Character.valueOf(c))).k() : null;
            }
            recipes.add(new Recipe(packagingTime, liquid, box, new ShapedRecipe(j, k, aitemstack, product)));
        }

        public static Recipe findMatchingRecipe(aan item, ade inventorycrafting) {
            for (int i = 0; i < recipes.size(); ++i) {
                Recipe recipe = (Recipe)recipes.get(i);
                if (!recipe.matches(item, inventorycrafting)) continue;
                return recipe;
            }
            return null;
        }

        public static boolean isResourceLiquid(LiquidStack liquid) {
            for (Recipe recipe : recipes) {
                if (!recipe.hasLiquid(liquid)) continue;
                return true;
            }
            return false;
        }

        @Override
        public List getRecipes() {
            HashMap<aan[], aan[]> recipeList = new HashMap<aan[], aan[]>();
            for (Recipe recipe : recipes) {
                recipeList.put(recipe.internal.getIngredients(), new aan[]{recipe.getCraftingResult()});
            }
            return (List)((Object)recipeList);
        }
    }

    public static class Recipe {
        private int packagingTime;
        private LiquidStack liquid;
        private aan box;
        private ShapedRecipe internal;

        public Recipe(int packagingTime, LiquidStack liquid, aan box, ShapedRecipe internal) {
            this.packagingTime = packagingTime;
            this.liquid = liquid;
            this.box = box;
            this.internal = internal;
        }

        public aan getCraftingResult() {
            return this.internal.getProduct();
        }

        public boolean matches(aan item, ade inventorycrafting) {
            if (this.box != null && item == null) {
                return false;
            }
            if (this.box != null && !this.box.a(item)) {
                return false;
            }
            return this.internal.matches(inventorycrafting);
        }

        public boolean hasLiquid(LiquidStack resource) {
            if (this.liquid != null && resource != null) {
                return this.liquid.isLiquidEqual(resource);
            }
            return false;
        }
    }

    public static class Factory
    extends MachineFactory {
        @Override
        public Machine createMachine(kw tile) {
            return new MachineCarpenter((TileMachine)tile);
        }
    }
}

