/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy;

import forestry.core.Engine;
import forestry.core.TileForestry;
import forestry.core.utils.ContainerForestry;
import forestry.core.utils.GuiForestry;
import forestry.core.utils.StringUtil;

public abstract class GuiEngine
extends GuiForestry {
    public GuiEngine(String texture, ContainerForestry container, TileForestry tile) {
        super(texture, container, tile);
    }

    @Override
    protected void initLedgers(io inventory) {
        super.initLedgers(inventory);
        this.ledgerManager.insert(new EngineLedger((Engine)this.tile.getMachine()));
    }

    protected class EngineLedger
    extends GuiForestry.Ledger {
        private Engine engine;

        public EngineLedger(Engine engine) {
            this.engine = engine;
            this.maxHeight = 94;
            this.overlayColor = 13921311;
        }

        @Override
        public void draw(int x, int y) {
            this.drawBackground(x, y);
            this.drawIcon("/gfx/gui/misc.png", 0, x + 3, y + 4);
            if (!this.isFullyOpened()) {
                return;
            }
            GuiEngine.this.u.a(StringUtil.localize("gui.energy"), x + 22, y + 8, 14797103);
            GuiEngine.this.u.a(StringUtil.localize("gui.currentOutput") + ":", x + 22, y + 20, 11186104);
            GuiEngine.this.u.b(this.engine.getCurrentOutput() + " MJ/t", x + 22, y + 32, 0);
            GuiEngine.this.u.a(StringUtil.localize("gui.stored") + ":", x + 22, y + 44, 11186104);
            GuiEngine.this.u.b(this.engine.getEnergyStored() + " MJ", x + 22, y + 56, 0);
            GuiEngine.this.u.a(StringUtil.localize("gui.heat") + ":", x + 22, y + 68, 11186104);
            GuiEngine.this.u.b((double)this.engine.getHeat() / 10.0 + " \u00b0C", x + 22, y + 80, 0);
        }

        @Override
        public String getTooltip() {
            return this.engine.getCurrentOutput() + " MJ/t";
        }
    }
}

