/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy;

import forestry.core.Engine;
import forestry.core.EngineFactory;
import forestry.core.EnumErrorCode;
import forestry.core.ForestryCore;
import forestry.core.TemperatureState;
import forestry.core.TileEngine;
import forestry.core.config.Config;
import forestry.core.network.GuiId;
import forestry.core.utils.ContainerForestry;
import forestry.core.utils.DelayTimer;
import forestry.core.utils.ManagedInventory;
import forestry.core.utils.TankLevel;
import forestry.plugins.PluginIC2;
import ic2.api.Direction;
import ic2.api.ElectricItem;
import ic2.api.EnergyNet;

public class EngineTin
extends Engine {
    private static EuConfig basic = new EuConfig(6, 2, 12);
    private static EuConfig choked = new EuConfig(4, 1, 12);
    private short batterySlot = 0;
    private ManagedInventory inventory = new ManagedInventory(1, "electrical");
    private aan[] sockets = new aan[1];
    private boolean isAddedToEnergyNet = false;
    private int euStored = 0;
    private EuConfig euConfig;
    private DelayTimer delayUpdateTimer = new DelayTimer();

    public EngineTin(TileEngine tile) {
        super(tile);
        this.setHints((String[])Config.hints.get("engine.tin"));
        this.maxEnergy = 10000;
        this.maxEnergyExtracted = 400;
        this.maxHeat = 3000;
        this.euConfig = basic;
    }

    @Override
    public void openGui(yw player, kw tile) {
        player.openGui((BaseMod)ForestryCore.instance, GuiId.EngineTinGUI.ordinal(), player.k, tile.j, tile.k, tile.l);
    }

    @Override
    public void readFromNBT(ady nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.euStored = nbttagcompound.f("EngineEnergyStored");
        this.inventory.a(nbttagcompound);
    }

    @Override
    public void writeToNBT(ady nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("EngineEnergyStored", this.euStored);
        this.inventory.b(nbttagcompound);
    }

    @Override
    public int dissipateHeat() {
        TemperatureState tempState;
        if (this.heat <= 0) {
            return 0;
        }
        int loss = 0;
        if (!this.isBurning() || !this.tile.isActivated()) {
            ++loss;
        }
        if ((tempState = this.getTemperatureState()) == TemperatureState.OVERHEATING || tempState == TemperatureState.OPERATING_TEMPERATURE) {
            ++loss;
        }
        this.heat -= loss;
        return loss;
    }

    @Override
    public int generateHeat() {
        int gain = 0;
        if (this.tile.isActivated() && this.isBurning()) {
            ++gain;
            if ((double)this.storedEnergy / (double)this.maxEnergy > 0.5) {
                ++gain;
            }
        }
        this.addHeat(gain);
        return gain;
    }

    @Override
    public void update() {
        if (!PluginIC2.instance.isAvailable()) {
            this.setErrorState(EnumErrorCode.NOENERGYNET);
            return;
        }
        if (!this.isAddedToEnergyNet) {
            EnergyNet.getForWorld(this.tile.i).addTileEntity(this.tile);
            this.isAddedToEnergyNet = true;
        }
        super.update();
        if (this.forceCooldown) {
            this.setErrorState(EnumErrorCode.FORCEDCOOLDOWN);
            return;
        }
        if (this.inventory.k_(this.batterySlot) != null) {
            this.replenishFromBattery(this.batterySlot);
        }
        if (!this.delayUpdateTimer.delayPassed(this.tile.i, 80L)) {
            return;
        }
        if (this.currentOutput <= 0 && this.getErrorState() == EnumErrorCode.OK) {
            this.setErrorState(EnumErrorCode.NOFUEL);
        } else {
            this.setErrorState(EnumErrorCode.OK);
        }
    }

    @Override
    public void burn() {
        if (!this.tile.isActivated()) {
            return;
        }
        if (this.euStored >= this.euConfig.euForCycle) {
            this.currentOutput = this.euConfig.mjPerCycle;
            this.addEnergy(this.euConfig.mjPerCycle);
            this.euStored -= this.euConfig.euForCycle;
        }
    }

    private void replenishFromBattery(int slot) {
        if (this.euStored >= this.euConfig.euStorage) {
            return;
        }
        if (!this.tile.isActivated()) {
            return;
        }
        aan itemstack = this.inventory.k_(slot);
        if (itemstack == null) {
            return;
        }
        if (itemstack.c != PluginIC2.chargedReBattery.c && itemstack.c != PluginIC2.energyCrystal.c && itemstack.c != PluginIC2.lapotronCrystal.c) {
            return;
        }
        int space = this.euConfig.euStorage - this.euStored;
        if (space >= this.euConfig.euForCycle * 3) {
            space = this.euConfig.euForCycle * 3;
        }
        this.euStored += ElectricItem.discharge(itemstack, space, 2, true, false);
    }

    @Override
    public boolean isBurning() {
        return this.mayBurn() && this.euStored >= this.euConfig.euForCycle;
    }

    public int getStorageScaled(int i) {
        return this.euStored * i / this.euConfig.euStorage;
    }

    public TankLevel rateLevel(int scaled) {
        if (scaled < 5) {
            return TankLevel.EMPTY;
        }
        if (scaled < 30) {
            return TankLevel.LOW;
        }
        if (scaled < 60) {
            return TankLevel.MEDIUM;
        }
        if (scaled < 90) {
            return TankLevel.HIGH;
        }
        return TankLevel.MAXIMUM;
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.currentOutput = j;
                break;
            }
            case 1: {
                this.storedEnergy = j;
                break;
            }
            case 2: {
                this.heat = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(ContainerForestry containerEngine, wm iCrafting) {
        iCrafting.a((dd)containerEngine, 0, this.currentOutput);
        iCrafting.a((dd)containerEngine, 1, this.storedEnergy);
        iCrafting.a((dd)containerEngine, 2, this.heat);
    }

    @Override
    public boolean acceptsEnergyFrom(kw emitter, Direction direction) {
        return true;
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this.isAddedToEnergyNet;
    }

    @Override
    public boolean demandsEnergy() {
        if (this.tile.isActivated()) {
            return this.euStored < 2 * this.euConfig.euForCycle - 1;
        }
        return false;
    }

    @Override
    public int injectEnergy(Direction directionFrom, int amount) {
        if (!this.tile.isActivated()) {
            return amount;
        }
        int space = this.euConfig.euStorage - this.euStored;
        if (amount < space) {
            this.euStored += amount;
            return 0;
        }
        this.euStored = this.euConfig.euStorage;
        return amount - space;
    }

    @Override
    public int getSizeInventory() {
        return this.inventory.a();
    }

    @Override
    public aan getStackInSlot(int i) {
        return this.inventory.k_(i);
    }

    @Override
    public aan decrStackSize(int i, int j) {
        return this.inventory.a(i, j);
    }

    @Override
    public void setInventorySlotContents(int i, aan itemstack) {
        this.inventory.a(i, itemstack);
    }

    @Override
    public int getInventoryStackLimit() {
        return this.inventory.d();
    }

    public aan getStackInSlotOnClosing(int slot) {
        return this.inventory.b(slot);
    }

    protected static class EuConfig {
        public final int euForCycle;
        public final int mjPerCycle;
        public final int euStorage;

        public EuConfig(int euForCycle, int mjPerCycle, int euStorage) {
            this.euForCycle = euForCycle;
            this.mjPerCycle = mjPerCycle;
            this.euStorage = euStorage;
        }
    }

    public static class Factory
    extends EngineFactory {
        @Override
        public Engine createEngine(kw tile) {
            return new EngineTin((TileEngine)tile);
        }
    }
}

