/*
 * Decompiled with CFR 0.152.
 */
package forestry.cultivation.harvesters;

import forestry.api.cultivation.ICropEntity;
import forestry.api.cultivation.ICropProvider;
import forestry.core.Machine;
import forestry.core.Proxy;
import forestry.core.TileMachine;
import forestry.core.config.Config;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.Orientations;
import forestry.core.utils.Utils;
import forestry.core.utils.Vect;
import forestry.cultivation.TilePlanter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class Harvester
extends Machine {
    private HashMap validWindfallById = new HashMap();
    protected ArrayList cropProviders = new ArrayList();
    protected boolean isSideSensitive = true;
    protected aan[] harvestStacks = new aan[8];
    protected Vect area = new Vect(21, 13, 21);
    protected Vect posOffset = new Vect(-10, -2, -10);
    protected Vect posCurrent = new Vect(0, 0, 0);
    protected Vect posNext = null;
    protected boolean isFinished = false;
    private short productSlot1 = 0;
    private short windfallSlot1 = (short)4;

    public void putWindfall(aan windfall) {
        this.validWindfallById.put(windfall.c, windfall);
    }

    public boolean isCropAt(int x, int y, int z) {
        for (ICropProvider provider : this.cropProviders) {
            if (!provider.isCrop(this.tile.i, x, y, z)) continue;
            return true;
        }
        return false;
    }

    private ICropProvider getCropProvider(int x, int y, int z) {
        for (ICropProvider provider : this.cropProviders) {
            if (!provider.isCrop(this.tile.i, x, y, z)) continue;
            return provider;
        }
        return null;
    }

    public boolean hasWindfallById(int id) {
        return this.validWindfallById.containsKey(id);
    }

    public aan getWindfallById(int id) {
        return (aan)this.validWindfallById.get(id);
    }

    public Harvester(TileMachine machine) {
        super(machine);
    }

    public Harvester(TileMachine machine, ICropProvider provider) {
        super(machine);
        this.cropProviders.add(provider);
        aan[] windfall = provider.getWindfall();
        if (windfall != null && windfall.length > 0) {
            for (aan itemstack : windfall) {
                this.putWindfall(itemstack);
            }
        }
    }

    public Harvester(TileMachine machine, ArrayList providers) {
        super(machine);
        for (ICropProvider provider : providers) {
            this.cropProviders.add(provider);
            aan[] windfall = provider.getWindfall();
            if (windfall == null || windfall.length <= 0) continue;
            for (aan itemstack : windfall) {
                this.putWindfall(itemstack);
            }
        }
    }

    @Override
    public void openGui(yw player, io tile) {
    }

    @Override
    public void update() {
    }

    protected int getFreeProductSlot(aan product) {
        for (int i = this.productSlot1; i < this.windfallSlot1; ++i) {
            if (this.harvestStacks[i] == null) {
                return i;
            }
            if (!this.harvestStacks[i].a(product) || this.harvestStacks[i].a >= this.harvestStacks[i].c()) continue;
            return i;
        }
        return -1;
    }

    private int getFreeWindfallSlot(aan windfall) {
        for (int i = this.windfallSlot1; i < this.harvestStacks.length; ++i) {
            if (this.harvestStacks[i] == null) {
                return i;
            }
            if (!this.harvestStacks[i].a(windfall) || this.harvestStacks[i].a >= this.harvestStacks[i].c()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean doWork() {
        if (Proxy.isMultiplayerWorld()) {
            return false;
        }
        if (this.posNext != null) {
            Vect killMe = this.posNext;
            this.posNext = null;
            ICropProvider provider = this.getCropProvider(killMe.x, killMe.y, killMe.z);
            if (provider == null) {
                return false;
            }
            ICropEntity crop = provider.getCrop(this.tile.i, killMe.x, killMe.y, killMe.z);
            if (crop != null && crop.isHarvestable()) {
                this.hewTree(crop);
            }
            return true;
        }
        int processedBlocks = 0;
        while (!this.isFinished && processedBlocks < Config.harvesterThrottle) {
            ICropEntity crop;
            ++processedBlocks;
            this.advanceAxe();
            Vect posBlock = this.posCurrent.add(this.tile.Coords());
            posBlock = posBlock.add(this.posOffset);
            this.tile.i.a(posBlock.x, posBlock.y, posBlock.z);
            ICropProvider provider = this.getCropProvider(posBlock.x, posBlock.y, posBlock.z);
            if (provider == null || (crop = provider.getCrop(this.tile.i, posBlock.x, posBlock.y, posBlock.z)) == null || !crop.isHarvestable()) continue;
            this.hewTree(crop);
            break;
        }
        this.collectWindfall();
        this.dumpStash();
        if (this.isFinished) {
            this.resetAxe();
        }
        return true;
    }

    protected void advanceAxe() {
        if (this.posCurrent.z < this.area.z - 1) {
            ++this.posCurrent.z;
        } else {
            this.posCurrent.z = 0;
            if (this.posCurrent.x < this.area.x - 1) {
                ++this.posCurrent.x;
            } else {
                this.posCurrent.x = 0;
                if (this.posCurrent.y < this.area.y - 1) {
                    ++this.posCurrent.y;
                } else {
                    this.isFinished = true;
                }
            }
        }
    }

    protected void hewTree(ICropEntity entity) {
        ArrayList harvest = entity.doHarvest();
        this.storeProduct(harvest);
        int[] next = entity.getNextPosition();
        if (next == null || next.length <= 0) {
            return;
        }
        this.posNext = new Vect(next[0], next[1], next[2]);
    }

    protected void storeProduct(ArrayList harvest) {
        for (aan stack : harvest) {
            int slot = this.getFreeProductSlot(stack);
            if (slot < 0) {
                return;
            }
            if (this.harvestStacks[slot] == null) {
                this.harvestStacks[slot] = stack;
                continue;
            }
            if (this.harvestStacks[slot].a > this.harvestStacks[slot].c() - stack.a || !this.harvestStacks[slot].a(stack)) continue;
            this.harvestStacks[slot].a += stack.a;
        }
    }

    protected void resetAxe() {
        this.isFinished = false;
        this.posCurrent = new Vect(0, 0, 0);
    }

    protected void collectWindfall() {
        Vect min = new Vect(this.tile.j + this.posOffset.x, this.tile.k + this.posOffset.y, this.tile.l + this.posOffset.z);
        Vect max = new Vect(this.tile.j + this.posOffset.x + this.area.x, this.tile.k + this.posOffset.y + this.area.y, this.tile.l + this.posOffset.z + this.area.z);
        wu harvestBox = wu.b((double)min.x, (double)min.y, (double)min.z, (double)max.x, (double)max.y, (double)max.z);
        List list = this.tile.i.a(nn.class, harvestBox);
        for (int i = 0; i < list.size(); ++i) {
            aan windfall;
            nn entity = (nn)list.get(i);
            if (!(entity instanceof fq)) continue;
            fq item = (fq)entity;
            if (item.a == null || !this.hasWindfallById(item.a.c) || (windfall = this.getWindfallById(item.a.c)).i() != item.a.i() || !this.storeWindfall(item.a)) continue;
            item.A();
        }
    }

    private boolean storeWindfall(aan item) {
        int slot = this.getFreeWindfallSlot(item);
        if (slot < 0) {
            return false;
        }
        if (this.harvestStacks[slot] == null) {
            this.harvestStacks[slot] = item.k();
        } else if (this.harvestStacks[slot].a < this.getInventoryStackLimit() && this.harvestStacks[slot].a(item)) {
            ++this.harvestStacks[slot].a;
        }
        return true;
    }

    protected void dumpStash() {
        buildcraft.api.Orientations[] pipes = BlockUtil.getPipeDirections(this.tile.i, this.tile.Coords(), this.tile.getOrientation());
        if (pipes.length > 0) {
            this.dumpToPipe(pipes);
        } else {
            io[] inventories = BlockUtil.getAdjacentInventories(this.tile.i, this.tile.Coords());
            this.dumpToInventory(inventories);
        }
    }

    private void dumpToPipe(buildcraft.api.Orientations[] pipes) {
        for (int i = 0; i < this.harvestStacks.length; ++i) {
            if (this.harvestStacks[i] == null || this.harvestStacks[i].a <= 0) continue;
            buildcraft.api.Orientations[] filtered = !this.isSideSensitive || !Config.harvesterSideSensitive ? pipes : (this.hasWindfallById(this.harvestStacks[i].c) ? BlockUtil.filterPipeDirections(pipes, new buildcraft.api.Orientations[]{buildcraft.api.Orientations.XNeg, buildcraft.api.Orientations.XPos, buildcraft.api.Orientations.ZNeg, buildcraft.api.Orientations.ZPos}) : BlockUtil.filterPipeDirections(pipes, new buildcraft.api.Orientations[]{buildcraft.api.Orientations.YNeg, buildcraft.api.Orientations.YPos}));
            while (this.harvestStacks[i].a > 0 && filtered.length > 0) {
                BlockUtil.putFromStackIntoPipe(this.tile, filtered, this.harvestStacks[i]);
            }
            if (this.harvestStacks[i].a > 0) continue;
            this.harvestStacks[i] = null;
        }
    }

    private void dumpToInventory(io[] inventories) {
        for (int i = 0; i < this.harvestStacks.length; ++i) {
            if (this.harvestStacks[i] == null || this.harvestStacks[i].a <= 0) continue;
            block1: for (int j = 0; j < inventories.length; ++j) {
                if (this.harvestStacks[i] == null || inventories[j] instanceof TilePlanter) continue;
                io inventory = Utils.getChest(inventories[j]);
                for (int k = 0; k < inventory.a(); ++k) {
                    int available;
                    aan stack = inventory.k_(k);
                    if (stack == null) {
                        inventory.a(k, this.harvestStacks[i]);
                        this.harvestStacks[i] = null;
                        continue block1;
                    }
                    if (stack.c != this.harvestStacks[i].c || (available = inventory.d() - stack.a) <= 0) continue;
                    if (available >= this.harvestStacks[i].a) {
                        stack.a += this.harvestStacks[i].a;
                        this.harvestStacks[i] = null;
                        continue block1;
                    }
                    stack.a = inventory.d();
                    this.harvestStacks[i].a -= available;
                }
            }
        }
    }

    @Override
    public void readFromNBT(ady nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        no nbttaglist = nbttagcompound.n("Items");
        this.harvestStacks = new aan[this.getSizeInventory()];
        for (int i = 0; i < nbttaglist.d(); ++i) {
            ady nbttagcompound1 = (ady)nbttaglist.a(i);
            byte byte0 = nbttagcompound1.d("Slot");
            if (byte0 < 0 || byte0 >= this.harvestStacks.length) continue;
            this.harvestStacks[byte0] = aan.a((ady)nbttagcompound1);
        }
        this.isFinished = nbttagcompound.o("IsFinished");
    }

    @Override
    public void writeToNBT(ady nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        no nbttaglist = new no();
        for (int i = 0; i < this.harvestStacks.length; ++i) {
            if (this.harvestStacks[i] == null) continue;
            ady nbttagcompound1 = new ady();
            nbttagcompound1.a("Slot", (byte)i);
            this.harvestStacks[i].b(nbttagcompound1);
            nbttaglist.a((gh)nbttagcompound1);
        }
        nbttagcompound.a("Items", (gh)nbttaglist);
        nbttagcompound.a("IsFinished", this.isFinished);
    }

    @Override
    public aan getStackInSlot(int i) {
        return this.harvestStacks[i];
    }

    @Override
    public int getSizeInventory() {
        return this.harvestStacks.length;
    }

    @Override
    public aan decrStackSize(int i, int j) {
        if (this.harvestStacks[i] == null) {
            return null;
        }
        if (this.harvestStacks[i].a <= j) {
            aan product = this.harvestStacks[i];
            this.harvestStacks[i] = null;
            return product;
        }
        aan product = this.harvestStacks[i].a(j);
        if (this.harvestStacks[i].a == 0) {
            this.harvestStacks[i] = null;
        }
        return product;
    }

    @Override
    public void setInventorySlotContents(int i, aan itemstack) {
        this.harvestStacks[i] = itemstack;
        if (itemstack != null && itemstack.a > this.getInventoryStackLimit()) {
            itemstack.a = this.getInventoryStackLimit();
        }
    }

    @Override
    public aan getStackInSlotOnClosing(int slot) {
        if (this.harvestStacks[slot] == null) {
            return null;
        }
        aan toReturn = this.harvestStacks[slot];
        this.harvestStacks[slot] = null;
        return toReturn;
    }

    @Override
    public int getStartInventorySide(int side) {
        if (side == 0 || side == 1) {
            return 4;
        }
        return 0;
    }

    @Override
    public int getSizeInventorySide(int side) {
        return 4;
    }

    @Override
    public boolean addItem(aan stack, boolean doAdd, Orientations from) {
        return false;
    }

    @Override
    public aan extractItem(boolean doRemove, Orientations from) {
        for (int i = 0; i < this.harvestStacks.length; ++i) {
            if (this.harvestStacks[i] == null) continue;
            aan product = null;
            if (this.hasWindfallById(this.harvestStacks[i].a().bQ)) {
                if (Config.harvesterSideSensitive && this.isSideSensitive && from != Orientations.YNeg && from != Orientations.YPos) continue;
                product = this.getWindfallById(this.harvestStacks[i].a().bQ);
            } else {
                if (Config.harvesterSideSensitive && this.isSideSensitive && (from == Orientations.YNeg || from == Orientations.YPos)) continue;
                product = new aan(this.harvestStacks[i].a().bQ, 1, 0);
            }
            if (doRemove && product != null) {
                this.decrStackSize(i, 1);
            }
            return product;
        }
        return null;
    }

    @Override
    public boolean isWorking() {
        return false;
    }

    @Override
    public void getGUINetworkData(int i, int j) {
    }

    @Override
    public void sendGUINetworkData(dd container, wm iCrafting) {
    }
}

