/*
 * Decompiled with CFR 0.152.
 */
package forestry.cultivation;

import forestry.core.Machine;
import forestry.core.MachineFactory;
import forestry.core.Mill;
import forestry.core.Proxy;
import forestry.core.TileMill;
import forestry.core.utils.Vect;
import forestry.plugins.PluginIC2;

public class MillTreetap
extends Mill {
    private Vect area = new Vect(21, 13, 21);
    private Vect posOffset = new Vect(-10, -2, -10);
    private Vect posCurrent = new Vect(0, 0, 0);
    private boolean isFinished = false;

    public MillTreetap(TileMill tile) {
        super(tile);
        this.speed = 0.025f;
    }

    @Override
    public String getName() {
        return "Treetaper";
    }

    @Override
    public void openGui(yw player, io tile) {
    }

    @Override
    protected void activate() {
        if (!Proxy.isMultiplayerWorld()) {
            while (!this.isFinished) {
                int meta;
                this.advanceIterator();
                Vect posBlock = this.posCurrent.add(this.tile.Coords());
                posBlock = posBlock.add(this.posOffset);
                int blockid = this.tile.i.a(posBlock.x, posBlock.y, posBlock.z);
                if (blockid != PluginIC2.rubberwood.c || (meta = this.tile.i.e(posBlock.x, posBlock.y, posBlock.z)) <= 0) continue;
                this.tile.i.f(posBlock.x, posBlock.y, posBlock.z, 0);
                int amount = this.tile.i.r.nextInt(3) + 1;
                for (int i = 0; i < amount; ++i) {
                    fq entity = new fq(this.tile.i, (double)(posBlock.x + 1), (double)posBlock.y, (double)posBlock.z, PluginIC2.resin.k());
                    this.tile.i.a((nn)entity);
                }
            }
            if (this.isFinished) {
                this.resetIterator();
            }
            this.charge = 0;
            this.tileMill.sendNetworkUpdate();
        }
    }

    @Override
    public boolean doWork() {
        if (!PluginIC2.instance.isAvailable()) {
            return false;
        }
        if (Proxy.isMultiplayerWorld()) {
            return false;
        }
        if (this.charge != 0) {
            return false;
        }
        this.charge = 1;
        return true;
    }

    private void advanceIterator() {
        if (this.posCurrent.z < this.area.z - 1) {
            ++this.posCurrent.z;
        } else {
            this.posCurrent.z = 0;
            if (this.posCurrent.x < this.area.x - 1) {
                ++this.posCurrent.x;
            } else {
                this.posCurrent.x = 0;
                if (this.posCurrent.y < this.area.y - 1) {
                    ++this.posCurrent.y;
                } else {
                    this.isFinished = true;
                }
            }
        }
    }

    private void resetIterator() {
        this.isFinished = false;
        this.posCurrent = new Vect(0, 0, 0);
    }

    public static class Factory
    extends MachineFactory {
        @Override
        public Machine createMachine(kw tile) {
            return new MillTreetap((TileMill)tile);
        }
    }
}

