/*
 * Decompiled with CFR 0.152.
 */
package forestry.cultivation;

import forestry.core.EnumErrorCode;
import forestry.core.Mill;
import forestry.core.Proxy;
import forestry.core.TileMill;
import forestry.core.utils.Orientations;
import forestry.core.utils.StackUtils;
import forestry.core.utils.Vect;
import forestry.cultivation.Overgrowth;
import java.util.ArrayList;

public abstract class MillGrower
extends Mill {
    public final aan catalyst;
    private ArrayList validCropIds = new ArrayList();
    private ArrayList validOvergrowth = new ArrayList();
    private aan[] fuelStacks = new aan[1];
    private Vect area = new Vect(21, 3, 21);
    private Vect posOffset = new Vect(-10, -1, -10);
    private Vect posCurrent = new Vect(0, 0, 0);
    private boolean isFinished = false;

    public MillGrower(TileMill machine, aan catalyst) {
        super(machine);
        this.tileMill = machine;
        this.catalyst = catalyst;
    }

    protected void putOvergrowth(Overgrowth overgrowth) {
        this.validCropIds.add(overgrowth.crop.c);
        this.validOvergrowth.add(overgrowth);
    }

    public boolean hasOvergrowthByCropId(int cropid) {
        return this.validCropIds.contains(cropid);
    }

    public Overgrowth getOvergrowthByCrop(aan crop) {
        for (Overgrowth growth : this.validOvergrowth) {
            if (!growth.hasCrop(crop)) continue;
            return growth;
        }
        return null;
    }

    public abstract void growCrop(xd var1, int var2, Vect var3);

    @Override
    public void readFromNBT(ady nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        no nbttaglist = nbttagcompound.n("Items");
        this.fuelStacks = new aan[this.getSizeInventory()];
        for (int i = 0; i < nbttaglist.d(); ++i) {
            ady nbttagcompound1 = (ady)nbttaglist.a(i);
            byte byte0 = nbttagcompound1.d("Slot");
            if (byte0 < 0 || byte0 >= this.fuelStacks.length) continue;
            this.fuelStacks[byte0] = aan.a((ady)nbttagcompound1);
        }
        this.isFinished = nbttagcompound.o("IsFinished");
        this.charge = nbttagcompound.f("Charge");
        this.progress = nbttagcompound.h("Progress");
        this.stage = nbttagcompound.f("Stage");
    }

    @Override
    public void writeToNBT(ady nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        no nbttaglist = new no();
        for (int i = 0; i < this.fuelStacks.length; ++i) {
            if (this.fuelStacks[i] == null) continue;
            ady nbttagcompound1 = new ady();
            nbttagcompound1.a("Slot", (byte)i);
            this.fuelStacks[i].b(nbttagcompound1);
            nbttaglist.a((gh)nbttagcompound1);
        }
        nbttagcompound.a("Items", (gh)nbttaglist);
        nbttagcompound.a("IsFinished", this.isFinished);
        nbttagcompound.a("Charge", this.charge);
        nbttagcompound.a("Progress", this.progress);
        nbttagcompound.a("Stage", this.stage);
    }

    private int getFreeCatalystSlot() {
        for (int i = 0; i < 1; ++i) {
            if (this.fuelStacks[i] == null) {
                return i;
            }
            if (!this.fuelStacks[i].a(this.catalyst) || this.fuelStacks[i].a >= this.fuelStacks[i].c()) continue;
            return i;
        }
        return -1;
    }

    public void resetProgress() {
        this.isFinished = false;
        this.posCurrent = new Vect(0, 0, 0);
    }

    private void advanceProgress() {
        if (this.posCurrent.z < this.area.z - 1) {
            ++this.posCurrent.z;
        } else {
            this.posCurrent.z = 0;
            if (this.posCurrent.x < this.area.x - 1) {
                ++this.posCurrent.x;
            } else {
                this.posCurrent.x = 0;
                if (this.posCurrent.y < this.area.y - 1) {
                    ++this.posCurrent.y;
                } else {
                    this.isFinished = true;
                }
            }
        }
    }

    @Override
    public void activate() {
        float f = (float)this.tile.j + 0.5f;
        float f1 = (float)this.tile.k + 0.0f + this.tile.i.r.nextFloat() * 6.0f / 16.0f;
        float f2 = (float)this.tile.l + 0.5f;
        float f3 = 0.52f;
        float f4 = this.tile.i.r.nextFloat() * 0.6f - 0.3f;
        Proxy.addEntityBiodustFX(this.tile.i, f - f3, f1, f2 + f4, 0.0f, 0.0f, 0.0f);
        Proxy.addEntityBiodustFX(this.tile.i, f + f3, f1, f2 + f4, 0.0f, 0.0f, 0.0f);
        Proxy.addEntityBiodustFX(this.tile.i, f + f4, f1, f2 - f3, 0.0f, 0.0f, 0.0f);
        Proxy.addEntityBiodustFX(this.tile.i, f + f4, f1, f2 + f3, 0.0f, 0.0f, 0.0f);
        if (!Proxy.isMultiplayerWorld()) {
            this.catalyze();
            this.charge = 0;
            this.tileMill.sendNetworkUpdate();
        }
    }

    public void catalyze() {
        while (!this.isFinished && this.canCatalyze()) {
            this.advanceProgress();
            Vect posBlock = this.posCurrent.add(this.tile.Coords());
            posBlock = posBlock.add(this.posOffset);
            int blockid = this.tile.i.a(posBlock.x, posBlock.y, posBlock.z);
            if (!this.hasOvergrowthByCropId(blockid) || !this.applyCatalyst(posBlock)) continue;
            this.decrStackSize(0, 1);
            break;
        }
        if (this.isFinished) {
            this.resetProgress();
        }
    }

    @Override
    public boolean doWork() {
        if (Proxy.isMultiplayerWorld()) {
            return false;
        }
        if (this.charge != 0) {
            return false;
        }
        if (this.canCatalyze()) {
            this.setErrorState(EnumErrorCode.OK);
            this.charge = 1;
        } else {
            this.setErrorState(EnumErrorCode.NORESOURCE);
        }
        return true;
    }

    private boolean canCatalyze() {
        if (this.fuelStacks[0] == null) {
            return false;
        }
        if (!this.fuelStacks[0].a(this.catalyst)) {
            return false;
        }
        return this.fuelStacks[0].a > 0;
    }

    private boolean applyCatalyst(Vect posBlock) {
        int cropMeta;
        int cropId = this.tile.i.a(posBlock.x, posBlock.y, posBlock.z);
        Overgrowth growth = this.getOvergrowthByCrop(new aan(cropId, 1, cropMeta = this.tile.i.e(posBlock.x, posBlock.y, posBlock.z)));
        if (growth == null) {
            return false;
        }
        this.growCrop(this.tile.i, cropId, posBlock);
        int blockid = this.tile.i.a(posBlock.x, posBlock.y, posBlock.z);
        int meta = this.tile.i.e(posBlock.x, posBlock.y, posBlock.z);
        return growth.hasRipe(new aan(blockid, 1, meta));
    }

    @Override
    public int getSizeInventory() {
        return 1;
    }

    @Override
    public aan getStackInSlot(int i) {
        return this.fuelStacks[i];
    }

    @Override
    public aan decrStackSize(int i, int j) {
        if (this.fuelStacks[i] == null) {
            return null;
        }
        if (this.fuelStacks[i].a <= j) {
            aan product = this.fuelStacks[i];
            this.fuelStacks[i] = null;
            return product;
        }
        aan product = this.fuelStacks[i].a(j);
        if (this.fuelStacks[i].a == 0) {
            this.fuelStacks[i] = null;
        }
        return product;
    }

    @Override
    public void setInventorySlotContents(int i, aan itemstack) {
        this.fuelStacks[i] = itemstack;
        if (itemstack != null && itemstack.a > this.getInventoryStackLimit()) {
            itemstack.a = this.getInventoryStackLimit();
        }
    }

    @Override
    public aan getStackInSlotOnClosing(int slot) {
        if (this.fuelStacks[slot] == null) {
            return null;
        }
        aan toReturn = this.fuelStacks[slot];
        this.fuelStacks[slot] = null;
        return toReturn;
    }

    @Override
    public boolean addItem(aan stack, boolean doAdd, Orientations from) {
        if (stack.a(this.catalyst)) {
            int slot = this.getFreeCatalystSlot();
            if (slot < 0) {
                return false;
            }
            if (doAdd) {
                while (stack.a > 0 && slot >= 0) {
                    if (this.fuelStacks[slot] == null) {
                        this.fuelStacks[slot] = stack.k();
                        stack.a = 0;
                    } else {
                        StackUtils.mergeStacks(stack, this.fuelStacks[slot]);
                    }
                    slot = this.getFreeCatalystSlot();
                }
            }
            return true;
        }
        return false;
    }
}

