/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.api.core.EnumTemperature;
import forestry.core.EnumErrorCode;
import forestry.core.Proxy;
import forestry.core.TileForestry;
import forestry.core.config.Config;
import forestry.core.config.SessionVars;
import forestry.core.genetics.ClimateHelper;
import forestry.core.network.NetProxy;
import forestry.core.network.PacketCoordinates;
import forestry.core.utils.ContainerForestry;
import forestry.core.utils.ContainerLiquidTanks;
import forestry.core.utils.EnumAccess;
import forestry.core.utils.IClimatised;
import forestry.core.utils.IEnergyConsumer;
import forestry.core.utils.IErrorSource;
import forestry.core.utils.IHintSource;
import forestry.core.utils.IOwnable;
import forestry.core.utils.IPipette;
import forestry.core.utils.ISocketable;
import forestry.core.utils.ITankContainer;
import forestry.core.utils.StringUtil;
import forestry.core.utils.TankSlot;
import forge.ITextureProvider;
import forge.MinecraftForgeClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public abstract class GuiForestry
extends vp {
    protected GfxSlotManager slotManager = new GfxSlotManager(this);
    protected LedgerManager ledgerManager = new LedgerManager(this);
    protected TileForestry tile;
    protected String textureFile;
    protected static tw itemRenderer = new tw();
    protected int xSize = 176;
    protected int ySize = 166;
    public ContainerForestry inventorySlots;
    protected int guiLeft;
    protected int guiTop;
    protected int playerInventorySize;
    protected int pageCurrent = 0;
    protected int pageSize = 25;
    protected int pageMax = 1;
    private int mouseX = 0;
    private int mouseY = 0;

    public GuiForestry(String texture, ContainerForestry container, TileForestry tile) {
        this(texture, container, (io)tile, 1, tile.a());
    }

    public GuiForestry(String texture, ContainerForestry container, io inventory, int pageMax, int pageSize) {
        this.textureFile = texture;
        this.inventorySlots = container;
        this.pageMax = pageMax;
        this.pageSize = pageSize;
        if (inventory instanceof TileForestry) {
            this.tile = (TileForestry)inventory;
        }
        this.initLedgers(inventory);
    }

    protected void initLedgers(io inventory) {
        if (inventory instanceof IErrorSource && ((IErrorSource)inventory).throwsErrors()) {
            this.ledgerManager.add(new ErrorLedger((IErrorSource)inventory));
        }
        if (inventory instanceof IClimatised && ((IClimatised)inventory).isClimatized()) {
            this.ledgerManager.add(new ClimateLedger((IClimatised)inventory));
        }
        if (!Config.disableEnergyStat && inventory instanceof IEnergyConsumer && ((IEnergyConsumer)inventory).consumesEnergy()) {
            this.ledgerManager.add(new PowerLedger((IEnergyConsumer)inventory));
        }
        if (!Config.disableHints && inventory instanceof IHintSource && ((IHintSource)inventory).hasHints()) {
            this.ledgerManager.add(new HintLedger((IHintSource)inventory));
        }
        if (inventory instanceof IOwnable && ((IOwnable)inventory).isOwnable()) {
            this.ledgerManager.add(new OwnerLedger((IOwnable)inventory));
        }
    }

    public void c() {
        super.c();
        this.p.h.ar = this.inventorySlots;
        this.guiLeft = (this.q - this.xSize) / 2;
        this.guiTop = (this.r - this.ySize) / 2;
    }

    protected void flipPage(int page) {
        this.pageCurrent = page;
    }

    protected int getCenteredOffset(String string) {
        return this.getCenteredOffset(string, this.xSize);
    }

    protected int getCenteredOffset(String string, int xWidth) {
        return (xWidth - this.u.a(string)) / 2;
    }

    protected void drawGuiContainerForegroundLayer() {
        this.ledgerManager.drawLedgers(this.mouseX, this.mouseY);
        this.slotManager.drawSlots(this.mouseX, this.mouseY);
    }

    protected abstract void drawGuiContainerBackgroundLayer(float var1, int var2, int var3);

    protected void drawBackground() {
        this.guiLeft = (this.q - this.xSize) / 2;
        this.guiTop = (this.r - this.ySize) / 2;
        int texture = this.p.p.b(this.textureFile);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.p.p.b(texture);
        this.b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
    }

    public void a(int mouseX, int mouseY, float par3) {
        aan slotStack;
        List var24;
        yu mousedSlot;
        int i;
        this.k();
        int var4 = this.guiLeft;
        int var5 = this.guiTop;
        this.drawGuiContainerBackgroundLayer(par3, mouseX, mouseY);
        tf.c();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)var4, (float)var5, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        yu mousedOverSlot = null;
        int var7 = 240;
        int var8 = 240;
        es.a((int)es.b, (float)((float)var7 / 1.0f), (float)((float)var8 / 1.0f));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (i = this.pageCurrent * this.pageSize; i < (this.pageCurrent + 1) * this.pageSize; ++i) {
            mousedSlot = this.drawSlot(i, mouseX, mouseY);
            if (mousedSlot == null) continue;
            mousedOverSlot = mousedSlot;
        }
        for (i = this.pageMax * this.pageSize; i < this.inventorySlots.e.size(); ++i) {
            mousedSlot = this.drawSlot(i, mouseX, mouseY);
            if (mousedSlot == null) continue;
            mousedOverSlot = mousedSlot;
        }
        this.drawGuiContainerForegroundLayer();
        aak playerInventory = this.p.h.ap;
        if (playerInventory.k() != null) {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
            this.g = 200.0f;
            GuiForestry.itemRenderer.b = 200.0f;
            itemRenderer.a(this.u, this.p.p, playerInventory.k(), mouseX - var4 - 8, mouseY - var5 - 8);
            itemRenderer.b(this.u, this.p.p, playerInventory.k(), mouseX - var4 - 8, mouseY - var5 - 8);
            this.g = 0.0f;
            GuiForestry.itemRenderer.b = 0.0f;
        }
        GL11.glDisable((int)32826);
        tf.a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        if (playerInventory.k() == null && mousedOverSlot != null && mousedOverSlot.c() && (var24 = (slotStack = mousedOverSlot.b()).q()).size() > 0) {
            int var12;
            int var11;
            int var10 = 0;
            for (var11 = 0; var11 < var24.size(); ++var11) {
                var12 = this.u.a((String)var24.get(var11));
                if (var12 <= var10) continue;
                var10 = var12;
            }
            var11 = mouseX - var4 + 12;
            var12 = mouseY - var5 - 12;
            int var14 = 8;
            if (var24.size() > 1) {
                var14 += 2 + (var24.size() - 1) * 10;
            }
            this.g = 300.0f;
            GuiForestry.itemRenderer.b = 300.0f;
            int var15 = -267386864;
            this.a(var11 - 3, var12 - 4, var11 + var10 + 3, var12 - 3, var15, var15);
            this.a(var11 - 3, var12 + var14 + 3, var11 + var10 + 3, var12 + var14 + 4, var15, var15);
            this.a(var11 - 3, var12 - 3, var11 + var10 + 3, var12 + var14 + 3, var15, var15);
            this.a(var11 - 4, var12 - 3, var11 - 3, var12 + var14 + 3, var15, var15);
            this.a(var11 + var10 + 3, var12 - 3, var11 + var10 + 4, var12 + var14 + 3, var15, var15);
            int var16 = 0x505000FF;
            int var17 = (var16 & 0xFEFEFE) >> 1 | var16 & 0xFF000000;
            this.a(var11 - 3, var12 - 3 + 1, var11 - 3 + 1, var12 + var14 + 3 - 1, var16, var17);
            this.a(var11 + var10 + 2, var12 - 3 + 1, var11 + var10 + 3, var12 + var14 + 3 - 1, var16, var17);
            this.a(var11 - 3, var12 - 3, var11 + var10 + 3, var12 - 3 + 1, var16, var16);
            this.a(var11 - 3, var12 + var14 + 2, var11 + var10 + 3, var12 + var14 + 3, var17, var17);
            for (int var18 = 0; var18 < var24.size(); ++var18) {
                String var19 = (String)var24.get(var18);
                var19 = var18 == 0 ? "\u00a7" + Integer.toHexString(slotStack.s().e) + var19 : "\u00a77" + var19;
                this.u.a(var19, var11, var12, -1);
                if (var18 == 0) {
                    var12 += 2;
                }
                var12 += 10;
            }
            this.g = 0.0f;
            GuiForestry.itemRenderer.b = 0.0f;
        }
        GL11.glPopMatrix();
        super.a(mouseX, mouseY, par3);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
    }

    protected yu drawSlot(int slotIndex, int mouseX, int mouseY) {
        yu mousedOverSlot = null;
        yu slot = (yu)this.inventorySlots.e.get(slotIndex);
        this.drawSlotInventory(slot);
        if (this.getIsMouseOverSlot(slot, mouseX, mouseY)) {
            mousedOverSlot = slot;
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            int var9 = slot.d;
            int var10 = slot.e;
            this.a(var9, var10, var9 + 16, var10 + 16, -2130706433, -2130706433);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
        }
        return mousedOverSlot;
    }

    protected void drawSlotInventory(yu slot) {
        int backgroundIndex;
        int xPos = slot.d;
        int yPos = slot.e;
        aan slotStack = slot.b();
        boolean backgroundDrawn = false;
        this.g = 100.0f;
        GuiForestry.itemRenderer.b = 100.0f;
        if (slotStack == null && (backgroundIndex = slot.e()) >= 0) {
            GL11.glDisable((int)2896);
            this.p.p.b(this.p.p.b("/gui/items.png"));
            this.b(xPos, yPos, backgroundIndex % 16 * 16, backgroundIndex / 16 * 16, 16, 16);
            GL11.glEnable((int)2896);
            backgroundDrawn = true;
        }
        if (!backgroundDrawn) {
            itemRenderer.a(this.u, this.p.p, slotStack, xPos, yPos);
            itemRenderer.b(this.u, this.p.p, slotStack, xPos, yPos);
        }
        GuiForestry.itemRenderer.b = 0.0f;
        this.g = 0.0f;
    }

    protected yu getSlotAtPosition(int i, int j) {
        yu slot;
        int k;
        for (k = this.pageCurrent * this.pageSize; k < (this.pageCurrent + 1) * this.pageSize; ++k) {
            slot = (yu)this.inventorySlots.e.get(k);
            if (!this.getIsMouseOverSlot(slot, i, j)) continue;
            return slot;
        }
        for (k = this.pageMax * this.pageSize; k < this.inventorySlots.e.size(); ++k) {
            slot = (yu)this.inventorySlots.e.get(k);
            if (!this.getIsMouseOverSlot(slot, i, j)) continue;
            return slot;
        }
        return null;
    }

    protected boolean getIsMouseOverSlot(yu slot, int i, int j) {
        int k = this.guiLeft;
        int l = this.guiTop;
        return (i -= k) >= slot.d - 1 && i < slot.d + 16 + 1 && (j -= l) >= slot.e - 1 && j < slot.e + 16 + 1;
    }

    protected void a(int par1, int par2, int mouseButton) {
        super.a(par1, par2, mouseButton);
        if (mouseButton == 0 || mouseButton == 1) {
            yu slot = this.getSlotAtPosition(par1, par2);
            int var5 = this.guiLeft;
            int var6 = this.guiTop;
            boolean var7 = par1 < var5 || par2 < var6 || par1 >= var5 + this.xSize || par2 >= var6 + this.ySize;
            int var8 = -1;
            if (slot != null) {
                var8 = slot.c;
            }
            if (var7) {
                var8 = -999;
            }
            if (var8 != -1) {
                boolean var9 = var8 != -999 && (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54));
                this.handleMouseClick(slot, var8, mouseButton, var9);
            }
        }
        this.ledgerManager.handleMouseClicked(par1, par2, mouseButton);
        this.slotManager.handleMouseClicked(par1, par2, mouseButton);
    }

    protected void handleMouseClick(yu slot, int slotIndex, int mouseButton, boolean par4) {
        if (slot != null) {
            slotIndex = slot.c;
        }
        this.p.c.a(this.inventorySlots.f, slotIndex, mouseButton, par4, (yw)this.p.h);
    }

    protected void a(char par1, int par2) {
        if (par2 == 1 || par2 == this.p.A.s.d) {
            this.p.h.af();
        }
    }

    public void e() {
        if (this.p.h != null) {
            this.inventorySlots.a((yw)this.p.h);
            this.p.c.a(this.inventorySlots.f, (yw)this.p.h);
        }
    }

    public boolean b() {
        return false;
    }

    public void a() {
        super.a();
        if (!this.p.h.M() || this.p.h.G) {
            this.p.h.af();
        }
    }

    protected void drawGauge(int j, int k, int line, int col, int squaled, int liquidId) {
        int x;
        yr content = null;
        int liquidImgIndex = 0;
        if (liquidId < pb.m.length && pb.m[liquidId] != null) {
            content = pb.m[liquidId];
            liquidImgIndex = pb.m[liquidId].bN;
        } else {
            content = yr.e[liquidId];
            liquidImgIndex = yr.e[liquidId].b(0);
        }
        if (content instanceof ITextureProvider) {
            MinecraftForgeClient.bindTexture((String)((ITextureProvider)content).getTextureFile());
        } else {
            MinecraftForgeClient.bindTexture((String)"/terrain.png");
        }
        int imgLine = liquidImgIndex / 16;
        int imgColumn = liquidImgIndex - imgLine * 16;
        int start = 0;
        do {
            x = 0;
            if (squaled > 16) {
                x = 16;
                squaled -= 16;
            } else {
                x = squaled;
                squaled = 0;
            }
            this.b(j + col, k + line + 58 - x - start, imgColumn * 16, imgLine * 16, 16, 16 - (16 - x));
            start += 16;
        } while (x != 0 && squaled != 0);
        int i = this.p.p.b(this.textureFile);
        this.p.p.b(i);
        this.b(j + col, k + line, 176, 0, 16, 60);
    }

    protected void b(int i, int j, int k) {
        super.b(i, j, k);
        this.mouseX = i;
        this.mouseY = j;
    }

    protected class PowerLedger
    extends Ledger {
        IEnergyConsumer tile;

        public PowerLedger(IEnergyConsumer tile) {
            this.tile = tile;
            this.maxHeight = 94;
            this.overlayColor = 13921311;
        }

        @Override
        public void draw(int x, int y) {
            this.drawBackground(x, y);
            this.drawIcon("/gfx/gui/misc.png", 0, x + 3, y + 4);
            if (!this.isFullyOpened()) {
                return;
            }
            GuiForestry.this.u.a(StringUtil.localize("gui.energy"), x + 22, y + 8, 14797103);
            GuiForestry.this.u.a(StringUtil.localize("gui.stored") + ":", x + 22, y + 20, 11186104);
            GuiForestry.this.u.b(this.tile.getEnergyStored() + " MJ", x + 22, y + 32, 0);
            GuiForestry.this.u.a(StringUtil.localize("gui.maxenergy") + ":", x + 22, y + 44, 11186104);
            GuiForestry.this.u.b(this.tile.getMaxEnergyStored() + " MJ", x + 22, y + 56, 0);
            GuiForestry.this.u.a(StringUtil.localize("gui.maxenergyreceive") + ":", x + 22, y + 68, 11186104);
            GuiForestry.this.u.b(this.tile.getMaxEnergyReceived() + " MJ", x + 22, y + 80, 0);
        }

        @Override
        public String getTooltip() {
            return this.tile.getEnergyStored() + " MJ";
        }
    }

    protected class HintLedger
    extends Ledger {
        int position;
        String[] hints;

        public HintLedger(IHintSource tile) {
            this.hints = tile.getHints();
            this.maxHeight = 96;
            this.position = new Random().nextInt(this.hints.length);
            this.overlayColor = 15350015;
        }

        @Override
        public void draw(int x, int y) {
            this.drawBackground(x, y);
            this.drawIcon("/gfx/gui/misc.png", 1, x + 3, y + 4);
            if (!this.isFullyOpened()) {
                return;
            }
            GuiForestry.this.u.a(StringUtil.localize("gui.didyouknow") + "?", x + 22, y + 8, 14797103);
            GuiForestry.this.u.a(StringUtil.localize("hints." + this.hints[this.position] + ".desc"), x + 22, y + 20, this.maxWidth - 28, 0);
        }

        @Override
        public String getTooltip() {
            return StringUtil.localize("hints." + this.hints[this.position] + ".tag");
        }
    }

    protected class ClimateLedger
    extends Ledger {
        IClimatised tile;

        public ClimateLedger(IClimatised tile) {
            this.tile = tile;
            this.maxHeight = 72;
            this.overlayColor = 3515647;
        }

        @Override
        public void draw(int x, int y) {
            EnumTemperature temperature = ClimateHelper.getTemperature(this.tile.getTemperature());
            this.drawBackground(x, y);
            this.drawIcon("/gfx/gui/habitats.png", temperature.getIconIndex(), x + 3, y + 4);
            if (!this.isFullyOpened()) {
                return;
            }
            GuiForestry.this.u.a(StringUtil.localize("gui.climate"), x + 22, y + 8, 14797103);
            GuiForestry.this.u.a(StringUtil.localize("gui.temperature") + ":", x + 22, y + 20, 11186104);
            GuiForestry.this.u.b(ClimateHelper.toDisplay(temperature), x + 22, y + 32, 0);
            GuiForestry.this.u.a(StringUtil.localize("gui.humidity") + ":", x + 22, y + 44, 11186104);
            GuiForestry.this.u.b(ClimateHelper.toDisplay(ClimateHelper.getHumidity(this.tile.getHumidity())) + " (" + Math.round(100.0f * this.tile.getHumidity()) + " %)", x + 22, y + 56, 0);
        }

        @Override
        public String getTooltip() {
            return "T: " + ClimateHelper.toDisplay(ClimateHelper.getTemperature(this.tile.getTemperature())) + " / H: " + ClimateHelper.toDisplay(ClimateHelper.getHumidity(this.tile.getHumidity()));
        }
    }

    protected class ErrorLedger
    extends Ledger {
        IErrorSource tile;

        public ErrorLedger(IErrorSource tile) {
            this.tile = tile;
            this.maxHeight = 72;
            this.overlayColor = 0xFF3535;
        }

        @Override
        public void draw(int x, int y) {
            EnumErrorCode state = this.tile.getErrorState();
            if (state == EnumErrorCode.OK) {
                return;
            }
            this.drawBackground(x, y);
            this.drawIcon("/gfx/gui/errors.png", state.getIconIndex(), x + 3, y + 4);
            if (this.isFullyOpened()) {
                GuiForestry.this.u.a(this.getTooltip(), x + 22, y + 8, 14797103);
                GuiForestry.this.u.a(StringUtil.localize(this.tile.getErrorState().getHelp()), x + 22, y + 20, this.maxWidth - 28, 0);
            }
        }

        @Override
        public boolean isVisible() {
            EnumErrorCode state = this.tile.getErrorState();
            return state != EnumErrorCode.OK;
        }

        @Override
        public String getTooltip() {
            return StringUtil.localize(this.tile.getErrorState().getDescription());
        }
    }

    protected class OwnerLedger
    extends Ledger {
        IOwnable tile;

        public OwnerLedger(IOwnable tile) {
            this.tile = tile;
        }

        public boolean isAccessButton(int mouseX, int mouseY) {
            int shiftX = this.currentShiftX;
            int shiftY = this.currentShiftY + 44;
            return mouseX >= shiftX && mouseX <= this.currentShiftX + this.currentWidth && mouseY >= shiftY && mouseY <= shiftY + 12;
        }

        public boolean isOwnerChangeButton(int mouseX, int mouseY) {
            return false;
        }

        @Override
        public void draw(int x, int y) {
            boolean playerIsOwner = this.tile.isOwner((yw)((GuiForestry)GuiForestry.this).p.h);
            this.maxHeight = playerIsOwner ? 60 : 36;
            this.drawBackground(x, y);
            this.drawIcon("/gfx/gui/errors.png", 18, x + 3, y + 4);
            if (!this.isFullyOpened()) {
                return;
            }
            GuiForestry.this.u.a(StringUtil.localize("gui.owner"), x + 22, y + 8, 14797103);
            String owner = this.tile.getOwner();
            if (owner == null) {
                owner = StringUtil.localize("gui.derelict");
            }
            GuiForestry.this.u.b(owner, x + 22, y + 20, 0);
            if (!playerIsOwner) {
                return;
            }
            GuiForestry.this.u.a(StringUtil.localize("gui.access") + ":", x + 22, y + 32, 11186104);
            EnumAccess access = this.tile.getAccess();
            this.drawIcon("/gfx/gui/misc.png", access.getIconIndex(), x + 20, y + 40);
            GuiForestry.this.u.b(StringUtil.localize(access.getName()), x + 38, y + 44, 0);
        }

        @Override
        public String getTooltip() {
            if (this.tile.getOwner() != null) {
                return StringUtil.localize("gui.owner") + ": " + this.tile.getOwner();
            }
            return StringUtil.localize("gui.derelict");
        }

        @Override
        public boolean handleMouseClicked(int x, int y, int mouseButton) {
            if (this.isAccessButton(x, y)) {
                if (Proxy.isMultiplayerWorld()) {
                    kw te = (kw)this.tile;
                    NetProxy.sendToServer(new PacketCoordinates(50, te.j, te.k, te.l));
                }
                this.tile.switchAccessRule((yw)((GuiForestry)GuiForestry.this).p.h);
                return true;
            }
            return false;
        }
    }

    protected class PlainLedger
    extends Ledger {
        private int iconIndex;
        private String text;

        public PlainLedger(int iconIndex, String text) {
            this.iconIndex = iconIndex;
            this.text = text;
        }

        @Override
        public void draw(int x, int y) {
            int textWidth = GuiForestry.this.u.a(this.getTooltip());
            this.maxWidth = textWidth + 24 + 4;
            this.drawBackground(x, y);
            this.drawIcon("/gfx/gui/errors.png", this.iconIndex, x + 3, y + 4);
            if (this.isFullyOpened()) {
                GuiForestry.this.u.b(this.getTooltip(), x + 22, y + 8, 0);
            }
        }

        @Override
        public String getTooltip() {
            return this.text;
        }
    }

    protected abstract class Ledger {
        private boolean open;
        protected int overlayColor = 0xFFFFFF;
        public int currentShiftX = 0;
        public int currentShiftY = 0;
        protected int limitWidth = 128;
        protected int maxWidth = 124;
        protected int minWidth;
        protected int currentWidth = this.minWidth = 24;
        protected int maxHeight = 24;
        protected int minHeight;
        protected int currentHeight = this.minHeight = 24;

        protected Ledger() {
        }

        public void update() {
            if (this.open && this.currentWidth < this.maxWidth) {
                this.currentWidth += 4;
            } else if (!this.open && this.currentWidth > this.minWidth) {
                this.currentWidth -= 4;
            }
            if (this.open && this.currentHeight < this.maxHeight) {
                this.currentHeight += 4;
            } else if (!this.open && this.currentHeight > this.minHeight) {
                this.currentHeight -= 4;
            }
        }

        public int getHeight() {
            return this.currentHeight;
        }

        public abstract void draw(int var1, int var2);

        public abstract String getTooltip();

        public boolean handleMouseClicked(int x, int y, int mouseButton) {
            return false;
        }

        public boolean intersectsWith(int mouseX, int mouseY, int shiftX, int shiftY) {
            return mouseX >= shiftX && mouseX <= shiftX + this.currentWidth && mouseY >= shiftY && mouseY <= shiftY + this.getHeight();
        }

        public void setFullyOpen() {
            this.open = true;
            this.currentWidth = this.maxWidth;
            this.currentHeight = this.maxHeight;
        }

        public void toggleOpen() {
            if (this.open) {
                this.open = false;
                SessionVars.setOpenedLedger(null);
            } else {
                this.open = true;
                SessionVars.setOpenedLedger(this.getClass());
            }
        }

        public boolean isVisible() {
            return true;
        }

        public boolean isOpen() {
            return this.open;
        }

        protected boolean isFullyOpened() {
            return this.currentWidth >= this.maxWidth;
        }

        protected void drawBackground(int x, int y) {
            int texture = ((GuiForestry)GuiForestry.this).p.p.b("/gfx/gui/ledger.png");
            float colorR = (float)(this.overlayColor >> 16 & 0xFF) / 255.0f;
            float colorG = (float)(this.overlayColor >> 8 & 0xFF) / 255.0f;
            float colorB = (float)(this.overlayColor & 0xFF) / 255.0f;
            GL11.glColor4f((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
            ((GuiForestry)GuiForestry.this).p.p.b(texture);
            GuiForestry.this.b(x, y, 0, 256 - this.currentHeight, 4, this.currentHeight);
            GuiForestry.this.b(x + 4, y, 256 - this.currentWidth + 4, 0, this.currentWidth - 4, 4);
            GuiForestry.this.b(x, y, 0, 0, 4, 4);
            GuiForestry.this.b(x + 4, y + 4, 256 - this.currentWidth + 4, 256 - this.currentHeight + 4, this.currentWidth - 4, this.currentHeight - 4);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        protected void drawIcon(String texture, int iconIndex, int x, int y) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int tex = ((GuiForestry)GuiForestry.this).p.p.b(texture);
            ((GuiForestry)GuiForestry.this).p.p.b(tex);
            int textureRow = iconIndex >> 4;
            int textureColumn = iconIndex - 16 * textureRow;
            GuiForestry.this.b(x, y, 16 * textureColumn, 16 * textureRow, 16, 16);
        }
    }

    protected class LedgerManager {
        private GuiForestry gui;
        protected ArrayList ledgers = new ArrayList();

        public LedgerManager(GuiForestry gui) {
            this.gui = gui;
        }

        public void add(Ledger ledger) {
            this.ledgers.add(ledger);
            if (SessionVars.getOpenedLedger() != null && ledger.getClass().equals(SessionVars.getOpenedLedger())) {
                ledger.setFullyOpen();
            }
        }

        public void insert(Ledger ledger) {
            this.ledgers.add(this.ledgers.size() - 1, ledger);
        }

        protected Ledger getAtPosition(int mX, int mY) {
            int xShift = (this.gui.q - this.gui.xSize) / 2 + this.gui.xSize;
            int yShift = (this.gui.r - this.gui.ySize) / 2 + 8;
            for (int i = 0; i < this.ledgers.size(); ++i) {
                Ledger ledger = (Ledger)this.ledgers.get(i);
                if (!ledger.isVisible()) continue;
                ledger.currentShiftX = xShift;
                ledger.currentShiftY = yShift;
                if (ledger.intersectsWith(mX, mY, xShift, yShift)) {
                    return ledger;
                }
                yShift += ledger.getHeight();
            }
            return null;
        }

        protected void drawLedgers(int mouseX, int mouseY) {
            int xPos = 8;
            for (Ledger ledger : this.ledgers) {
                ledger.update();
                if (!ledger.isVisible()) continue;
                ledger.draw(GuiForestry.this.xSize, xPos);
                xPos += ledger.getHeight();
            }
            Ledger ledger = this.getAtPosition(mouseX, mouseY);
            if (ledger != null) {
                int startX = mouseX - (this.gui.q - this.gui.xSize) / 2 + 12;
                int startY = mouseY - (this.gui.r - this.gui.ySize) / 2 - 12;
                String tooltip = ledger.getTooltip();
                int textWidth = GuiForestry.this.u.a(tooltip);
                GuiForestry.this.a(startX - 3, startY - 3, startX + textWidth + 3, startY + 8 + 3, -1073741824, -1073741824);
                GuiForestry.this.u.a(tooltip, startX, startY, -1);
            }
        }

        public void handleMouseClicked(int x, int y, int mouseButton) {
            Ledger ledger;
            if (mouseButton == 0 && (ledger = this.getAtPosition(x, y)) != null && !ledger.handleMouseClicked(x, y, mouseButton)) {
                for (Ledger other : this.ledgers) {
                    if (other == ledger || !other.isOpen()) continue;
                    other.toggleOpen();
                }
                ledger.toggleOpen();
            }
        }
    }

    protected class LiquidTankSlot
    extends GfxSlot {
        ITankContainer tile;
        int slot;

        public LiquidTankSlot(int xPos, int yPos, ITankContainer tile, int slot) {
            super(xPos, yPos);
            this.slot = 0;
            this.tile = tile;
            this.slot = slot;
            this.height = 58;
        }

        @Override
        public void draw(int startX, int startY) {
            int x;
            yr content = null;
            int liquidImgIndex = 0;
            TankSlot tank = this.tile.getLiquidTanks()[this.slot];
            int liquidId = tank.liquidId;
            int squaled = tank.quantity * this.height / tank.capacity;
            if (liquidId <= 0) {
                return;
            }
            if (liquidId < pb.m.length && pb.m[liquidId] != null) {
                content = pb.m[liquidId];
                liquidImgIndex = pb.m[liquidId].bN;
            } else {
                content = yr.e[liquidId];
                liquidImgIndex = yr.e[liquidId].b(0);
            }
            if (content instanceof ITextureProvider) {
                MinecraftForgeClient.bindTexture((String)((ITextureProvider)content).getTextureFile());
            } else {
                MinecraftForgeClient.bindTexture((String)"/terrain.png");
            }
            int imgLine = liquidImgIndex / 16;
            int imgColumn = liquidImgIndex - imgLine * 16;
            int start = 0;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            do {
                x = 0;
                if (squaled > 16) {
                    x = 16;
                    squaled -= 16;
                } else {
                    x = squaled;
                    squaled = 0;
                }
                GuiForestry.this.b(startX + this.xPos, startY + this.yPos + 58 - x - start, imgColumn * 16, imgLine * 16, 16, 16 - (16 - x));
                start += 16;
            } while (x != 0 && squaled != 0);
            int tex = ((GuiForestry)GuiForestry.this).p.p.b(GuiForestry.this.textureFile);
            ((GuiForestry)GuiForestry.this).p.p.b(tex);
            GuiForestry.this.b(startX + this.xPos, startY + this.yPos, 176, 0, 16, 60);
        }

        @Override
        public String getTooltip() {
            int liquidId = this.tile.getLiquidTanks()[this.slot].liquidId;
            if (liquidId > 0) {
                String tooltip = yr.e[liquidId].d(null);
                if (Config.tooltipLiquidAmount) {
                    tooltip = tooltip + " (" + this.tile.getLiquidTanks()[this.slot].quantity + ")";
                }
                return tooltip;
            }
            return StringUtil.localize("gui.empty");
        }

        @Override
        public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
            aan itemstack = ((GuiForestry)GuiForestry.this).p.h.ap.k();
            if (itemstack == null) {
                return;
            }
            yr held = itemstack.a();
            if (held instanceof IPipette) {
                ((ContainerLiquidTanks)GuiForestry.this.inventorySlots).handlePipetteClick(this.slot, (yw)((GuiForestry)GuiForestry.this).p.h);
            }
        }
    }

    protected class SocketSlot
    extends GfxSlot {
        ISocketable tile;
        int slot;

        public SocketSlot(int xPos, int yPos, ISocketable tile, int slot) {
            super(xPos, yPos);
            this.slot = 0;
            this.tile = tile;
            this.slot = slot;
        }

        @Override
        public void draw(int startX, int startY) {
            itemRenderer.a(GuiForestry.this.u, ((GuiForestry)GuiForestry.this).p.p, this.tile.getSocket(this.slot), startX + this.xPos, startY + this.yPos);
        }

        @Override
        public String getTooltip() {
            return "";
        }
    }

    protected abstract class GfxSlot {
        protected int xPos;
        protected int yPos;
        protected int width = 16;
        protected int height = 16;

        public GfxSlot(int xPos, int yPos) {
            this.xPos = xPos;
            this.yPos = yPos;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public abstract void draw(int var1, int var2);

        public abstract String getTooltip();

        public boolean intersectsWith(int mouseX, int mouseY) {
            return mouseX >= this.xPos && mouseX <= this.xPos + this.width && mouseY >= this.yPos && mouseY <= this.yPos + this.height;
        }

        public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        }
    }

    protected class GfxSlotManager {
        private GuiForestry gui;
        protected ArrayList slots = new ArrayList();

        public GfxSlotManager(GuiForestry gui) {
            this.gui = gui;
        }

        public void add(GfxSlot slot) {
            this.slots.add(slot);
        }

        protected GfxSlot getAtPosition(int mX, int mY) {
            for (GfxSlot slot : this.slots) {
                if (!slot.intersectsWith(mX, mY)) continue;
                return slot;
            }
            return null;
        }

        public void drawSlots(int mouseX, int mouseY) {
            for (GfxSlot slot : this.slots) {
                slot.draw(0, 0);
            }
            GfxSlot slot = this.getAtPosition(mouseX - GuiForestry.this.guiLeft, mouseY - GuiForestry.this.guiTop);
            if (slot != null) {
                int startX = mouseX - (this.gui.q - this.gui.xSize) / 2 + 12;
                int startY = mouseY - (this.gui.r - this.gui.ySize) / 2 - 12;
                String tooltip = slot.getTooltip();
                int textWidth = GuiForestry.this.u.a(tooltip);
                GuiForestry.this.a(startX - 3, startY - 3, startX + textWidth + 3, startY + 8 + 3, -1073741824, -1073741824);
                GuiForestry.this.u.a(tooltip, startX, startY, -1);
            }
        }

        public void handleMouseClicked(int mouseX, int mouseY, int mouseButton) {
            GfxSlot slot = this.getAtPosition(mouseX - GuiForestry.this.guiLeft, mouseY - GuiForestry.this.guiTop);
            if (slot != null) {
                slot.handleMouseClick(mouseX, mouseY, mouseButton);
            }
        }
    }
}

