/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network;

import forestry.core.network.ForestryPacket;
import forestry.core.network.PacketPayload;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class PacketUpdate
extends ForestryPacket {
    public PacketPayload payload;

    public PacketUpdate() {
    }

    public PacketUpdate(int id) {
        this(id, null);
    }

    public PacketUpdate(int id, PacketPayload payload) {
        super(id);
        this.payload = payload;
    }

    public void writeData(DataOutputStream data) throws IOException {
        if (this.payload == null) {
            data.writeInt(0);
            data.writeInt(0);
            data.writeInt(0);
            return;
        }
        data.writeInt(this.payload.intPayload.length);
        data.writeInt(this.payload.floatPayload.length);
        data.writeInt(this.payload.stringPayload.length);
        for (int intData : this.payload.intPayload) {
            data.writeInt(intData);
        }
        for (float floatData : this.payload.floatPayload) {
            data.writeFloat(floatData);
        }
        for (String stringData : this.payload.stringPayload) {
            data.writeUTF(stringData);
        }
    }

    public void readData(DataInputStream data) throws IOException {
        int i;
        this.payload = new PacketPayload();
        this.payload.intPayload = new int[data.readInt()];
        this.payload.floatPayload = new float[data.readInt()];
        this.payload.stringPayload = new String[data.readInt()];
        for (i = 0; i < this.payload.intPayload.length; ++i) {
            this.payload.intPayload[i] = data.readInt();
        }
        for (i = 0; i < this.payload.floatPayload.length; ++i) {
            this.payload.floatPayload[i] = data.readFloat();
        }
        for (i = 0; i < this.payload.stringPayload.length; ++i) {
            this.payload.stringPayload[i] = data.readUTF();
        }
    }
}

