/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network;

import forestry.core.Proxy;
import forestry.core.TileForestry;
import forestry.core.network.PacketTileUpdate;
import forestry.plugins.PluginManager;
import forge.IPacketHandler;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;

public class PacketHandler
implements IPacketHandler {
    public void onPacketData(lg network, String channel, byte[] bytes) {
        DataInputStream data = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            int packetID = data.read();
            switch (packetID) {
                case 0: {
                    PacketTileUpdate packetT = new PacketTileUpdate();
                    packetT.readData(data);
                    this.onTileUpdate(packetT);
                    break;
                }
                default: {
                    for (IPacketHandler handler : PluginManager.packetHandlers) {
                        handler.onPacketData(network, channel, bytes);
                    }
                    break;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void onTileUpdate(PacketTileUpdate packet) {
        kw tile = packet.getTarget(Proxy.getWorld());
        if (tile instanceof TileForestry) {
            ((TileForestry)tile).fromUpdatePacket(packet);
        }
    }
}

