/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.config;

import forestry.api.core.ForestryBlock;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.BackpackManager;
import forestry.api.storage.EnumBackpackType;
import forestry.core.Proxy;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.utils.CarpenterRecipe;
import forestry.core.utils.CraftingRecipe;
import forge.IOreHandler;
import forge.MinecraftForge;
import java.util.ArrayList;
import java.util.Iterator;

public class OreHandler
implements IOreHandler {
    private static ArrayList registeredCraftingRecipes = new ArrayList();
    private static ArrayList addedCraftingRecipes = new ArrayList();
    private static ArrayList registeredCarpenterRecipes = new ArrayList();

    public void registerOre(String oreClass, aan ore) {
        String type;
        if (ore.a(ForestryItem.ingotBronze) || ore.a(ForestryItem.ingotCopper) || ore.a(ForestryItem.ingotTin)) {
            return;
        }
        if (oreClass == "ingotBronze") {
            this.updateRecipes();
            this.addCrating(ore, new aan((yr)ForestryItem.cratedBronze));
        }
        if (oreClass == "ingotCopper") {
            this.updateRecipes();
            this.addCrating(ore, new aan((yr)ForestryItem.cratedCopper));
        }
        if (oreClass == "ingotTin") {
            this.updateRecipes();
            this.addCrating(ore, new aan((yr)ForestryItem.cratedTin));
        }
        if (oreClass == "ingotSilver") {
            ForestryItem.cratedSilver.contained = ore;
            this.addCrating(ore, new aan((yr)ForestryItem.cratedSilver));
        }
        if (oreClass == "ingotBrass") {
            ForestryItem.cratedBrass.contained = ore;
            this.addCrating(ore, new aan((yr)ForestryItem.cratedBrass));
        }
        if (oreClass == "dustNikolite") {
            ForestryItem.cratedNikolite.contained = ore;
            this.addCrating(ore, new aan((yr)ForestryItem.cratedNikolite));
        }
        if ((type = oreClass.substring(0, 3)).matches("ore") || type.matches("gem") || oreClass.substring(0, 5).matches("ingot") || oreClass.matches("itemDropUranium")) {
            BackpackManager.backpackItems[EnumBackpackType.MINER.ordinal()].add(ore);
        }
        if (oreClass.substring(0, 4).matches("wood")) {
            BackpackManager.backpackItems[EnumBackpackType.FORESTER.ordinal()].add(ore);
        }
    }

    private void addCrating(aan ore, aan crated) {
        if (RecipeManagers.carpenterManager != null) {
            RecipeManagers.carpenterManager.addCrating(ore, crated);
        }
    }

    public void initApatiteOre() {
        ModLoader.getLogger().finer("Registering ore apatite.");
        MinecraftForge.registerOre((String)"oreApatite", (aan)new aan(ForestryBlock.resources, 1, 0));
        MinecraftForge.registerOre((String)"gemApatite", (aan)new aan(ForestryItem.apatite));
    }

    public void initOreBlocks() {
        dy.a().addSmelting(ForestryBlock.beehives.bO, 0, ForestryItem.ingotCopper);
        MinecraftForge.registerOre((String)"oreCopper", (aan)new aan(ForestryBlock.resources, 1, 1));
        dy.a().addSmelting(ForestryBlock.resources.bO, 1, ForestryItem.ingotCopper);
        if (Config.registerTinBlock) {
            Proxy.registerBlock(ForestryBlock.oreTin);
            dy.a().addSmelting(ForestryBlock.oreTin.bO, 0, ForestryItem.ingotTin);
        }
        MinecraftForge.registerOre((String)"oreTin", (aan)new aan(ForestryBlock.resources, 1, 2));
        dy.a().addSmelting(ForestryBlock.resources.bO, 2, ForestryItem.ingotTin);
    }

    public void registerDictionaryRecipe(CraftingRecipe recipe) {
        if (registeredCraftingRecipes.contains(recipe)) {
            return;
        }
        registeredCraftingRecipes.add(recipe);
        Proxy.addRecipe(recipe.result, recipe.aobj);
        this.createAlternateCraftingRecipes(recipe);
    }

    public void registerCarpenterRecipe(CarpenterRecipe recipe) {
        if (registeredCarpenterRecipes.contains(recipe)) {
            return;
        }
        registeredCarpenterRecipes.add(recipe);
        RecipeManagers.carpenterManager.addRecipe(recipe.time, recipe.liquid, recipe.box, recipe.result, recipe.aobj);
        this.createAlternateCarpenterRecipes(recipe);
    }

    private void updateRecipes() {
        this.createAlternateCraftingRecipes();
        this.createAlternateCarpenterRecipes();
    }

    private void createAlternateCraftingRecipes() {
        Iterator it = registeredCraftingRecipes.iterator();
        while (it.hasNext()) {
            this.createAlternateCraftingRecipes((CraftingRecipe)it.next());
        }
    }

    private void createAlternateCraftingRecipes(CraftingRecipe template) {
        String[] oreClasses = new String[]{"ingotTin", "ingotCopper", "ingotBronze"};
        aan[] toReplace = new aan[]{ForestryItem.ingotTin, ForestryItem.ingotCopper, ForestryItem.ingotBronze};
        if (template.containsAnyIngredient(toReplace)) {
            CraftingRecipe alternate = template.copy();
            alternate.prepareOreDictionary(oreClasses, toReplace);
            for (Object[] aobj : MinecraftForge.generateRecipes((Object[])alternate.aobj)) {
                boolean skipNull = false;
                for (int i = 0; i < aobj.length; ++i) {
                    if (aobj[i] != null) continue;
                    skipNull = true;
                    break;
                }
                boolean skipDuplicate = false;
                for (Object[] pobj : addedCraftingRecipes) {
                    if (pobj.length != aobj.length) continue;
                    boolean same = true;
                    for (int i = 0; i < pobj.length; ++i) {
                        if (pobj[i].equals(aobj[i])) continue;
                        same = false;
                        break;
                    }
                    if (!same) continue;
                    skipDuplicate = true;
                    break;
                }
                if (skipNull || skipDuplicate) continue;
                addedCraftingRecipes.add(aobj);
                Proxy.addRecipe(alternate.result, aobj);
            }
        }
    }

    private void createAlternateCarpenterRecipes() {
        Iterator it = registeredCarpenterRecipes.iterator();
        while (it.hasNext()) {
            this.createAlternateCarpenterRecipes((CarpenterRecipe)it.next());
        }
    }

    private void createAlternateCarpenterRecipes(CarpenterRecipe template) {
        String[] oreClasses = new String[]{"ingotTin", "ingotCopper", "ingotBronze"};
        aan[] toReplace = new aan[]{ForestryItem.ingotTin, ForestryItem.ingotCopper, ForestryItem.ingotBronze};
        if (template.containsAnyIngredient(toReplace)) {
            CarpenterRecipe alternate = template.copy();
            alternate.prepareOreDictionary(oreClasses, toReplace);
            for (Object[] aobj : MinecraftForge.generateRecipes((Object[])alternate.aobj)) {
                boolean skip = false;
                for (int i = 0; i < aobj.length; ++i) {
                    if (aobj[i] != null) continue;
                    skip = true;
                    break;
                }
                if (skip) continue;
                RecipeManagers.carpenterManager.addRecipe(alternate.time, alternate.liquid, alternate.box, alternate.result, aobj);
            }
        }
    }
}

