/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.config;

import buildcraft.api.PowerFramework;
import forestry.api.apiculture.FlowerManager;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.ForestryBlock;
import forestry.api.core.GlobalManager;
import forestry.api.storage.BackpackManager;
import forestry.core.BioPowerFramework;
import forestry.core.EnumBreedingMode;
import forestry.core.Proxy;
import forestry.core.config.ConfigureBlocks;
import forestry.core.config.ConfigureItems;
import forestry.core.config.ForestryItem;
import forestry.core.triggers.ForestryTrigger;
import forestry.core.utils.Localization;
import forge.Configuration;
import forge.Property;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

public class Config {
    public static final String CATEGORY_GENERAL = "general";
    public static final String CATEGORY_BLOCK = "block";
    public static final String CATEGORY_ITEM = "item";
    public static Configuration config;
    public static boolean disableApiculture;
    public static boolean disableArboriculture;
    public static boolean disableCultivation;
    public static boolean disableEnergy;
    public static boolean disableFactory;
    public static boolean disableFood;
    public static boolean disableStorage;
    public static boolean enableParticleFX;
    public static boolean unifiedBreedingHistory;
    public static int beeAgeModifier;
    public static EnumBreedingMode beeBreedingMode;
    public static int beeCycleTicks;
    public static boolean beeSwarming;
    public static boolean dungeonLootRare;
    public static boolean generateApatiteOre;
    public static boolean generateCopperOre;
    public static boolean generateTinOre;
    public static boolean registerTinBlock;
    public static boolean generateBeehives;
    public static boolean generateBogEarth;
    public static boolean enableBackpackResupply;
    public static int planterThrottle;
    public static int harvesterThrottle;
    public static boolean tooltipLiquidAmount;
    public static boolean planterSideSensitive;
    public static boolean harvesterSideSensitive;
    public static boolean apiarySideSensitive;
    public static boolean bronzeRecipeEnabled;
    public static boolean farmsEnabled;
    public static boolean applePickup;
    public static boolean disableHints;
    public static HashMap hints;
    public static boolean disableEnergyStat;

    public static void load() {
        config = new Configuration(new File(Proxy.getForestryRoot(), "config/forestry/base.conf"));
        config.load();
        if (PowerFramework.currentFramework == null) {
            Property powerFrameworkClass = config.getOrCreateProperty("power.framework", CATEGORY_GENERAL, "forestry.energy.BioPowerFramework");
            try {
                PowerFramework.currentFramework = (PowerFramework)Class.forName(powerFrameworkClass.value).getConstructor(null).newInstance(null);
            }
            catch (Throwable e) {
                PowerFramework.currentFramework = new BioPowerFramework();
            }
        }
        Property particleFX = config.getOrCreateBooleanProperty("presentation.particleFX.enabled", CATEGORY_GENERAL, true);
        particleFX.comment = "set to false to disable particle fx on slower machines";
        enableParticleFX = Boolean.parseBoolean(particleFX.value);
        Property genApatiteOre = config.getOrCreateBooleanProperty("world.generate.apatite", CATEGORY_GENERAL, true);
        genApatiteOre.comment = "set to false to force forestry to skip generating own apatite ore blocks in the world";
        generateApatiteOre = Boolean.parseBoolean(genApatiteOre.value);
        Property genBeehives = config.getOrCreateBooleanProperty("world.generate.beehives", CATEGORY_GENERAL, true);
        genBeehives.comment = "set to false to force forestry to skip generating beehives in the world";
        generateBeehives = Boolean.parseBoolean(genBeehives.value);
        Property genCopperOre = config.getOrCreateBooleanProperty("world.generate.copper", CATEGORY_GENERAL, true);
        genCopperOre.comment = "set to false to force forestry to skip generating own copper ore blocks in the world";
        generateCopperOre = Boolean.parseBoolean(genCopperOre.value);
        Property genTinOre = config.getOrCreateBooleanProperty("world.generate.tin", CATEGORY_GENERAL, true);
        genTinOre.comment = "set to false to force forestry to skip generating own tin ore blocks in the world";
        generateTinOre = Boolean.parseBoolean(genTinOre.value);
        Property disTinBlock = config.getOrCreateBooleanProperty("world.register.tinBlock", CATEGORY_GENERAL, true);
        disTinBlock.comment = "set to false to force forestry to release the block id for old tin ore (this is not in use unless you have a world that was generated with Forestry < 1.3.x)";
        registerTinBlock = Boolean.parseBoolean(disTinBlock.value);
        Property planterSideSense = config.getOrCreateBooleanProperty("planters.sidesensitive", CATEGORY_GENERAL, true);
        planterSideSense.comment = "set to false if farms should output all harvested products regardless of side a pipe is attached to";
        planterSideSensitive = Boolean.parseBoolean(planterSideSense.value);
        Property harvesterSideSense = config.getOrCreateBooleanProperty("harvesters.sidesensitive", CATEGORY_GENERAL, true);
        harvesterSideSense.comment = "set to false if harvesters should output all harvested products regardless of side a pipe is attached to";
        harvesterSideSensitive = Boolean.parseBoolean(harvesterSideSense.value);
        Property apiarySideSense = config.getOrCreateBooleanProperty("apiary.sidesensitive", CATEGORY_GENERAL, false);
        apiarySideSense.comment = "set to false if apiaries should output all items regardless of side a pipe is attached to";
        apiarySideSensitive = Boolean.parseBoolean(apiarySideSense.value);
        Property bronzeRecipe = config.getOrCreateBooleanProperty("crafting.bronze.enabled", CATEGORY_GENERAL, true);
        bronzeRecipe.comment = "set to false to disable crafting recipe for bronze";
        bronzeRecipeEnabled = Boolean.parseBoolean(bronzeRecipe.value);
        Property farmsEnable = config.getOrCreateBooleanProperty("crafting.farms.enabled", CATEGORY_GENERAL, true);
        farmsEnable.comment = "set to false to disable crafting recipes for all farms (harvesters and planters)";
        farmsEnabled = Boolean.parseBoolean(farmsEnable.value);
        Property appleHarvest = config.getOrCreateBooleanProperty("tweaks.apple.pickup.enabled", CATEGORY_GENERAL, true);
        appleHarvest.comment = "set to false to disable apple pickup by appropriate harvesters";
        applePickup = Boolean.parseBoolean(appleHarvest.value);
        Property unifiedBreedingHist = config.getOrCreateBooleanProperty("beebreeding.history.unified", CATEGORY_GENERAL, false);
        unifiedBreedingHist.comment = "set to true to track beebreeding globally instead of per single world. will not merge past histories!";
        unifiedBreedingHistory = Boolean.parseBoolean(unifiedBreedingHist.value);
        Property breedingMode = config.getOrCreateProperty("beebreeding.difficulty", CATEGORY_GENERAL, EnumBreedingMode.NORMAL.toString());
        breedingMode.comment = "change breeding modes here. possible values NORMAL, EASY, HARDCORE, FTB";
        beeBreedingMode = EnumBreedingMode.parseMode(breedingMode.value);
        ModLoader.getLogger().finer("Breeding mode for bees set to " + beeBreedingMode.toString());
        beeAgeModifier = beeBreedingMode == EnumBreedingMode.HARDCORE ? 5 : 1;
        Property dungeonLootRarity = config.getOrCreateBooleanProperty("difficulty.dungeonloot.rare", CATEGORY_GENERAL, false);
        dungeonLootRarity.comment = "set to true to make dungeon loot generated by forestry rarer";
        dungeonLootRare = Boolean.parseBoolean(dungeonLootRarity.value);
        Property resupplyEnable = config.getOrCreateBooleanProperty("performance.backpacks.resupply", CATEGORY_GENERAL, true);
        resupplyEnable.comment = "leaving this enabled will cycle the list of active players PER INGAME TICK to check for resupply via backpack. you want to set this to false on busy servers.";
        enableBackpackResupply = Boolean.parseBoolean(resupplyEnable.value);
        Property propThrottle = config.getOrCreateIntProperty("throttle.planter", CATEGORY_GENERAL, 10);
        propThrottle.comment = "higher numbers increase working speeds of planters but also increase cpu load.";
        planterThrottle = Integer.parseInt(propThrottle.value);
        propThrottle = config.getOrCreateIntProperty("throttle.harvester", CATEGORY_GENERAL, 200);
        propThrottle.comment = "higher numbers increase working speeds of harvesters but also increase cpu load.";
        harvesterThrottle = Integer.parseInt(propThrottle.value);
        Property additionalFlowers = config.getOrCreateProperty("beekeeping.flowers.custom", CATEGORY_GENERAL, "");
        additionalFlowers.comment = "add additional flower blocks for apiaries here in the format id:meta. separate blocks using ';'. will be treated like vanilla flowers. not recommended for flowers implemented as tile entities.";
        Config.parseAdditionalFlowers(additionalFlowers.value, FlowerManager.plainFlowers);
        Property disableHint = config.getOrCreateBooleanProperty("tweaks.hints.disabled", CATEGORY_GENERAL, false);
        disableHint.comment = "set to true to disable hints on machine and engine guis.";
        disableHints = Boolean.parseBoolean(disableHint.value);
        Property disableEnergyStat = config.getOrCreateBooleanProperty("tweaks.energystat.disabled", CATEGORY_GENERAL, true);
        disableEnergyStat.comment = "set to true to disable energy statistics on energy consumers.";
        Config.disableEnergyStat = Boolean.parseBoolean(disableEnergyStat.value);
        Property tooltipLiquid = config.getOrCreateBooleanProperty("tweaks.tooltip.liquidamount.disabled", CATEGORY_GENERAL, true);
        tooltipLiquid.comment = "set to true to disable displaying liquid amounts in tank tooltips.";
        tooltipLiquidAmount = !Boolean.parseBoolean(tooltipLiquid.value);
        Config.registerClimates();
        ConfigureBlocks.initialize();
        ConfigureItems.initialize();
        ForestryTrigger.initialize();
        GlobalManager.leafBlockIds.add(pb.K.bO);
        GlobalManager.dirtBlockIds.add(pb.v.bO);
        GlobalManager.dirtBlockIds.add(pb.u.bO);
        GlobalManager.sandBlockIds.add(pb.E.bO);
        config.save();
        Config.loadHints();
    }

    public static void modsLoaded() {
        config = new Configuration(new File(Proxy.getForestryRoot(), "config/forestry/base.conf"));
        config.load();
        Property backpackConf = config.getOrCreateProperty("backpacks.miner.items", CATEGORY_GENERAL, "");
        backpackConf.comment = "add additional blocks and items for the miner's backpack here in the format id:meta. separate blocks and items using ';'";
        Config.parseBackpackItems("Miner's Backpack", backpackConf.value, BackpackManager.backpackItems[0]);
        backpackConf = config.getOrCreateProperty("backpacks.digger.items", CATEGORY_GENERAL, "");
        backpackConf.comment = "add additional blocks and items for the digger's backpack here in the format id:meta. separate blocks and items using ';'";
        Config.parseBackpackItems("Digger's Backpack", backpackConf.value, BackpackManager.backpackItems[1]);
        backpackConf = config.getOrCreateProperty("backpacks.forester.items", CATEGORY_GENERAL, "");
        backpackConf.comment = "add additional blocks and items for the forester's backpack here in the format id:meta. separate blocks and items using ';'";
        Config.parseBackpackItems("Forester's Backpack", backpackConf.value, BackpackManager.backpackItems[2]);
        backpackConf = config.getOrCreateProperty("backpacks.hunter.items", CATEGORY_GENERAL, "");
        backpackConf.comment = "add additional blocks and items for the hunter's backpack here in the format id:meta. separate blocks and items using ';'";
        Config.parseBackpackItems("Hunter's Backpack", backpackConf.value, BackpackManager.backpackItems[3]);
        backpackConf = config.getOrCreateProperty("backpacks.adventurer.items", CATEGORY_GENERAL, "");
        backpackConf.comment = "add blocks and items for the adventurer's backpack here in the format id:meta. separate blocks and items using ';'";
        Config.parseBackpackItems("Adventurer's Backpack", backpackConf.value, BackpackManager.backpackItems[4]);
        backpackConf = config.getOrCreateProperty("backpacks.builder.items", CATEGORY_GENERAL, "");
        backpackConf.comment = "add blocks and items for the builder's backpack here in the format id:meta. separate blocks and items using ';'";
        Config.parseBackpackItems("Builder's Backpack", backpackConf.value, BackpackManager.backpackItems[5]);
        config.save();
    }

    private static void parseBackpackItems(String backpackIdent, String list, ArrayList target) {
        String[] items;
        for (String item : items = list.split("[;]+")) {
            if (item.isEmpty()) continue;
            String[] ident = item.split("[:]+");
            int id = 0;
            int meta = 0;
            if (ident.length > 1) {
                id = Integer.parseInt(ident[0]);
                meta = Integer.parseInt(ident[1]);
            } else {
                id = Integer.parseInt(ident[0]);
            }
            if (id <= 0) continue;
            if (id < pb.m.length && pb.m[id] != null || yr.e[id] != null) {
                ModLoader.getLogger().finer("Adding block/item of (" + id + ":" + meta + ") to " + backpackIdent);
                target.add(new aan(id, 1, meta));
                continue;
            }
            ModLoader.getLogger().warning("Failed to add block/item of (" + id + ":" + meta + ") to " + backpackIdent + " since it was null.");
        }
    }

    private static void loadHints() {
        if (Proxy.isServer()) {
            return;
        }
        Properties prop = new Properties();
        try {
            InputStream hintStream = Localization.class.getResourceAsStream("/config/forestry/hints.properties");
            prop.load(hintStream);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (String key : prop.stringPropertyNames()) {
            hints.put(key, Config.parseHints(prop.getProperty(key)));
        }
    }

    private static String[] parseHints(String list) {
        if (list.isEmpty()) {
            return null;
        }
        return list.split("[;]+");
    }

    private static void parseAdditionalFlowers(String list, ArrayList target) {
        String[] items;
        for (String item : items = list.split("[;]+")) {
            if (item.isEmpty()) continue;
            String[] ident = item.split("[:]+");
            int id = 0;
            int meta = 0;
            if (ident.length > 1) {
                id = Integer.parseInt(ident[0]);
                meta = Integer.parseInt(ident[1]);
            } else {
                id = Integer.parseInt(ident[0]);
            }
            if (id <= 0) continue;
            if (id < pb.m.length && pb.m[id] != null || yr.e[id] != null) {
                ModLoader.getLogger().finer("Adding flower of (" + id + ":" + meta + ") to vanilla flower provider.");
                target.add(new aan(id, 1, meta));
                continue;
            }
            ModLoader.getLogger().warning("Failed to add flower of (" + id + ":" + meta + ") to vanilla flower provider since it was null.");
        }
    }

    public static void registerStandardRecipes() {
        Proxy.addRecipe(new aan(ForestryItem.fertilizerBio, 4), new Object[]{" X ", "X#X", " X ", Character.valueOf('#'), pb.v, Character.valueOf('X'), yr.T});
        Proxy.addRecipe(new aan(ForestryItem.fertilizerBio, 1), new Object[]{" X ", "X#X", " X ", Character.valueOf('#'), pb.v, Character.valueOf('X'), ForestryItem.ash});
        Proxy.addRecipe(new aan(ForestryItem.fertilizerCompound, 8), new Object[]{" # ", " X ", " # ", Character.valueOf('#'), pb.E, Character.valueOf('X'), ForestryItem.apatite});
        Proxy.addRecipe(new aan(ForestryItem.fertilizerCompound, 2), new Object[]{"###", "#X#", "###", Character.valueOf('#'), ForestryItem.ash, Character.valueOf('X'), pb.E});
        Proxy.addRecipe(new aan(ForestryBlock.soil, 8, 0), new Object[]{"###", "#X#", "###", Character.valueOf('#'), pb.v, Character.valueOf('X'), ForestryItem.fertilizerBio});
        Proxy.addRecipe(new aan(ForestryBlock.soil, 8, 0), new Object[]{"###", "#X#", "###", Character.valueOf('#'), pb.v, Character.valueOf('X'), ForestryItem.fertilizerCompound});
        Proxy.addRecipe(new aan(ForestryBlock.soil, 6, 1), new Object[]{"#Y#", "YXY", "#Y#", Character.valueOf('#'), pb.v, Character.valueOf('X'), yr.ax, Character.valueOf('Y'), pb.E});
        Proxy.addRecipe(new aan(ForestryBlock.soil, 8, 1), new Object[]{"#Y#", "YXY", "#Y#", Character.valueOf('#'), pb.v, Character.valueOf('X'), ForestryItem.canWater, Character.valueOf('Y'), pb.E});
        Proxy.addRecipe(new aan(ForestryBlock.soil, 8, 1), new Object[]{"#Y#", "YXY", "#Y#", Character.valueOf('#'), pb.v, Character.valueOf('X'), ForestryItem.waxCapsuleWater, Character.valueOf('Y'), pb.E});
        Proxy.addRecipe(new aan(ForestryBlock.soil, 8, 1), new Object[]{"#Y#", "YXY", "#Y#", Character.valueOf('#'), pb.v, Character.valueOf('X'), ForestryItem.refractoryWater, Character.valueOf('Y'), pb.E});
        Proxy.addRecipe(new aan(ForestryItem.vialCatalyst, 3), new Object[]{"###", "YXY", Character.valueOf('#'), ForestryItem.waxCapsule, Character.valueOf('X'), yr.aX, Character.valueOf('Y'), ForestryItem.fertilizerCompound});
        Proxy.addRecipe(new aan(ForestryItem.vialCatalyst, 3), new Object[]{"###", "YXY", Character.valueOf('#'), ForestryItem.canEmpty, Character.valueOf('X'), yr.aX, Character.valueOf('Y'), ForestryItem.fertilizerCompound});
        Proxy.addRecipe(new aan(yr.K), new Object[]{"#", "#", "#", Character.valueOf('#'), new aan(ForestryItem.craftingMaterial, 1, 2)});
        Proxy.addRecipe(new aan(ForestryItem.pipette), new Object[]{"  #", " X ", "X  ", Character.valueOf('X'), pb.bq, Character.valueOf('#'), new aan(pb.ab, 1, -1)});
    }

    private static void registerClimates() {
        for (abn biome : abn.a) {
            if (biome == null) continue;
            if (biome.F >= 2.0f) {
                if (biome.M == abn.j.M) {
                    EnumTemperature.hellishBiomeIds.add(biome.M);
                    continue;
                }
                EnumTemperature.hotBiomeIds.add(biome.M);
                continue;
            }
            if (biome.F >= 1.2f) {
                EnumTemperature.warmBiomeIds.add(biome.M);
                continue;
            }
            if (biome.F >= 0.2f) {
                EnumTemperature.normalBiomeIds.add(biome.M);
                continue;
            }
            if (biome.F >= 0.15f) {
                EnumTemperature.coldBiomeIds.add(biome.M);
                continue;
            }
            EnumTemperature.icyBiomeIds.add(biome.M);
        }
        for (abn biome : abn.a) {
            if (biome == null) continue;
            if (biome.G >= 0.9f) {
                EnumHumidity.dampBiomeIds.add(biome.M);
                continue;
            }
            if (biome.G >= 0.3f) {
                EnumHumidity.normalBiomeIds.add(biome.M);
                continue;
            }
            EnumHumidity.aridBiomeIds.add(biome.M);
        }
    }

    public static int getOrCreateBlockIdProperty(String key, int defaultId) {
        return Integer.parseInt(Config.config.getOrCreateBlockIdProperty((String)key, (int)defaultId).value);
    }

    public static int getOrCreateIntProperty(String key, String kind, int defaults) {
        return Integer.parseInt(Config.config.getOrCreateIntProperty((String)key, (String)kind, (int)defaults).value);
    }

    public static boolean getOrCreateBooleanProperty(String key, String kind, boolean defaults) {
        return Boolean.parseBoolean(Config.config.getOrCreateBooleanProperty((String)key, (String)kind, (boolean)defaults).value);
    }

    public static void saveToFile() {
        config.save();
    }

    static {
        disableApiculture = false;
        disableArboriculture = true;
        disableCultivation = false;
        disableEnergy = false;
        disableFactory = false;
        disableFood = false;
        disableStorage = false;
        enableParticleFX = true;
        unifiedBreedingHistory = false;
        beeAgeModifier = 1;
        beeBreedingMode = EnumBreedingMode.NORMAL;
        beeCycleTicks = 550;
        beeSwarming = false;
        dungeonLootRare = false;
        generateApatiteOre = true;
        generateCopperOre = true;
        generateTinOre = true;
        registerTinBlock = true;
        generateBeehives = true;
        generateBogEarth = false;
        enableBackpackResupply = true;
        tooltipLiquidAmount = false;
        planterSideSensitive = true;
        harvesterSideSensitive = true;
        apiarySideSensitive = false;
        bronzeRecipeEnabled = true;
        farmsEnabled = true;
        applePickup = true;
        disableHints = false;
        hints = new HashMap();
        disableEnergyStat = false;
    }
}

