/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import forestry.core.EntityPackage;
import forestry.core.IBlockRenderer;
import forestry.core.MachineFactory;
import forestry.core.utils.CraftingIngredients;
import forestry.core.utils.EnergyConfiguration;
import forestry.core.utils.TextureDescription;
import java.util.ArrayList;

public class MachinePackage
extends EntityPackage {
    public final MachineFactory factory;
    public final String itemName;
    public final ArrayList recipes = new ArrayList();
    public final ArrayList blueprints = new ArrayList();
    public EnergyConfiguration energyConfig;

    public MachinePackage(MachineFactory factory, String itemName) {
        this.factory = factory;
        this.itemName = itemName;
        this.energyConfig = new EnergyConfiguration(1000, 5, 40, 75, 500);
    }

    public MachinePackage(MachineFactory factory, String itemName, IBlockRenderer renderer) {
        this(factory, itemName);
        this.renderer = renderer;
    }

    public MachinePackage(MachineFactory factory, String itemName, TextureDescription texture) {
        this(factory, itemName);
        this.textures = texture;
    }

    public MachinePackage(MachineFactory factory, String itemName, IBlockRenderer renderer, CraftingIngredients recipe) {
        this(factory, itemName, renderer);
        this.recipes.add(recipe);
    }

    public MachinePackage(MachineFactory factory, String itemName, IBlockRenderer renderer, CraftingIngredients[] recipes) {
        this(factory, itemName, renderer);
        for (CraftingIngredients recipe : recipes) {
            this.recipes.add(recipe);
        }
    }

    public MachinePackage(MachineFactory factory, String itemName, TextureDescription texture, CraftingIngredients recipe) {
        this(factory, itemName, texture);
        this.recipes.add(recipe);
    }

    public MachinePackage(MachineFactory factory, String itemName, TextureDescription texture, CraftingIngredients[] recipes) {
        this(factory, itemName, texture);
        for (CraftingIngredients recipe : recipes) {
            if (recipe == null) continue;
            this.recipes.add(recipe);
        }
    }
}

