/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import forestry.api.liquids.LiquidContainer;
import forestry.api.liquids.LiquidManager;
import forestry.core.EnumErrorCode;
import forestry.core.IBlockRenderer;
import forestry.core.TileMachine;
import forestry.core.network.ClassMap;
import forestry.core.network.IndexInPayload;
import forestry.core.network.PacketPayload;
import forestry.core.utils.Orientations;
import forestry.core.utils.TankLevel;
import forestry.core.utils.TankSlot;
import ic2.api.Direction;
import java.util.LinkedList;

public abstract class Machine {
    public TileMachine tile;
    public IBlockRenderer customRender = null;
    private String[] hints;

    public PacketPayload getPacketPayload() {
        if (!ClassMap.classMappers.containsKey(this.getClass())) {
            ClassMap.classMappers.put(this.getClass(), new ClassMap(this.getClass()));
        }
        ClassMap classmap = (ClassMap)ClassMap.classMappers.get(this.getClass());
        PacketPayload payload = new PacketPayload(classmap.intSize, classmap.floatSize, classmap.stringSize);
        try {
            classmap.setData(this, payload.intPayload, payload.floatPayload, payload.stringPayload, new IndexInPayload(0, 0, 0));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return payload;
    }

    public void fromPacketPayload(PacketPayload payload, IndexInPayload index) {
        if (payload.isEmpty()) {
            return;
        }
        if (!ClassMap.classMappers.containsKey(this.getClass())) {
            ClassMap.classMappers.put(this.getClass(), new ClassMap(this.getClass()));
        }
        ClassMap classmap = (ClassMap)ClassMap.classMappers.get(this.getClass());
        try {
            classmap.fromData(this, payload.intPayload, payload.floatPayload, payload.stringPayload, index);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Machine(TileMachine tile) {
        this.tile = tile;
    }

    public abstract String getName();

    public abstract void openGui(yw var1, io var2);

    public boolean canInteractWith(yw player) {
        return true;
    }

    public abstract void update();

    public abstract boolean doWork();

    public abstract boolean isWorking();

    public boolean hasResourcesMin(float percentage) {
        return false;
    }

    public boolean hasFuelMin(float percentage) {
        return false;
    }

    public boolean hasWork() {
        return false;
    }

    public void setErrorState(EnumErrorCode state) {
        this.tile.setErrorState(state);
    }

    public boolean throwsErrors() {
        return true;
    }

    public EnumErrorCode getErrorState() {
        return this.tile.getErrorState();
    }

    public void setHints(String[] hints) {
        this.hints = hints;
    }

    public boolean hasHints() {
        return this.hints != null && this.hints.length > 0;
    }

    public String[] getHints() {
        return this.hints;
    }

    public boolean isClimatized() {
        return false;
    }

    public float getTemperature() {
        return 0.0f;
    }

    public float getHumidity() {
        return 0.0f;
    }

    public boolean addItem(aan stack, boolean doAdd, Orientations from) {
        return false;
    }

    public aan extractItem(boolean doRemove, Orientations from) {
        return null;
    }

    public int getSizeInventory() {
        return 0;
    }

    public aan getStackInSlot(int i) {
        return null;
    }

    public aan decrStackSize(int i, int j) {
        return null;
    }

    public void setInventorySlotContents(int i, aan itemstack) {
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public aan getStackInSlotOnClosing(int slot) {
        return null;
    }

    public int getStartInventorySide(int side) {
        return 0;
    }

    public int getSizeInventorySide(int side) {
        return this.getSizeInventory();
    }

    public void writeToNBT(ady nbttagcompound) {
    }

    public void readFromNBT(ady nbttagcompound) {
    }

    protected void replenishByContainer(aan inventoryStack, TankSlot tank) {
        LiquidContainer container = LiquidManager.getLiquidContainer(inventoryStack);
        this.replenishByContainer(inventoryStack, container, tank);
    }

    protected aan replenishByContainer(aan inventoryStack, LiquidContainer container, TankSlot tank) {
        if (container == null) {
            return inventoryStack;
        }
        if (tank.fill(null, container.liquid.liquidAmount, container.liquid.itemID, false) >= container.liquid.liquidAmount) {
            tank.fill(null, container.liquid.liquidAmount, container.liquid.itemID, true);
            if (container.isBucket) {
                inventoryStack = container.empty.k();
            } else {
                --inventoryStack.a;
            }
        }
        return inventoryStack;
    }

    protected aan bottleIntoContainer(aan canStack, aan outputStack, LiquidContainer container, TankSlot tank) {
        if (tank.quantity < container.liquid.liquidAmount) {
            return outputStack;
        }
        if (canStack.a <= 0) {
            return outputStack;
        }
        if (outputStack != null && !outputStack.a(container.filled)) {
            return outputStack;
        }
        if (outputStack != null && outputStack.a >= outputStack.c()) {
            return outputStack;
        }
        tank.quantity -= container.liquid.liquidAmount;
        --canStack.a;
        if (outputStack == null) {
            outputStack = container.filled.k();
        } else {
            ++outputStack.a;
        }
        return outputStack;
    }

    public int fill(Orientations from, int quantity, int id, boolean doFill) {
        return 0;
    }

    public int empty(int quantityMax, boolean doEmpty) {
        return 0;
    }

    public int getLiquidQuantity() {
        return 0;
    }

    public int getLiquidId() {
        return 0;
    }

    public int getCapacity() {
        return 0;
    }

    public TankSlot[] getContents() {
        return new TankSlot[0];
    }

    public TankLevel getPrimaryLevel() {
        return TankLevel.EMPTY;
    }

    public TankLevel getSecondaryLevel() {
        return TankLevel.EMPTY;
    }

    public TankLevel rateTankLevel(int scaled) {
        if (scaled < 5) {
            return TankLevel.EMPTY;
        }
        if (scaled < 30) {
            return TankLevel.LOW;
        }
        if (scaled < 60) {
            return TankLevel.MEDIUM;
        }
        if (scaled < 90) {
            return TankLevel.HIGH;
        }
        return TankLevel.MAXIMUM;
    }

    public boolean isIndirectlyPoweringTo(xd world, int i, int j, int k, int l) {
        return false;
    }

    public boolean isPoweringTo(ali iblockaccess, int i, int j, int k, int l) {
        return false;
    }

    public void onNeighborBlockChange() {
    }

    public abstract void getGUINetworkData(int var1, int var2);

    public abstract void sendGUINetworkData(dd var1, wm var2);

    public boolean emitsEnergyTo(kw receiver, Direction direction) {
        return false;
    }

    public boolean isAddedToEnergyNet() {
        return false;
    }

    public int getMaxEnergyOutput() {
        return 0;
    }

    public LinkedList getCustomTriggers() {
        return null;
    }

    public void performAction(kw entity) {
    }
}

