/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import forestry.core.EnginePackage;
import forestry.core.IEntityHandler;
import forestry.core.MachinePackage;
import forestry.core.utils.StructureBlueprint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class GadgetManager {
    static HashMap enginePackagesByMeta = new HashMap();
    static HashMap growerPackagesByMeta = new HashMap();
    static HashMap machinePackagesByMeta = new HashMap();
    static HashMap harvesterPackagesByMeta = new HashMap();
    static HashMap planterPackagesByMeta = new HashMap();
    static ArrayList entityHandler = new ArrayList();

    public static void registerAllPackageNames() {
        for (IEntityHandler handler : entityHandler) {
            handler.registerAllPackageNames();
        }
    }

    public static boolean registerEnginePackage(int meta, EnginePackage pack) {
        if (enginePackagesByMeta.containsKey(meta)) {
            return false;
        }
        enginePackagesByMeta.put(meta, pack);
        for (IEntityHandler handler : entityHandler) {
            handler.registerEngine(meta, pack);
        }
        return true;
    }

    public static boolean registerMachinePackage(int meta, MachinePackage pack) {
        if (machinePackagesByMeta.containsKey(meta)) {
            return false;
        }
        machinePackagesByMeta.put(meta, pack);
        for (IEntityHandler handler : entityHandler) {
            handler.registerMachine(meta, pack);
        }
        return true;
    }

    public static boolean registerHarvesterPackage(int meta, MachinePackage pack) {
        if (harvesterPackagesByMeta.containsKey(meta)) {
            return false;
        }
        harvesterPackagesByMeta.put(meta, pack);
        for (IEntityHandler handler : entityHandler) {
            handler.registerHarvester(meta, pack);
        }
        return true;
    }

    public static boolean registerPlanterPackage(int meta, MachinePackage pack) {
        if (planterPackagesByMeta.containsKey(meta)) {
            return false;
        }
        for (StructureBlueprint blueprint : pack.blueprints) {
            StructureBlueprint.index.put(blueprint.id, blueprint);
        }
        planterPackagesByMeta.put(meta, pack);
        for (IEntityHandler handler : entityHandler) {
            handler.registerPlanter(meta, pack);
        }
        return true;
    }

    public static boolean registerMillPackage(int meta, MachinePackage pack) {
        if (growerPackagesByMeta.containsKey(meta)) {
            return false;
        }
        growerPackagesByMeta.put(meta, pack);
        for (IEntityHandler handler : entityHandler) {
            handler.registerMill(meta, pack);
        }
        return true;
    }

    public static void registerEntityHandler(IEntityHandler handler) {
        entityHandler.add(handler);
    }

    public static Iterator getEngineKeyIterator() {
        return enginePackagesByMeta.keySet().iterator();
    }

    public static EnginePackage getEnginePackage(int meta) {
        return (EnginePackage)enginePackagesByMeta.get(meta);
    }

    public static boolean hasEnginePackage(int meta) {
        return enginePackagesByMeta.containsKey(meta);
    }

    public static Iterator getMachineKeyIterator() {
        return machinePackagesByMeta.keySet().iterator();
    }

    public static MachinePackage getMachinePackage(int meta) {
        return (MachinePackage)machinePackagesByMeta.get(meta);
    }

    public static boolean hasMachinePackage(int meta) {
        return machinePackagesByMeta.containsKey(meta);
    }

    public static Iterator getHarvesterKeyIterator() {
        return harvesterPackagesByMeta.keySet().iterator();
    }

    public static MachinePackage getHarvesterPackage(int meta) {
        return (MachinePackage)harvesterPackagesByMeta.get(meta);
    }

    public static boolean hasHarvesterPackage(int meta) {
        return harvesterPackagesByMeta.containsKey(meta);
    }

    public static Iterator getPlanterKeyIterator() {
        return planterPackagesByMeta.keySet().iterator();
    }

    public static MachinePackage getPlanterPackage(int meta) {
        return (MachinePackage)planterPackagesByMeta.get(meta);
    }

    public static boolean hasPlanterPackage(int meta) {
        return planterPackagesByMeta.containsKey(meta);
    }

    public static MachinePackage getMillPackage(int meta) {
        return (MachinePackage)growerPackagesByMeta.get(meta);
    }

    public static Iterator getGrowerKeyIterator() {
        return growerPackagesByMeta.keySet().iterator();
    }

    public static boolean hasGrowerPackage(int meta) {
        return growerPackagesByMeta.containsKey(meta);
    }
}

