/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import buildcraft.api.PowerFramework;
import forestry.api.apiculture.FlowerManager;
import forestry.api.core.ForestryAPI;
import forestry.api.core.ForestryBlock;
import forestry.api.core.GlobalManager;
import forestry.api.core.IPlugin;
import forestry.api.fuels.EngineBronzeFuel;
import forestry.api.fuels.EngineCopperFuel;
import forestry.api.fuels.FermenterFuel;
import forestry.api.fuels.FuelManager;
import forestry.api.fuels.MoistenerFuel;
import forestry.api.fuels.RainSubstrate;
import forestry.api.liquids.LiquidContainer;
import forestry.api.liquids.LiquidManager;
import forestry.api.liquids.LiquidStack;
import forestry.api.recipes.RecipeManagers;
import forestry.core.EntityHandler;
import forestry.core.GadgetManager;
import forestry.core.PickupHandler;
import forestry.core.Proxy;
import forestry.core.ProxyBase;
import forestry.core.WorldGenBogEarth;
import forestry.core.WorldGenMinableMeta;
import forestry.core.config.AchievementManager;
import forestry.core.config.Config;
import forestry.core.config.Defaults;
import forestry.core.config.ForestryItem;
import forestry.core.config.OreHandler;
import forestry.core.utils.CraftingRecipe;
import forestry.plugins.PluginBuildCraft;
import forestry.plugins.PluginManager;
import forge.IOreHandler;
import forge.IPickupHandler;
import forge.MinecraftForge;
import forge.NetworkMod;
import java.util.Random;

public class ForestryCore {
    public static NetworkMod instance;
    public static OreHandler oreHandler;
    public static EntityHandler entityHandler;

    public static void load(NetworkMod basemod) {
        instance = basemod;
        MinecraftForge.versionDetect((String)Defaults.MOD, (int)3, (int)0, (int)0);
        Config.load();
        PluginManager.loadPlugins();
        for (IPlugin plugin : PluginManager.plugins) {
            if (plugin.isAvailable()) {
                plugin.preInit();
                continue;
            }
            ModLoader.getLogger().fine("Skipped plugin " + plugin.getClass() + " because preconditions were not met.");
        }
        oreHandler = new OreHandler();
        MinecraftForge.registerOreHandler((IOreHandler)oreHandler);
        MinecraftForge.registerPickupHandler((IPickupHandler)new PickupHandler());
        entityHandler = new EntityHandler();
        GadgetManager.registerEntityHandler(entityHandler);
        ForestryAPI.registerWrench(new aan(ForestryItem.wrench));
        Config.registerStandardRecipes();
        FuelManager.fermenterFuel.put(ForestryItem.fertilizerCompound.bQ, new FermenterFuel(new aan(ForestryItem.fertilizerCompound), 56, 200));
        FuelManager.fermenterFuel.put(ForestryItem.fertilizerBio.bQ, new FermenterFuel(new aan(ForestryItem.fertilizerBio), 48, 250));
        FuelManager.fermenterFuel.put(ForestryItem.mulch.bQ, new FermenterFuel(new aan(ForestryItem.mulch), 48, 250));
        FuelManager.moistenerResource.put(yr.T.bQ, new MoistenerFuel(new aan(yr.T), new aan(ForestryItem.mouldyWheat), 0, 300));
        FuelManager.moistenerResource.put(ForestryItem.mouldyWheat.bQ, new MoistenerFuel(new aan(ForestryItem.mouldyWheat), new aan(ForestryItem.decayingWheat), 1, 600));
        FuelManager.moistenerResource.put(ForestryItem.decayingWheat.bQ, new MoistenerFuel(new aan(ForestryItem.decayingWheat), new aan(ForestryItem.mulch), 2, 900));
        FuelManager.copperEngineFuel.put(ForestryItem.peat.bQ, new EngineCopperFuel(new aan(ForestryItem.peat), 1, 5000));
        FuelManager.copperEngineFuel.put(ForestryItem.bituminousPeat.bQ, new EngineCopperFuel(new aan(ForestryItem.bituminousPeat), 2, 6000));
        FuelManager.bronzeEngineFuel.put(ForestryItem.liquidBiomass.bQ, new EngineBronzeFuel(new aan(ForestryItem.liquidBiomass), 5, 10000, 1));
        FuelManager.bronzeEngineFuel.put(pb.B.bO, new EngineBronzeFuel(new aan(pb.B), 1, 1000, 2));
        FuelManager.bronzeEngineFuel.put(ForestryItem.liquidMilk.bQ, new EngineBronzeFuel(new aan(ForestryItem.liquidMilk), 1, 40000, 1));
        FuelManager.bronzeEngineFuel.put(yr.aG.bQ, new EngineBronzeFuel(new aan(yr.aG), 1, 40000, 1));
        FuelManager.bronzeEngineFuel.put(ForestryItem.liquidSeedOil.bQ, new EngineBronzeFuel(new aan(ForestryItem.liquidSeedOil), 3, 10000, 1));
        FuelManager.bronzeEngineFuel.put(ForestryItem.liquidHoney.bQ, new EngineBronzeFuel(new aan(ForestryItem.liquidHoney), 1, 10000, 1));
        FuelManager.bronzeEngineFuel.put(ForestryItem.liquidHoney.bQ, new EngineBronzeFuel(new aan(ForestryItem.liquidJuice), 1, 10000, 1));
        FuelManager.rainSubstrate.put(ForestryItem.iodineCharge.bQ, new RainSubstrate(new aan(ForestryItem.iodineCharge), 10000, 0.01f));
        FuelManager.rainSubstrate.put(ForestryItem.craftingMaterial.bQ, new RainSubstrate(new aan(ForestryItem.craftingMaterial, 1, 4), 0.02f));
        GlobalManager.holyBlockIds.add(ForestryBlock.soil.bO);
        GlobalManager.holyBlockIds.add(ForestryBlock.planter.bO);
        GlobalManager.holyBlockIds.add(ForestryBlock.harvester.bO);
        GlobalManager.holyBlockIds.add(ForestryBlock.engine.bO);
        GlobalManager.holyBlockIds.add(ForestryBlock.machine.bO);
        GlobalManager.holyBlockIds.add(ForestryBlock.mill.bO);
        GlobalManager.holyBlockIds.add(pb.aQ.bO);
        GlobalManager.holyBlockIds.add(pb.aP.bO);
        GlobalManager.holyBlockIds.add(pb.al.bO);
        GlobalManager.holyBlockIds.add(pb.bm.bO);
        GlobalManager.holyBlockIds.add(pb.aJ.bO);
        GlobalManager.holyBlockIds.add(pb.z.bO);
        GlobalManager.holyBlockIds.add(pb.au.bO);
        GlobalManager.holyBlockIds.add(pb.w.bO);
        GlobalManager.holyBlockIds.add(pb.ao.bO);
        GlobalManager.holyBlockIds.add(pb.bA.bO);
        GlobalManager.holyBlockIds.add(pb.aq.bO);
        GlobalManager.holyBlockIds.add(pb.x.bO);
        FlowerManager.plainFlowers.add(new aan((pb)pb.ae));
        FlowerManager.plainFlowers.add(new aan((pb)pb.ad));
    }

    public static void modsLoaded() {
        CraftingRecipe gearTin;
        CraftingRecipe gearCopper;
        CraftingRecipe gearBronze;
        for (IPlugin plugin : PluginManager.plugins) {
            if (!plugin.isAvailable()) continue;
            plugin.doInit();
        }
        ForestryCore.injectLiquidContainer(new LiquidContainer(new LiquidStack(ForestryItem.liquidMilk, 1000), new aan(yr.aG), new aan(yr.aw), true));
        ForestryCore.injectLiquidContainer(new LiquidContainer(new LiquidStack(pb.D, 1000), new aan(yr.ay), new aan(yr.aw), true));
        ForestryCore.injectTinContainer(new LiquidContainer(new LiquidStack(pb.D, 1000), new aan(ForestryItem.canLava), new aan(ForestryItem.canEmpty), false));
        ForestryCore.injectRefractoryContainer(new LiquidContainer(new LiquidStack(pb.D, 1000), new aan(ForestryItem.refractoryLava), new aan(ForestryItem.refractoryEmpty), false));
        ForestryCore.injectLiquidContainer(new LiquidContainer(new LiquidStack(pb.B, 1000), new aan((yr)yr.bs, 1, 0), new aan(yr.bt), true));
        ForestryCore.injectLiquidContainer(new LiquidContainer(new LiquidStack(pb.B, 1000), new aan(yr.ax), new aan(yr.aw), true));
        ForestryCore.injectTinContainer(new LiquidContainer(new LiquidStack(pb.B, 1000), new aan(ForestryItem.canWater), new aan(ForestryItem.canEmpty), false));
        ForestryCore.injectWaxContainer(new LiquidContainer(new LiquidStack(pb.B, 1000), new aan(ForestryItem.waxCapsuleWater), new aan(ForestryItem.waxCapsule), false));
        ForestryCore.injectRefractoryContainer(new LiquidContainer(new LiquidStack(pb.B, 1000), new aan(ForestryItem.refractoryWater), new aan(ForestryItem.refractoryEmpty), false));
        ForestryCore.injectLiquidContainer(new LiquidContainer(new LiquidStack(ForestryItem.liquidBiomass, 1000), new aan(ForestryItem.bucketBiomass), new aan(yr.aw), true));
        ForestryCore.injectTinContainer(new LiquidContainer(new LiquidStack(ForestryItem.liquidBiomass, 1000), new aan(ForestryItem.canBiomass), new aan(ForestryItem.canEmpty), false));
        ForestryCore.injectWaxContainer(new LiquidContainer(new LiquidStack(ForestryItem.liquidBiomass, 1000), new aan(ForestryItem.waxCapsuleBiomass), new aan(ForestryItem.waxCapsule), false));
        ForestryCore.injectRefractoryContainer(new LiquidContainer(new LiquidStack(ForestryItem.liquidBiomass, 1000), new aan(ForestryItem.refractoryBiomass), new aan(ForestryItem.refractoryEmpty), false));
        ForestryCore.injectLiquidContainer(new LiquidContainer(new LiquidStack(ForestryItem.liquidBiofuel, 1000), new aan(ForestryItem.bucketBiofuel), new aan(yr.aw), true));
        ForestryCore.injectTinContainer(new LiquidContainer(new LiquidStack(ForestryItem.liquidBiofuel, 1000), new aan(ForestryItem.canBiofuel), new aan(ForestryItem.canEmpty), false));
        ForestryCore.injectWaxContainer(new LiquidContainer(new LiquidStack(ForestryItem.liquidBiofuel, 1000), new aan(ForestryItem.waxCapsuleBiofuel), new aan(ForestryItem.waxCapsule), false));
        ForestryCore.injectRefractoryContainer(new LiquidContainer(new LiquidStack(ForestryItem.liquidBiofuel, 1000), new aan(ForestryItem.refractoryBiofuel), new aan(ForestryItem.refractoryEmpty), false));
        ForestryCore.injectTinContainer(new LiquidContainer(new LiquidStack(ForestryItem.liquidSeedOil, 1000), new aan(ForestryItem.canSeedOil), new aan(ForestryItem.canEmpty), false));
        ForestryCore.injectWaxContainer(new LiquidContainer(new LiquidStack(ForestryItem.liquidSeedOil, 1000), new aan(ForestryItem.waxCapsuleSeedOil), new aan(ForestryItem.waxCapsule), false));
        ForestryCore.injectRefractoryContainer(new LiquidContainer(new LiquidStack(ForestryItem.liquidSeedOil, 1000), new aan(ForestryItem.refractorySeedOil), new aan(ForestryItem.refractoryEmpty), false));
        ForestryCore.injectTinContainer(new LiquidContainer(new LiquidStack(ForestryItem.liquidHoney, 1000), new aan(ForestryItem.canHoney), new aan(ForestryItem.canEmpty), false));
        ForestryCore.injectWaxContainer(new LiquidContainer(new LiquidStack(ForestryItem.liquidHoney, 1000), new aan(ForestryItem.waxCapsuleHoney), new aan(ForestryItem.waxCapsule), false));
        ForestryCore.injectRefractoryContainer(new LiquidContainer(new LiquidStack(ForestryItem.liquidHoney, 1000), new aan(ForestryItem.refractoryHoney), new aan(ForestryItem.refractoryEmpty), false));
        ForestryCore.injectTinContainer(new LiquidContainer(new LiquidStack(ForestryItem.liquidJuice, 1000), new aan(ForestryItem.canJuice), new aan(ForestryItem.canEmpty), false));
        ForestryCore.injectWaxContainer(new LiquidContainer(new LiquidStack(ForestryItem.liquidJuice, 1000), new aan(ForestryItem.waxCapsuleJuice), new aan(ForestryItem.waxCapsule), false));
        ForestryCore.injectRefractoryContainer(new LiquidContainer(new LiquidStack(ForestryItem.liquidJuice, 1000), new aan(ForestryItem.refractoryJuice), new aan(ForestryItem.refractoryEmpty), false));
        Config.modsLoaded();
        ModLoader.getLogger().fine("Using " + PowerFramework.currentFramework.getClass().getName() + " as framework.");
        oreHandler.initApatiteOre();
        oreHandler.initOreBlocks();
        if (Config.bronzeRecipeEnabled) {
            CraftingRecipe bronzeIngot = new CraftingRecipe(new aan(ForestryItem.ingotBronze.c, 4, ForestryItem.ingotBronze.i()), new Object[]{"##", "#X", Character.valueOf('#'), ForestryItem.ingotCopper, Character.valueOf('X'), ForestryItem.ingotTin});
            oreHandler.registerDictionaryRecipe(bronzeIngot);
        }
        CraftingRecipe sturdyMachine = new CraftingRecipe(new aan(ForestryItem.sturdyMachine, 1), new Object[]{"###", "# #", "###", Character.valueOf('#'), ForestryItem.ingotBronze});
        oreHandler.registerDictionaryRecipe(sturdyMachine);
        CraftingRecipe emptyCan = new CraftingRecipe(new aan(ForestryItem.canEmpty, 12), new Object[]{" # ", "# #", Character.valueOf('#'), ForestryItem.ingotTin});
        oreHandler.registerDictionaryRecipe(emptyCan);
        if (PluginBuildCraft.stoneGear != null) {
            gearBronze = new CraftingRecipe(new aan(ForestryItem.gearBronze, 1), new Object[]{" # ", "#Y#", " # ", Character.valueOf('#'), ForestryItem.ingotBronze, Character.valueOf('Y'), PluginBuildCraft.stoneGear});
            gearCopper = new CraftingRecipe(new aan(ForestryItem.gearCopper, 1), new Object[]{" # ", "#Y#", " # ", Character.valueOf('#'), ForestryItem.ingotCopper, Character.valueOf('Y'), PluginBuildCraft.stoneGear});
            gearTin = new CraftingRecipe(new aan(ForestryItem.gearTin, 1), new Object[]{" # ", "#Y#", " # ", Character.valueOf('#'), ForestryItem.ingotTin, Character.valueOf('Y'), PluginBuildCraft.stoneGear});
        } else {
            gearBronze = new CraftingRecipe(new aan(ForestryItem.gearBronze, 1), new Object[]{" # ", "#X#", " # ", Character.valueOf('#'), ForestryItem.ingotBronze, Character.valueOf('X'), ForestryItem.ingotCopper});
            gearCopper = new CraftingRecipe(new aan(ForestryItem.gearCopper, 1), new Object[]{" # ", "#X#", " # ", Character.valueOf('#'), ForestryItem.ingotCopper, Character.valueOf('X'), ForestryItem.ingotCopper});
            gearTin = new CraftingRecipe(new aan(ForestryItem.gearTin, 1), new Object[]{" # ", "#X#", " # ", Character.valueOf('#'), ForestryItem.ingotTin, Character.valueOf('X'), ForestryItem.ingotCopper});
        }
        oreHandler.registerDictionaryRecipe(gearBronze);
        oreHandler.registerDictionaryRecipe(gearCopper);
        oreHandler.registerDictionaryRecipe(gearTin);
        CraftingRecipe wrench = new CraftingRecipe(new aan(ForestryItem.wrench, 1), new Object[]{"# #", " # ", " # ", Character.valueOf('#'), ForestryItem.ingotBronze});
        oreHandler.registerDictionaryRecipe(wrench);
        Proxy.addRecipe(new aan(ForestryBlock.planter, 1, 0), new Object[]{"X", Character.valueOf('X'), new aan(ForestryBlock.planter, 1, 2)});
        Proxy.addRecipe(new aan(ForestryBlock.harvester, 1, 0), new Object[]{"X", Character.valueOf('X'), new aan(ForestryBlock.harvester, 1, 2)});
        for (IPlugin plugin : PluginManager.plugins) {
            if (!plugin.isAvailable()) continue;
            plugin.postInit();
        }
        AchievementManager.initialize();
        GadgetManager.registerAllPackageNames();
        Config.saveToFile();
    }

    public static int addFuel(int i, int j) {
        if (i == ForestryItem.peat.bQ) {
            return 1600;
        }
        return 0;
    }

    public static void generateSurface(xd world, Random rand, int chunkX, int chunkZ) {
        int randPosZ;
        int randPosY;
        int randPosX;
        int i;
        if (Config.generateApatiteOre) {
            for (i = 0; i < 8; ++i) {
                randPosX = chunkX + rand.nextInt(16);
                randPosY = rand.nextInt(76) + 16;
                randPosZ = chunkZ + rand.nextInt(16);
                new WorldGenMinableMeta(ForestryBlock.resources.bO, 0, 8).a(world, rand, randPosX, randPosY, randPosZ);
            }
        }
        if (Config.generateCopperOre) {
            for (i = 0; i < 20; ++i) {
                randPosX = chunkX + rand.nextInt(16);
                randPosY = rand.nextInt(76);
                randPosZ = chunkZ + rand.nextInt(16);
                new WorldGenMinableMeta(ForestryBlock.resources.bO, 1, 6).a(world, rand, randPosX, randPosY, randPosZ);
            }
        }
        if (Config.generateTinOre) {
            for (i = 0; i < 15; ++i) {
                randPosX = chunkX + rand.nextInt(16);
                randPosY = rand.nextInt(76);
                randPosZ = chunkZ + rand.nextInt(16);
                new WorldGenMinableMeta(ForestryBlock.resources.bO, 2, 6).a(world, rand, randPosX, randPosY, randPosZ);
            }
        }
        if (Config.generateBogEarth) {
            for (i = 0; i < 10; ++i) {
                randPosX = chunkX + rand.nextInt(16) + 8;
                randPosY = rand.nextInt(ProxyBase.getWorldHeigth(world));
                randPosZ = chunkZ + rand.nextInt(16) + 8;
                new WorldGenBogEarth().a(world, rand, randPosX, randPosY, randPosZ);
            }
        }
        for (IPlugin plugin : PluginManager.plugins) {
            if (!plugin.isAvailable()) continue;
            plugin.generateSurface(world, rand, chunkX, chunkZ);
        }
    }

    public static void takenFromCrafting(yw player, aan itemstack, io inventory) {
        AchievementManager.itemCrafting(player, itemstack);
    }

    public static String getPriorities() {
        return "";
    }

    public static String getVersion() {
        String version = "1.4.6.2c";
        return version;
    }

    public static void injectLiquidContainer(LiquidContainer container) {
        ForestryCore.injectLiquidContainer(container, null, 0);
    }

    public static void injectWaxContainer(LiquidContainer container) {
        ForestryCore.injectLiquidContainer(container, new aan(ForestryItem.beeswax), 10);
    }

    public static void injectRefractoryContainer(LiquidContainer container) {
        ForestryCore.injectLiquidContainer(container, new aan(ForestryItem.refractoryWax), 10);
    }

    public static void injectTinContainer(LiquidContainer container) {
        ForestryCore.injectLiquidContainer(container, ForestryItem.ingotTin, 5);
    }

    public static void injectLiquidContainer(LiquidContainer container, aan remnant, int chance) {
        LiquidManager.registerLiquidContainer(container);
        if (RecipeManagers.squeezerManager != null && !container.isBucket) {
            if (remnant != null) {
                RecipeManagers.squeezerManager.addRecipe(10, new aan[]{container.filled}, container.liquid, remnant, chance);
            } else {
                RecipeManagers.squeezerManager.addRecipe(10, new aan[]{container.filled}, container.liquid);
            }
        }
        if (RecipeManagers.bottlerManager != null) {
            RecipeManagers.bottlerManager.addRecipe(5, container.liquid, container.empty, container.filled);
        }
    }
}

