/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import forestry.api.liquids.LiquidContainer;
import forestry.core.EnumErrorCode;
import forestry.core.TemperatureState;
import forestry.core.TileEngine;
import forestry.core.network.IndexInPayload;
import forestry.core.network.PacketPayload;
import forestry.core.utils.ContainerForestry;
import forestry.core.utils.Orientations;
import forestry.core.utils.TankSlot;
import ic2.api.Direction;
import java.util.LinkedList;

public abstract class Engine {
    protected int currentOutput = 0;
    public int maxEnergy;
    public int maxEnergyExtracted;
    public int storedEnergy;
    public int heat;
    protected int maxHeat;
    protected boolean forceCooldown = false;
    public float progress;
    protected TileEngine tile;
    private String[] hints;

    public PacketPayload getPacketPayload() {
        PacketPayload payload = new PacketPayload(6, 0, 0);
        payload.intPayload[0] = this.maxEnergy;
        payload.intPayload[1] = this.maxEnergyExtracted;
        payload.intPayload[2] = this.storedEnergy;
        payload.intPayload[3] = this.maxHeat;
        payload.intPayload[4] = this.heat;
        return payload;
    }

    public void fromPacketPayload(PacketPayload payload, IndexInPayload index) {
        this.maxEnergy = payload.intPayload[index.intIndex + 0];
        this.maxEnergyExtracted = payload.intPayload[index.intIndex + 1];
        this.storedEnergy = payload.intPayload[index.intIndex + 2];
        this.maxHeat = payload.intPayload[index.intIndex + 3];
        this.heat = payload.intPayload[index.intIndex + 4];
    }

    public Engine(TileEngine tile) {
        this.tile = tile;
    }

    public abstract void openGui(yw var1, kw var2);

    protected aan replenishByContainer(aan inventoryStack, LiquidContainer container, TankSlot tank) {
        if (container == null) {
            return inventoryStack;
        }
        if (tank.fill(null, container.liquid.liquidAmount, container.liquid.itemID, false) >= container.liquid.liquidAmount) {
            tank.fill(null, container.liquid.liquidAmount, container.liquid.itemID, true);
            if (container.isBucket) {
                inventoryStack = container.empty.k();
            } else {
                --inventoryStack.a;
            }
        }
        return inventoryStack;
    }

    public void addEnergy(int addition) {
        this.storedEnergy += addition;
        if (this.storedEnergy > this.maxEnergy) {
            this.storedEnergy = this.maxEnergy;
        }
    }

    public int extractEnergy(int min, int max, boolean doExtract) {
        int extracted;
        if (this.storedEnergy < min) {
            return 0;
        }
        int ceiling = max > this.maxEnergyExtracted ? this.maxEnergyExtracted : max;
        if (this.storedEnergy >= ceiling) {
            extracted = ceiling;
            if (doExtract) {
                this.storedEnergy -= ceiling;
            }
        } else {
            extracted = this.storedEnergy;
            if (doExtract) {
                this.storedEnergy = 0;
            }
        }
        return extracted;
    }

    protected void addHeat(int i) {
        this.heat += i;
        if (this.heat > this.maxHeat) {
            this.heat = this.maxHeat;
        }
    }

    public abstract int dissipateHeat();

    public abstract int generateHeat();

    public int maxEnergyReceived() {
        return 200;
    }

    public boolean mayBurn() {
        return !this.forceCooldown;
    }

    public abstract void burn();

    public void update() {
        TemperatureState energyState = this.getTemperatureState();
        if (energyState == TemperatureState.MELTING && this.heat > 0) {
            this.forceCooldown = true;
        } else if (this.forceCooldown && this.heat <= 0) {
            this.forceCooldown = false;
        }
    }

    protected double getHeatLevel() {
        return (double)this.heat / (double)this.maxHeat;
    }

    public abstract boolean isBurning();

    public int getBurnTimeRemainingScaled(int i) {
        return 0;
    }

    public boolean hasFuelMin(float percentage) {
        return false;
    }

    public int getCurrentOutput() {
        if (this.isBurning() && this.tile.isActivated()) {
            return this.currentOutput;
        }
        return 0;
    }

    public int getEnergyStored() {
        return this.storedEnergy;
    }

    public int getHeat() {
        return this.heat;
    }

    public void setErrorState(EnumErrorCode state) {
        this.tile.setErrorState(state);
    }

    public EnumErrorCode getErrorState() {
        return this.tile.getErrorState();
    }

    public void setHints(String[] hints) {
        this.hints = hints;
    }

    public boolean hasHints() {
        return this.hints != null && this.hints.length > 0;
    }

    public String[] getHints() {
        return this.hints;
    }

    public TemperatureState getTemperatureState() {
        double scaledHeat = (double)this.heat / (double)this.maxHeat;
        if (scaledHeat < 0.2) {
            return TemperatureState.COOL;
        }
        if (scaledHeat < 0.5) {
            return TemperatureState.WARMED_UP;
        }
        if (scaledHeat < 0.75) {
            return TemperatureState.OPERATING_TEMPERATURE;
        }
        if (scaledHeat < 1.0) {
            return TemperatureState.OVERHEATING;
        }
        return TemperatureState.MELTING;
    }

    public float getPistonSpeed() {
        switch (this.getTemperatureState()) {
            case COOL: {
                return 0.03f;
            }
            case WARMED_UP: {
                return 0.04f;
            }
            case OPERATING_TEMPERATURE: {
                return 0.05f;
            }
            case OVERHEATING: {
                return 0.06f;
            }
            case MELTING: {
                return 0.07f;
            }
        }
        return 0.0f;
    }

    public void readFromNBT(ady nbttagcompound) {
        this.heat = nbttagcompound.f("EngineHeat");
        this.storedEnergy = nbttagcompound.f("EngineStoredEnergy");
        this.progress = nbttagcompound.h("EngineProgress");
        this.forceCooldown = nbttagcompound.o("ForceCooldown");
    }

    public void writeToNBT(ady nbttagcompound) {
        nbttagcompound.a("EngineHeat", this.heat);
        nbttagcompound.a("EngineStoredEnergy", this.storedEnergy);
        nbttagcompound.a("EngineProgress", this.progress);
        nbttagcompound.a("ForceCooldown", this.forceCooldown);
    }

    public abstract void getGUINetworkData(int var1, int var2);

    public abstract void sendGUINetworkData(ContainerForestry var1, wm var2);

    public int getSizeInventory() {
        return 0;
    }

    public aan getStackInSlot(int i) {
        return null;
    }

    public aan decrStackSize(int i, int j) {
        return null;
    }

    public void setInventorySlotContents(int i, aan itemstack) {
    }

    public String getInvName() {
        return "Engine";
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public aan extractSlot(int slot) {
        return null;
    }

    public int getStartInventorySide(int side) {
        return 0;
    }

    public int getSizeInventorySide(int side) {
        return this.getSizeInventory();
    }

    public boolean addItem(aan stack, boolean doAdd, Orientations from) {
        return false;
    }

    public aan extractItem(boolean doRemove, Orientations from) {
        return null;
    }

    public int fill(Orientations from, int quantity, int id, boolean doFill) {
        return 0;
    }

    public TankSlot[] getContents() {
        return new TankSlot[0];
    }

    public boolean acceptsEnergyFrom(kw emitter, Direction direction) {
        return false;
    }

    public boolean isAddedToEnergyNet() {
        return false;
    }

    public boolean demandsEnergy() {
        return false;
    }

    public int injectEnergy(Direction directionFrom, int amount) {
        return 0;
    }

    public LinkedList getCustomTriggers() {
        return null;
    }

    public boolean hasSockets() {
        return false;
    }

    public aan getSocket(int slot) {
        return null;
    }

    public void setSocket(aan stack) {
    }
}

