/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.genetics.IAllele;
import forestry.apiculture.genetics.Mutation;
import java.util.Calendar;

public class MutationTimeLimited
extends Mutation {
    DayMonth start;
    DayMonth end;

    public MutationTimeLimited(IAllele allele0, IAllele allele1, IAllele[] template, int chance, DayMonth start) {
        this(allele0, allele1, template, chance, start, null);
    }

    public MutationTimeLimited(IAllele allele0, IAllele allele1, IAllele[] template, int chance, DayMonth start, DayMonth end) {
        super(allele0, allele1, template, chance);
        this.start = start;
        this.end = end;
    }

    @Override
    public int getChance(xd world, int biomeid, int x, int y, int z, IAllele allele0, IAllele allele1) {
        int chance = super.getChance(world, biomeid, x, y, z, allele0, allele1);
        if (chance == 0) {
            return 0;
        }
        if (this.start == null && this.end == null) {
            return chance;
        }
        DayMonth now = new DayMonth();
        if (Calendar.getInstance().get(5) == this.start.day && Calendar.getInstance().get(2) + 1 == this.start.month) {
            return chance;
        }
        if (this.end == null) {
            return 0;
        }
        if (Calendar.getInstance().get(5) == this.end.day && Calendar.getInstance().get(2) + 1 == this.end.month) {
            return chance;
        }
        if (this.start.before(now) && this.end.after(now)) {
            return chance;
        }
        return 0;
    }

    public static class DayMonth {
        public int day;
        public int month;

        public DayMonth() {
            this.day = Calendar.getInstance().get(5);
            this.month = Calendar.getInstance().get(2) + 1;
        }

        public DayMonth(int day, int month) {
            this.day = day;
            this.month = month;
        }

        public boolean before(DayMonth other) {
            if (other.month > this.month) {
                return true;
            }
            if (other.month < this.month) {
                return false;
            }
            return this.day < other.day;
        }

        public boolean after(DayMonth other) {
            if (other.month < this.month) {
                return true;
            }
            if (other.month > this.month) {
                return false;
            }
            return this.day > other.day;
        }

        public String toString() {
            return this.day + "." + this.month;
        }
    }
}

