/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IAlleleFlowers;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IFlowerProvider;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IChromosome;
import forestry.core.genetics.AlleleArea;
import forestry.core.genetics.AlleleBoolean;
import forestry.core.genetics.AlleleFloat;
import forestry.core.genetics.AlleleInteger;
import forestry.core.genetics.AlleleTolerance;
import forestry.core.genetics.Genome;
import forestry.core.utils.Vect;

public class BeeGenome
extends Genome
implements IBeeGenome {
    public BeeGenome(ady nbttagcompound) {
        super(EnumBeeChromosome.values().length, nbttagcompound);
    }

    public BeeGenome(IChromosome[] chromosomes) {
        super(chromosomes);
    }

    @Override
    public IAlleleSpecies getPrimary() {
        return (IAlleleSpecies)this.getActiveAllele(EnumBeeChromosome.SPECIES.ordinal());
    }

    @Override
    public IAlleleSpecies getSecondary() {
        return (IAlleleSpecies)this.getInactiveAllele(EnumBeeChromosome.SPECIES.ordinal());
    }

    @Override
    public IAlleleBeeSpecies getPrimaryAsBee() {
        return (IAlleleBeeSpecies)this.getActiveAllele(EnumBeeChromosome.SPECIES.ordinal());
    }

    @Override
    public IAlleleBeeSpecies getSecondaryAsBee() {
        return (IAlleleBeeSpecies)this.getInactiveAllele(EnumBeeChromosome.SPECIES.ordinal());
    }

    @Override
    public float getSpeed() {
        return ((AlleleFloat)this.getActiveAllele(EnumBeeChromosome.SPEED.ordinal())).getValue();
    }

    @Override
    public int getLifespan() {
        return ((AlleleInteger)this.getActiveAllele(EnumBeeChromosome.LIFESPAN.ordinal())).getValue();
    }

    @Override
    public int getFertility() {
        return ((AlleleInteger)this.getActiveAllele(EnumBeeChromosome.FERTILITY.ordinal())).getValue();
    }

    @Override
    public EnumTolerance getToleranceTemp() {
        return ((AlleleTolerance)this.getActiveAllele(EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal())).getValue();
    }

    @Override
    public boolean getNocturnal() {
        return ((AlleleBoolean)this.getActiveAllele(EnumBeeChromosome.NOCTURNAL.ordinal())).getValue();
    }

    @Override
    public EnumTolerance getToleranceHumid() {
        return ((AlleleTolerance)this.getActiveAllele(EnumBeeChromosome.HUMIDITY_TOLERANCE.ordinal())).getValue();
    }

    @Override
    public boolean getTolerantFlyer() {
        return ((AlleleBoolean)this.getActiveAllele(EnumBeeChromosome.TOLERANT_FLYER.ordinal())).getValue();
    }

    @Override
    public boolean getCaveDwelling() {
        return ((AlleleBoolean)this.getActiveAllele(EnumBeeChromosome.CAVE_DWELLING.ordinal())).getValue();
    }

    @Override
    public IFlowerProvider getFlowerProvider() {
        return ((IAlleleFlowers)this.getActiveAllele(EnumBeeChromosome.FLOWER_PROVIDER.ordinal())).getProvider();
    }

    @Override
    public int getFlowering() {
        return ((AlleleInteger)this.getActiveAllele(EnumBeeChromosome.FLOWERING.ordinal())).getValue();
    }

    @Override
    public int[] getTerritory() {
        Vect area = ((AlleleArea)this.getActiveAllele(EnumBeeChromosome.TERRITORY.ordinal())).getArea();
        return new int[]{area.x, area.y, area.z};
    }

    @Override
    public IAlleleBeeEffect getEffect() {
        return (IAlleleBeeEffect)this.getActiveAllele(EnumBeeChromosome.EFFECT.ordinal());
    }
}

