/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.apiculture.ItemBeeGE;
import forestry.core.ForestryCore;
import forestry.core.Machine;
import forestry.core.MachineFactory;
import forestry.core.TileMachine;
import forestry.core.config.Config;
import forestry.core.network.GuiId;
import forestry.core.utils.Orientations;
import forestry.core.utils.StringUtil;

public class MachineApiaristChest
extends Machine {
    private aan[] inventoryStacks = new aan[125];

    public MachineApiaristChest(TileMachine tile) {
        super(tile);
        this.setHints((String[])Config.hints.get("apiarist.chest"));
    }

    @Override
    public String getName() {
        return StringUtil.localize("tile.mill.3");
    }

    @Override
    public void openGui(yw player, io tile) {
        player.openGui((BaseMod)ForestryCore.instance, GuiId.ApiaristChestGUI.ordinal(), player.k, this.tile.j, this.tile.k, this.tile.l);
    }

    @Override
    public void writeToNBT(ady nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        no nbttaglist = new no();
        for (int i = 0; i < this.inventoryStacks.length; ++i) {
            if (this.inventoryStacks[i] == null) continue;
            ady nbttagcompound1 = new ady();
            nbttagcompound1.a("Slot", (byte)i);
            this.inventoryStacks[i].b(nbttagcompound1);
            nbttaglist.a((gh)nbttagcompound1);
        }
        nbttagcompound.a("Items", (gh)nbttaglist);
    }

    @Override
    public void readFromNBT(ady nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        no nbttaglist = nbttagcompound.n("Items");
        this.inventoryStacks = new aan[this.getSizeInventory()];
        for (int i = 0; i < nbttaglist.d(); ++i) {
            ady nbttagcompound1 = (ady)nbttaglist.a(i);
            byte byte0 = nbttagcompound1.d("Slot");
            if (byte0 < 0 || byte0 >= this.inventoryStacks.length) continue;
            this.inventoryStacks[byte0] = aan.a((ady)nbttagcompound1);
        }
    }

    @Override
    public void update() {
    }

    @Override
    public boolean doWork() {
        return false;
    }

    @Override
    public boolean isWorking() {
        return false;
    }

    @Override
    public boolean throwsErrors() {
        return false;
    }

    @Override
    public boolean addItem(aan stack, boolean doAdd, Orientations from) {
        if (!ItemBeeGE.isBee(stack)) {
            return false;
        }
        int freeSlots = 0;
        int slot = -1;
        for (int i = 0; i < this.getSizeInventory(); ++i) {
            int space;
            if (this.getStackInSlot(i) == null) {
                ++freeSlots;
                if (slot >= 0) continue;
                slot = i;
                continue;
            }
            if (!this.getStackInSlot(i).a(stack) || (space = this.getStackInSlot(i).c() - this.getStackInSlot((int)i).a) <= 0) continue;
            if (space < stack.a) {
                if (doAdd) {
                    this.getStackInSlot((int)i).a = this.getStackInSlot(i).c();
                    stack.a -= space;
                    continue;
                }
                return true;
            }
            if (doAdd) {
                this.getStackInSlot((int)i).a += stack.a;
                stack.a = 0;
            }
            return true;
        }
        if (freeSlots <= 0) {
            return false;
        }
        if (doAdd) {
            this.setInventorySlotContents(slot, stack.k());
            stack.a = 0;
        }
        return true;
    }

    @Override
    public aan extractItem(boolean doRemove, Orientations from) {
        aan product = null;
        for (int i = 0; i < this.getSizeInventory(); ++i) {
            if (this.getStackInSlot(i) == null) continue;
            product = this.getStackInSlot(i).k();
            if (!doRemove) break;
            this.getStackInSlot((int)i).a = 0;
            this.setInventorySlotContents(i, null);
            break;
        }
        return product;
    }

    @Override
    public int getSizeInventory() {
        return this.inventoryStacks.length;
    }

    @Override
    public aan getStackInSlot(int i) {
        return this.inventoryStacks[i];
    }

    @Override
    public aan decrStackSize(int i, int j) {
        if (this.inventoryStacks[i] == null) {
            return null;
        }
        if (this.inventoryStacks[i].a <= j) {
            aan product = this.inventoryStacks[i];
            this.inventoryStacks[i] = null;
            return product;
        }
        aan product = this.inventoryStacks[i].a(j);
        if (this.inventoryStacks[i].a == 0) {
            this.inventoryStacks[i] = null;
        }
        return product;
    }

    @Override
    public void setInventorySlotContents(int i, aan itemstack) {
        this.inventoryStacks[i] = itemstack;
        if (itemstack != null && itemstack.a > this.getInventoryStackLimit()) {
            itemstack.a = this.getInventoryStackLimit();
        }
    }

    @Override
    public aan getStackInSlotOnClosing(int slot) {
        if (this.inventoryStacks[slot] == null) {
            return null;
        }
        aan toReturn = this.inventoryStacks[slot];
        this.inventoryStacks[slot] = null;
        return toReturn;
    }

    @Override
    public void getGUINetworkData(int i, int j) {
    }

    @Override
    public void sendGUINetworkData(dd container, wm iCrafting) {
    }

    public static class Factory
    extends MachineFactory {
        @Override
        public Machine createMachine(kw tile) {
            return new MachineApiaristChest((TileMachine)tile);
        }
    }
}

