/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.genetics.IAllele;
import forestry.apiculture.EnumBeeSpecies;
import forestry.apiculture.EnumMutation;
import forestry.apiculture.genetics.Bee;
import forestry.apiculture.genetics.BeeTemplates;
import forestry.core.config.ForestryItem;
import forge.ITextureProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class ItemBee
extends yr
implements ITextureProvider {
    private String ident;

    protected ItemBee(int i, int iconIndex) {
        super(i);
        this.bS = iconIndex;
        switch (iconIndex) {
            case 0: {
                this.ident = "Princess";
                break;
            }
            case 1: {
                this.ident = "Queen";
                break;
            }
            case 2: {
                this.ident = "Drone";
            }
        }
        this.bU = true;
    }

    public boolean i() {
        return false;
    }

    public boolean isRepairable() {
        return false;
    }

    public int b(int damage) {
        int dominantAllele = ItemBee.getDominantAllele(damage);
        return dominantAllele * 16 + this.bS;
    }

    public String d(aan itemstack) {
        EnumBeeSpecies species = ItemBee.getSpecies(itemstack);
        return species.getName() + " " + this.ident;
    }

    public void a(aan itemstack, List list) {
        list.add("Infertile Specimen");
        list.add("Rejuvenate in an Apiary");
    }

    public String getTextureFile() {
        return "/gfx/items/bees.png";
    }

    public boolean e(aan itemstack) {
        EnumBeeSpecies species = ItemBee.getSpecies(itemstack);
        return species.hasEffect();
    }

    public void addCreativeItems(ArrayList itemList) {
    }

    public void addCreativeItems(ArrayList itemList, boolean hideSecrets) {
        for (EnumBeeSpecies species : EnumBeeSpecies.values()) {
            if (species.isEasterEgg() && hideSecrets) continue;
            itemList.add(new aan((yr)this, 1, ItemBee.getEncodedDamage(species, species, species.getHealth())));
        }
    }

    public static int getBroodDamage(xd world, aan parent1, aan parent2, boolean isSpawn, boolean mayDiscover, int biomeId, Random rand) {
        EnumBeeSpecies allele0;
        int damage = 0;
        EnumBeeSpecies allele10 = ItemBee.getSpecies(parent1);
        EnumBeeSpecies allele11 = ItemBee.getSubSpecies(parent1);
        EnumBeeSpecies allele20 = ItemBee.getSpecies(parent2);
        EnumBeeSpecies allele21 = ItemBee.getSubSpecies(parent2);
        EnumBeeSpecies allele1 = rand.nextBoolean() ? ((allele0 = ItemBee.randomizeAllele(allele10, allele21, rand)) == allele10 ? allele20 : allele11) : ((allele0 = ItemBee.randomizeAllele(allele10, allele20, rand)) == allele10 ? allele21 : allele11);
        List<EnumMutation> mutations = Arrays.asList(EnumMutation.values());
        Collections.shuffle(mutations);
        for (EnumMutation mutation : mutations) {
            int chance;
            if (!isSpawn && mutation.getSpawn() || mutation.getBiome() > 0 && mutation.getBiome() != biomeId || (chance = mutation.chanceToMutate(allele0, allele1)) <= 0 || rand.nextInt(100) > chance) continue;
            if (rand.nextBoolean()) {
                allele1 = mutation.getMutated();
                break;
            }
            allele0 = mutation.getMutated();
            break;
        }
        damage = allele1.isDominant() && !allele0.isDominant() ? ItemBee.getEncodedDamage(allele1, allele0, allele1.getHealth()) : ItemBee.getEncodedDamage(allele0, allele1, allele0.getHealth());
        return damage;
    }

    private static EnumBeeSpecies randomizeAllele(EnumBeeSpecies allele1, EnumBeeSpecies allele2, Random rand) {
        boolean tiebreaker = rand.nextBoolean();
        if (tiebreaker) {
            return allele1;
        }
        return allele2;
    }

    @Deprecated
    public static EnumBeeSpecies getSpeciesFromDamage(int damage) {
        int dominantAllele = ItemBee.getDominantAllele(damage);
        for (EnumBeeSpecies species : EnumBeeSpecies.values()) {
            if (species.getMeta() != dominantAllele) continue;
            return species;
        }
        return EnumBeeSpecies.FOREST;
    }

    public static EnumBeeSpecies getSpecies(aan stack) {
        return ItemBee.getSpeciesFromDamage(stack.i());
    }

    @Deprecated
    public static EnumBeeSpecies getSubSpeciesFromDamage(int damage) {
        int dominantAllele = ItemBee.getRecessiveAllele(damage);
        for (EnumBeeSpecies species : EnumBeeSpecies.values()) {
            if (species.getMeta() != dominantAllele) continue;
            return species;
        }
        return EnumBeeSpecies.FOREST;
    }

    public static EnumBeeSpecies getSubSpecies(aan stack) {
        return ItemBee.getSubSpeciesFromDamage(stack.i());
    }

    public static int getEncodedDamage(EnumBeeSpecies allele1, EnumBeeSpecies allele2, int health) {
        return ItemBee.getEncodedDamage(allele1.getMeta(), allele2.getMeta(), health);
    }

    public static int getEncodedDamage(int allele1, int allele2, int health) {
        int damage = allele1 << 4;
        damage |= allele2;
        int damageHealth = health << 8;
        return damage |= damageHealth;
    }

    public static int getReducedHealth(int damage, int reduction) {
        int newHealth = ItemBee.getHealth(damage) - reduction;
        return ItemBee.getEncodedDamage(ItemBee.getDominantAllele(damage), ItemBee.getRecessiveAllele(damage), newHealth);
    }

    public static int getHealth(int damage) {
        return damage >> 8 & 0xFF;
    }

    public static int getDominantAllele(int damage) {
        return damage >> 4 & 0xF;
    }

    public static int getRecessiveAllele(int damage) {
        return damage & 0xF;
    }

    public static aan createOffspring(yr offspring, EnumBeeSpecies species, EnumBeeSpecies subspecies) {
        return new aan(offspring, 1, ItemBee.getEncodedDamage(species, subspecies, 0));
    }

    public static boolean isBee(aan stack) {
        return stack.c == ForestryItem.beeDrone.bQ || stack.c == ForestryItem.beePrincess.bQ || stack.c == ForestryItem.beeQueen.bQ;
    }

    public static aan toBeeGE(aan stack) {
        if (!ItemBee.isBee(stack)) {
            return null;
        }
        EnumBeeSpecies species = ItemBee.getSpecies(stack);
        EnumBeeSpecies subspecies = ItemBee.getSubSpecies(stack);
        Bee bee = new Bee(BeeTemplates.templateAsGenome(ItemBee.getTemplate(species), ItemBee.getTemplate(subspecies)));
        yr beeItem = stack.c == ForestryItem.beePrincess.bQ || stack.c == ForestryItem.beeQueen.bQ ? ForestryItem.beePrincessGE : ForestryItem.beeDroneGE;
        aan convert = new aan(beeItem, 1, bee.getMeta());
        ady nbttagcompound = new ady();
        bee.b(nbttagcompound);
        convert.d(nbttagcompound);
        return convert;
    }

    private static IAllele[] getTemplate(EnumBeeSpecies species) {
        switch (species) {
            case FOREST: {
                return BeeTemplates.getForestTemplate();
            }
            case MEADOWS: {
                return BeeTemplates.getMeadowsTemplate();
            }
            case COMMON: {
                return BeeTemplates.getCommonTemplate();
            }
            case CULTIVATED: {
                return BeeTemplates.getCultivatedTemplate();
            }
            case NOBLE: {
                return BeeTemplates.getNobleTemplate();
            }
            case MAJESTIC: {
                return BeeTemplates.getMajesticTemplate();
            }
            case IMPERIAL: {
                return BeeTemplates.getImperialTemplate();
            }
            case DILIGENT: {
                return BeeTemplates.getDiligentTemplate();
            }
            case UNWEARY: {
                return BeeTemplates.getUnwearyTemplate();
            }
            case INDUSTRIOUS: {
                return BeeTemplates.getIndustriousTemplate();
            }
            case SINISTER: {
                return BeeTemplates.getSinisterTemplate();
            }
            case FIENDISH: {
                return BeeTemplates.getFiendishTemplate();
            }
            case DEMONIC: {
                return BeeTemplates.getDemonicTemplate();
            }
            case STEADFAST: {
                return BeeTemplates.getSteadfastTemplate();
            }
        }
        throw new RuntimeException("Unknown old species: " + species.toString());
    }
}

