/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.apiculture.ContainerHabitatLocator;
import forestry.apiculture.ItemHabitatLocator;
import forestry.core.utils.GuiForestry;
import forestry.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.lwjgl.opengl.GL11;

public class GuiHabitatLocator
extends GuiForestry {
    private HabitatSlot[] habitatSlots = new HabitatSlot[]{new HabitatSlot(0, "Ocean"), new HabitatSlot(1, "Plains"), new HabitatSlot(2, "Desert"), new HabitatSlot(3, "Forest"), new HabitatSlot(4, "Jungle"), new HabitatSlot(5, "Taiga"), new HabitatSlot(6, "Hills"), new HabitatSlot(7, "Swampland"), new HabitatSlot(8, "Snow"), new HabitatSlot(9, "Mushroom"), new HabitatSlot(10, "Hell"), new HabitatSlot(11, "End")};
    private HashMap biomeToHabitat = new HashMap();
    private int startX;
    private int startY;
    private int lastX = 0;
    private int lastY = 0;

    public GuiHabitatLocator(aak inventory, ItemHabitatLocator.HabitatLocatorInventory item) {
        super("/gfx/gui/biomefinder.png", new ContainerHabitatLocator(inventory, item), item, 1, item.a());
        this.xSize = 176;
        this.ySize = 184;
        for (HabitatSlot slot : this.habitatSlots) {
            int y;
            int x;
            if (slot.slot > 5) {
                x = 18 + (slot.slot - 6) * 20;
                y = 50;
            } else {
                x = 18 + slot.slot * 20;
                y = 32;
            }
            slot.setPosition(x, y);
        }
        this.biomeToHabitat.put(abn.b.M, this.habitatSlots[0]);
        this.biomeToHabitat.put(abn.r.M, this.habitatSlots[0]);
        this.biomeToHabitat.put(abn.c.M, this.habitatSlots[1]);
        this.biomeToHabitat.put(abn.d.M, this.habitatSlots[2]);
        this.biomeToHabitat.put(abn.f.M, this.habitatSlots[3]);
        this.biomeToHabitat.put(abn.t.M, this.habitatSlots[3]);
        this.biomeToHabitat.put(abn.i.M, this.habitatSlots[3]);
        this.biomeToHabitat.put(abn.w.M, this.habitatSlots[4]);
        this.biomeToHabitat.put(abn.x.M, this.habitatSlots[4]);
        this.biomeToHabitat.put(abn.g.M, this.habitatSlots[5]);
        this.biomeToHabitat.put(abn.u.M, this.habitatSlots[5]);
        this.biomeToHabitat.put(abn.e.M, this.habitatSlots[6]);
        this.biomeToHabitat.put(abn.v.M, this.habitatSlots[6]);
        this.biomeToHabitat.put(abn.h.M, this.habitatSlots[7]);
        this.biomeToHabitat.put(abn.l.M, this.habitatSlots[8]);
        this.biomeToHabitat.put(abn.m.M, this.habitatSlots[8]);
        this.biomeToHabitat.put(abn.o.M, this.habitatSlots[8]);
        this.biomeToHabitat.put(abn.n.M, this.habitatSlots[8]);
        this.biomeToHabitat.put(abn.p.M, this.habitatSlots[9]);
        this.biomeToHabitat.put(abn.q.M, this.habitatSlots[9]);
        this.biomeToHabitat.put(abn.j.M, this.habitatSlots[10]);
        this.biomeToHabitat.put(abn.k.M, this.habitatSlots[11]);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float var1, int var2, int var3) {
        this.drawBackground();
        String str = StringUtil.localize("gui.habitatlocator");
        this.u.b(str, this.startX + 8 + this.getCenteredOffset(str, 138), this.startY + 16, 0xFFFFFF);
        str = "(" + StringUtil.localize("gui.closetosearch") + ")";
        this.u.b(str, this.startX + 8 + this.getCenteredOffset(str, 138), this.startY + 76, 0xABABAB);
        for (HabitatSlot slot : this.habitatSlots) {
            slot.isActive = false;
        }
        ArrayList biomeids = ((ContainerHabitatLocator)this.inventorySlots).inventory.biomesToSearch;
        Iterator i$ = biomeids.iterator();
        while (i$.hasNext()) {
            int biomeid = (Integer)i$.next();
            if (!this.biomeToHabitat.containsKey(biomeid)) continue;
            ((HabitatSlot)this.biomeToHabitat.get((Object)Integer.valueOf((int)biomeid))).isActive = true;
        }
        for (HabitatSlot slot : this.habitatSlots) {
            slot.draw(this.startX, this.startY);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    protected void drawGuiContainerForegroundLayer() {
        super.drawGuiContainerForegroundLayer();
        this.drawForegroundSelection();
    }

    protected void drawForegroundSelection() {
        HabitatSlot slot;
        String description = "";
        int cornerX = (this.q - this.xSize) / 2;
        int cornerY = (this.r - this.ySize) / 2;
        int position = this.getSlotAtLocation(this.lastX - cornerX, this.lastY - cornerY);
        if (position != -1 && (slot = this.habitatSlots[position]) != null) {
            description = slot.getTooltip();
        }
        if (description.length() > 0) {
            int i2 = this.lastX - cornerX + 12;
            int k2 = this.lastY - cornerY - 12;
            int l2 = this.u.a(description);
            this.a(i2 - 3, k2 - 3, i2 + l2 + 3, k2 + 8 + 3, -1073741824, -1073741824);
            this.u.a(description, i2, k2, -1);
        }
    }

    @Override
    protected void b(int i, int j, int k) {
        super.b(i, j, k);
        this.lastX = i;
        this.lastY = j;
    }

    public int getSlotAtLocation(int i, int j) {
        for (int position = 0; position < this.habitatSlots.length; ++position) {
            HabitatSlot slot = this.habitatSlots[position];
            if (!slot.intersectsWith(i, j)) continue;
            return position;
        }
        return -1;
    }

    @Override
    public void c() {
        super.c();
        this.startX = (this.q - this.xSize) / 2;
        this.startY = (this.r - this.ySize) / 2;
    }

    public class HabitatSlot
    extends GuiForestry.GfxSlot {
        private final int slot;
        private final String name;
        private final int iconIndex;
        public boolean isActive;

        public HabitatSlot(int slot, String name) {
            super(GuiHabitatLocator.this, 0, 0);
            this.isActive = false;
            this.slot = slot;
            this.name = name;
            this.iconIndex = slot;
        }

        @Override
        public String getTooltip() {
            return this.name;
        }

        public int getIconIndex() {
            return this.iconIndex;
        }

        public String getTexture() {
            return "/gfx/gui/habitats.png";
        }

        public void setPosition(int x, int y) {
            this.xPos = x;
            this.yPos = y;
        }

        @Override
        public void draw(int startX, int startY) {
            if (this.getTexture() != null && !this.getTexture().equals("")) {
                int texture = ((GuiHabitatLocator)GuiHabitatLocator.this).p.p.b(this.getTexture());
                ((GuiHabitatLocator)GuiHabitatLocator.this).p.p.b(texture);
                int textureI = this.getIconIndex() >> 4;
                int textureJ = this.getIconIndex() - textureI * 16;
                if (!this.isActive) {
                    GL11.glColor4f((float)0.2f, (float)0.2f, (float)0.2f, (float)0.2f);
                } else {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                GuiHabitatLocator.this.b(startX + this.xPos, startY + this.yPos, 16 * textureJ, 16 * textureI, 16, 16);
            }
        }
    }
}

