/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.forestry;

import buildcraft.api.APIProxy;
import buildcraft.api.Orientations;
import buildcraft.core.network.IndexInPayload;
import buildcraft.core.network.PacketPayload;
import buildcraft.forestry.EnumFilterType;
import buildcraft.forestry.Proxy;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.PipeLogic;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import java.util.ArrayList;

public class PipeLogicPropolis
extends PipeLogic {
    private EnumFilterType[] typeFilter = new EnumFilterType[6];
    private IAllele[][][] genomeFilter = new IAllele[6][3][2];

    public PipeLogicPropolis() {
        for (int i = 0; i < this.typeFilter.length; ++i) {
            this.typeFilter[i] = EnumFilterType.CLOSED;
        }
    }

    public void readFromNBT(ady nbttagcompound) {
        int i;
        super.readFromNBT(nbttagcompound);
        for (i = 0; i < this.typeFilter.length; ++i) {
            this.typeFilter[i] = EnumFilterType.values()[nbttagcompound.d("TypeFilter" + i)];
        }
        for (i = 0; i < 6; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (nbttagcompound.c("GenomeFilterI" + i + "-" + j + "-" + 0)) {
                    this.genomeFilter[i][j][0] = AlleleManager.alleleList[nbttagcompound.f("GenomeFilterI" + i + "-" + j + "-" + 0)];
                }
                if (!nbttagcompound.c("GenomeFilterI" + i + "-" + j + "-" + 1)) continue;
                this.genomeFilter[i][j][1] = AlleleManager.alleleList[nbttagcompound.f("GenomeFilterI" + i + "-" + j + "-" + 1)];
            }
        }
    }

    public void writeToNBT(ady nbttagcompound) {
        int i;
        super.writeToNBT(nbttagcompound);
        for (i = 0; i < this.typeFilter.length; ++i) {
            nbttagcompound.a("TypeFilter" + i, (byte)this.typeFilter[i].ordinal());
        }
        for (i = 0; i < 6; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (this.genomeFilter[i][j][0] != null) {
                    nbttagcompound.a("GenomeFilterI" + i + "-" + j + "-" + 0, this.genomeFilter[i][j][0].getId());
                }
                if (this.genomeFilter[i][j][1] == null) continue;
                nbttagcompound.a("GenomeFilterI" + i + "-" + j + "-" + 1, this.genomeFilter[i][j][1].getId());
            }
        }
    }

    public boolean blockActivated(yw entityplayer) {
        if (APIProxy.isClient(this.worldObj)) {
            return true;
        }
        if (entityplayer.av() != null && entityplayer.av().c < pb.m.length && pb.m[entityplayer.av().c] instanceof BlockGenericPipe) {
            return false;
        }
        Proxy.openPipePropolisGUI(entityplayer, this.container);
        return true;
    }

    public boolean isClosed(Orientations orientation) {
        return this.typeFilter[orientation.ordinal()] == EnumFilterType.CLOSED;
    }

    public boolean isIndiscriminate(Orientations orientation) {
        return this.typeFilter[orientation.ordinal()] == EnumFilterType.ANYTHING;
    }

    public boolean matchType(Orientations orientation, EnumFilterType type) {
        EnumFilterType filter = this.typeFilter[orientation.ordinal()];
        if (filter == EnumFilterType.BEE) {
            return type != EnumFilterType.ITEM && type != EnumFilterType.CLOSED && type != EnumFilterType.CLOSED;
        }
        return filter == type;
    }

    public boolean matchAllele(IAllele filter, int allele) {
        if (filter == null) {
            return true;
        }
        return filter.getId() == allele;
    }

    public ArrayList getGenomeFilters(Orientations orientation) {
        ArrayList<IAllele[]> filters = new ArrayList<IAllele[]>();
        for (int i = 0; i < 3; ++i) {
            if (this.genomeFilter[orientation.ordinal()][i] == null || this.genomeFilter[orientation.ordinal()][i][0] == null && this.genomeFilter[orientation.ordinal()][i][1] == null) continue;
            filters.add(this.genomeFilter[orientation.ordinal()][i]);
        }
        return filters;
    }

    public EnumFilterType getTypeFilter(Orientations orientation) {
        return this.typeFilter[orientation.ordinal()];
    }

    public void setTypeFilter(Orientations orientation, EnumFilterType type) {
        this.typeFilter[orientation.ordinal()] = type;
    }

    public IAlleleSpecies getSpeciesFilter(Orientations orientation, int pattern, int allele) {
        if (this.genomeFilter[orientation.ordinal()] == null) {
            return null;
        }
        if (this.genomeFilter[orientation.ordinal()].length <= pattern) {
            return null;
        }
        if (this.genomeFilter[orientation.ordinal()][pattern] == null) {
            return null;
        }
        if (this.genomeFilter[orientation.ordinal()][pattern].length <= allele) {
            return null;
        }
        return (IAlleleSpecies)this.genomeFilter[orientation.ordinal()][pattern][allele];
    }

    public void setSpeciesFilter(Orientations orientation, int pattern, int allele, IAllele species) {
        this.genomeFilter[orientation.ordinal()][pattern][allele] = species;
        if (Proxy.isRemote()) {
            this.sendGenomeFilterChange(orientation, pattern, allele, species);
        }
    }

    public void sendFilterSet(yw player) {
        ArrayList<Integer> payloadInt = new ArrayList<Integer>();
        for (Orientations orientation : Orientations.values()) {
            payloadInt.add(this.typeFilter[orientation.ordinal()].ordinal());
            if (this.genomeFilter[orientation.ordinal()] == null) {
                payloadInt.add(-1);
                continue;
            }
            for (int i = 0; i < this.genomeFilter[orientation.ordinal()].length; ++i) {
                IAllele[] pattern = this.genomeFilter[orientation.ordinal()][i];
                if (pattern == null) {
                    payloadInt.add(-1);
                    continue;
                }
                if (pattern[0] != null) {
                    payloadInt.add(pattern[0].getId());
                } else {
                    payloadInt.add(-1);
                }
                if (pattern[1] != null) {
                    payloadInt.add(pattern[1].getId());
                    continue;
                }
                payloadInt.add(-1);
            }
        }
        PacketPayload payload = new PacketPayload(payloadInt.size(), 0, 0);
        for (int i = 0; i < payloadInt.size(); ++i) {
            payload.intPayload[i] = (Integer)payloadInt.get(i);
        }
    }

    public void handleGenomeFilterChange(PacketPayload payload) {
        this.genomeFilter[payload.intPayload[0]][payload.intPayload[1]][payload.intPayload[2]] = AlleleManager.alleleList[payload.intPayload[3]];
    }

    public void requestFilterSet() {
    }

    public void sendGenomeFilterChange(Orientations orientation, int pattern, int allele, IAllele species) {
        PacketPayload payload = new PacketPayload(4, 0, 0);
        payload.intPayload[0] = orientation.ordinal();
        payload.intPayload[1] = pattern;
        payload.intPayload[2] = allele;
        payload.intPayload[3] = species != null ? species.getId() : -1;
    }

    public void handleFilterSet(PacketPayload payload, IndexInPayload index) {
        int orientation = 0;
        for (int i = index.intIndex; i < payload.intPayload.length; ++i) {
            this.typeFilter[orientation] = EnumFilterType.values()[payload.intPayload[i]];
            if (payload.intPayload[++i] == -1) {
                ++orientation;
                continue;
            }
            ++i;
            for (int j = 0; j < 3; ++j) {
                if (payload.intPayload[i] == -1) {
                    ++i;
                    continue;
                }
                if (payload.intPayload[++i] == -1) {
                    this.setSpeciesFilter(Orientations.values()[orientation], j, 0, null);
                } else {
                    this.setSpeciesFilter(Orientations.values()[orientation], j, 0, AlleleManager.alleleList[payload.intPayload[i]]);
                }
                if (payload.intPayload[++i] == -1) {
                    this.setSpeciesFilter(Orientations.values()[orientation], j, 0, null);
                    continue;
                }
                this.setSpeciesFilter(Orientations.values()[orientation], j, 0, AlleleManager.alleleList[payload.intPayload[i]]);
            }
            ++orientation;
        }
    }
}

