/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.forestry;

import buildcraft.api.Orientations;
import buildcraft.core.GuiAdvancedInterface;
import buildcraft.forestry.CraftingPropolisPipe;
import buildcraft.forestry.EnumFilterType;
import buildcraft.forestry.ForestryPipesCore;
import buildcraft.forestry.PipeLogicPropolis;
import buildcraft.transport.Pipe;
import forestry.api.apiculture.BeeManager;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.core.config.ForestryItem;
import org.lwjgl.opengl.GL11;

public class GuiPropolisPipe
extends GuiAdvancedInterface {
    PipeLogicPropolis pipeLogic;

    public GuiPropolisPipe(io playerInventory, Pipe pipe) {
        super((dd)new CraftingPropolisPipe(playerInventory, pipe));
        int i;
        this.pipeLogic = (PipeLogicPropolis)pipe.logic;
        this.b = 175;
        this.c = 225;
        this.slots = new GuiAdvancedInterface.AdvancedSlot[42];
        for (i = 0; i < 6; ++i) {
            this.slots[i * 7] = new TypeFilterSlot(8, 18 + i * 18, Orientations.values()[i], this.pipeLogic.getTypeFilter(Orientations.values()[i]));
        }
        for (i = 0; i < 6; ++i) {
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 2; ++k) {
                    int slot = 1 + i + i * 6 + j * 2 + k;
                    this.slots[slot] = new SpeciesFilterSlot(44 + j * 45 + k * 18, 18 + i * 18, Orientations.values()[i], j, k, this.pipeLogic.getSpeciesFilter(Orientations.values()[i], j, k));
                }
            }
        }
    }

    protected void d() {
        super.d();
        this.u.b("Apiarist's Pipe", 56, 6, 0x303030);
        this.drawForegroundSelection();
    }

    protected void a(float f, int i, int j) {
        int texture = this.p.p.b("/gfx/gui/analyzer.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.p.p.b(texture);
        int cornerX = (this.q - this.b) / 2;
        int cornerY = (this.r - this.c) / 2;
        this.b(cornerX, cornerY, 0, 0, this.b, this.c);
        this.drawBackgroundSlots();
    }

    protected void a(int i, int j, int k) {
        super.a(i, j, k);
        int cornerX = (this.q - this.b) / 2;
        int cornerY = (this.r - this.c) / 2;
        int position = this.getSlotAtLocation(i - cornerX, j - cornerY);
        GuiAdvancedInterface.AdvancedSlot slot = null;
        if (position != -1) {
            slot = this.slots[position];
        }
        if (slot instanceof TypeFilterSlot) {
            TypeFilterSlot filter = (TypeFilterSlot)slot;
            EnumFilterType change = k == 1 ? EnumFilterType.CLOSED : (filter.type.ordinal() < EnumFilterType.values().length - 1 ? EnumFilterType.values()[filter.type.ordinal() + 1] : EnumFilterType.CLOSED);
            filter.type = change;
            filter.updateDescription();
            this.pipeLogic.setTypeFilter(filter.orientation, change);
        } else if (slot instanceof SpeciesFilterSlot) {
            SpeciesFilterSlot filter = (SpeciesFilterSlot)slot;
            IAlleleSpecies change = null;
            if (k == 1) {
                change = null;
            } else if (filter.species == null) {
                change = (IAlleleSpecies)AlleleManager.alleleList[0];
            } else {
                for (int id = filter.species.getId() + 1; id <= 128; ++id) {
                    if (AlleleManager.alleleList[id] == null || !BeeManager.breedingManager.getApiaristTracker(this.pipeLogic.worldObj).isDiscovered((IAlleleSpecies)AlleleManager.alleleList[id])) continue;
                    change = (IAlleleSpecies)AlleleManager.alleleList[id];
                    break;
                }
            }
            filter.species = change;
            filter.updateDescription();
            this.pipeLogic.setSpeciesFilter(filter.orientation, filter.pattern, filter.allele, change);
        }
    }

    class SpeciesFilterSlot
    extends GuiAdvancedInterface.AdvancedSlot {
        Orientations orientation;
        IAlleleSpecies species;
        int pattern;
        int allele;
        String desc;

        public SpeciesFilterSlot(int x, int y, Orientations orientation, int pattern, int allele, IAlleleSpecies species) {
            super((GuiAdvancedInterface)GuiPropolisPipe.this, x, y);
            this.orientation = orientation;
            this.species = species;
            this.pattern = pattern;
            this.allele = allele;
            this.updateDescription();
        }

        public void updateDescription() {
            this.desc = this.species != null ? this.species.getName() : "";
        }

        public String getDescription() {
            return this.desc;
        }

        public boolean isDefined() {
            return this.species != null;
        }

        public void drawSprite(int cornerX, int cornerY) {
            if (!this.isDefined()) {
                return;
            }
            int meta = this.species.getId();
            int tex = ((GuiPropolisPipe)GuiPropolisPipe.this).p.p.b("/gfx/items/bees.png");
            GL11.glDisable((int)2896);
            ((GuiPropolisPipe)GuiPropolisPipe.this).p.p.b(tex);
            for (int i = 0; i < ForestryItem.beeDroneGE.getRenderPasses(meta); ++i) {
                int iconIndex = ForestryItem.beeDroneGE.a(meta, i);
                int color = ForestryItem.beeDroneGE.b(meta, i);
                float colorR = (float)(color >> 16 & 0xFF) / 255.0f;
                float colorG = (float)(color >> 8 & 0xFF) / 255.0f;
                float colorB = (float)(color & 0xFF) / 255.0f;
                GL11.glColor4f((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
                GuiPropolisPipe.this.b(cornerX + this.x, cornerY + this.y, iconIndex % 16 * 16, iconIndex / 16 * 16, 16, 16);
            }
            GL11.glEnable((int)2896);
        }
    }

    class TypeFilterSlot
    extends GuiAdvancedInterface.AdvancedSlot {
        Orientations orientation;
        EnumFilterType type;
        String desc;

        public TypeFilterSlot(int x, int y, Orientations orientation, EnumFilterType type) {
            super((GuiAdvancedInterface)GuiPropolisPipe.this, x, y);
            this.orientation = orientation;
            this.type = type;
            this.updateDescription();
        }

        public void updateDescription() {
            this.desc = this.type.toString().substring(0, 1).toUpperCase() + this.type.toString().substring(1).toLowerCase();
        }

        public String getDescription() {
            return this.desc;
        }

        public String getTexture() {
            if (this.type != null) {
                return ForestryPipesCore.textureBees;
            }
            return "";
        }

        public int getTextureIndex() {
            if (this.type != null) {
                return this.type.ordinal() + 9;
            }
            return 0;
        }

        public boolean isDefined() {
            return true;
        }
    }
}

