/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api;

import buildcraft.api.APIProxy;
import buildcraft.api.Action;
import buildcraft.api.BlockSignature;
import buildcraft.api.BptBlock;
import buildcraft.api.IActionProvider;
import buildcraft.api.IPipe;
import buildcraft.api.ITriggerProvider;
import buildcraft.api.ItemSignature;
import buildcraft.api.LiquidData;
import buildcraft.api.RefineryRecipe;
import buildcraft.api.Trigger;
import java.util.HashMap;
import java.util.LinkedList;

public class BuildCraftAPI {
    public static final int BUCKET_VOLUME = 1000;
    public static final int LAST_ORIGINAL_BLOCK = 122;
    public static final int LAST_ORIGINAL_ITEM = 126;
    public static boolean[] softBlocks;
    public static BptBlock[] blockBptProps;
    public static LinkedList liquids;
    public static HashMap ironEngineFuel;
    public static Trigger[] triggers;
    public static Action[] actions;
    private static yw buildCraftPlayer;
    private static LinkedList refineryRecipe;
    private static LinkedList triggerProviders;
    private static LinkedList actionProviders;

    public static int getLiquidForFilledItem(aan filledItem) {
        if (filledItem == null) {
            return 0;
        }
        for (LiquidData d : liquids) {
            if (d.filled.c != filledItem.c || d.filled.i() != filledItem.i()) continue;
            return d.liquidId;
        }
        return 0;
    }

    public static aan getFilledItemForLiquid(int liquidId) {
        for (LiquidData d : liquids) {
            if (d.liquidId != liquidId) continue;
            return d.filled.k();
        }
        return null;
    }

    public static boolean isLiquid(int blockId) {
        if (blockId == 0) {
            return false;
        }
        for (LiquidData d : liquids) {
            if (d.liquidId != blockId && d.movingLiquidId != blockId) continue;
            return true;
        }
        return false;
    }

    public static boolean softBlock(int blockId) {
        return blockId == 0 || softBlocks[blockId] || pb.m[blockId] == null;
    }

    public static boolean unbreakableBlock(int blockId) {
        return blockId == pb.z.bO || blockId == pb.D.bO || blockId == pb.C.bO;
    }

    @Deprecated
    public static void breakBlock(xd world, int x, int y, int z) {
        int blockId = world.a(x, y, z);
        if (blockId != 0) {
            pb.m[blockId].a(world, x, y, z, world.e(x, y, z), 0);
        }
        world.g(x, y, z, 0);
    }

    public static yw getBuildCraftPlayer(xd world) {
        if (buildCraftPlayer == null) {
            buildCraftPlayer = APIProxy.createNewPlayer(world);
        }
        return buildCraftPlayer;
    }

    public static void registerRefineryRecipe(RefineryRecipe recipe) {
        if (!refineryRecipe.contains(recipe)) {
            refineryRecipe.add(recipe);
        }
    }

    public static RefineryRecipe findRefineryRecipe(int liquid1, int qty1, int liquid2, int qty2) {
        int l1 = qty1 > 0 ? liquid1 : 0;
        int l2 = qty2 > 0 ? liquid2 : 0;
        for (RefineryRecipe r : refineryRecipe) {
            int src1 = 0;
            int src2 = 0;
            if (r.sourceId1 == l1) {
                src1 = l1;
                src2 = l2;
            } else if (r.sourceId1 == l2) {
                src1 = l2;
                src2 = l1;
            }
            if (src1 == 0 || (r.sourceQty2 != 0 || src2 != 0 && src2 != src1) && r.sourceId2 != src2) continue;
            return r;
        }
        return null;
    }

    public static BlockSignature getBlockSignature(pb block) {
        return blockBptProps[0].getSignature(block);
    }

    public static ItemSignature getItemSignature(yr item) {
        ItemSignature sig = new ItemSignature();
        if (item.bQ >= pb.m.length + 126) {
            sig.itemClassName = item.getClass().getSimpleName();
        }
        sig.itemName = item.a(new aan(item));
        return sig;
    }

    public static void registerTriggerProvider(ITriggerProvider provider) {
        if (provider != null && !triggerProviders.contains(provider)) {
            triggerProviders.add(provider);
        }
    }

    public static LinkedList getNeighborTriggers(pb block, kw entity) {
        LinkedList<Trigger> triggers = new LinkedList<Trigger>();
        for (ITriggerProvider provider : triggerProviders) {
            LinkedList toAdd = provider.getNeighborTriggers(block, entity);
            if (toAdd == null) continue;
            for (Trigger t : toAdd) {
                if (triggers.contains(t)) continue;
                triggers.add(t);
            }
        }
        return triggers;
    }

    public static void registerActionProvider(IActionProvider provider) {
        if (provider != null && !actionProviders.contains(provider)) {
            actionProviders.add(provider);
        }
    }

    public static LinkedList getNeighborActions(pb block, kw entity) {
        LinkedList<Action> actions = new LinkedList<Action>();
        for (IActionProvider provider : actionProviders) {
            LinkedList toAdd = provider.getNeighborActions(block, entity);
            if (toAdd == null) continue;
            for (Action t : toAdd) {
                if (actions.contains(t)) continue;
                actions.add(t);
            }
        }
        return actions;
    }

    public static LinkedList getPipeTriggers(IPipe pipe) {
        LinkedList<Trigger> triggers = new LinkedList<Trigger>();
        for (ITriggerProvider provider : triggerProviders) {
            LinkedList toAdd = provider.getPipeTriggers(pipe);
            if (toAdd == null) continue;
            for (Trigger t : toAdd) {
                if (triggers.contains(t)) continue;
                triggers.add(t);
            }
        }
        return triggers;
    }

    static {
        int i;
        softBlocks = new boolean[pb.m.length];
        blockBptProps = new BptBlock[pb.m.length];
        liquids = new LinkedList();
        ironEngineFuel = new HashMap();
        triggers = new Trigger[1024];
        actions = new Action[1024];
        refineryRecipe = new LinkedList();
        triggerProviders = new LinkedList();
        actionProviders = new LinkedList();
        for (i = 0; i < softBlocks.length; ++i) {
            BuildCraftAPI.softBlocks[i] = false;
        }
        for (i = 0; i < blockBptProps.length; ++i) {
            new BptBlock(i);
        }
    }
}

