/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import forge.Configuration;
import forge.Property;
import ic2.api.Ic2Recipes;
import ic2.common.Ic2Items;
import ic2.common.TileEntityElectricMachine;
import java.util.List;
import java.util.Vector;

public class TileEntityRecycler
extends TileEntityElectricMachine {
    public static List blacklist = new Vector();

    public TileEntityRecycler() {
        super(3, 1, 45, 32);
    }

    public static void init(Configuration config) {
        TileEntityRecycler.addBlacklistItem(pb.bq);
        TileEntityRecycler.addBlacklistItem(yr.D);
        TileEntityRecycler.addBlacklistItem(yr.aD);
        TileEntityRecycler.addBlacklistItem(Ic2Items.scaffold);
        Property prop = config.getOrCreateProperty("recyclerBlacklist", "general", TileEntityRecycler.getRecyclerBlacklistString());
        prop.comment = "List of blocks and items which should not be turned into scrap by the recycler. Comma separated, format is id-metadata";
        TileEntityRecycler.setRecyclerBlacklistFromString(prop.value);
    }

    @Override
    public void operate() {
        if (!this.canOperate()) {
            return;
        }
        boolean itemBlacklisted = TileEntityRecycler.getIsItemBlacklisted(this.inventory[0]);
        --this.inventory[0].a;
        if (this.inventory[0].a <= 0) {
            this.inventory[0] = null;
        }
        if (this.i.r.nextInt(TileEntityRecycler.recycleChance()) == 0 && !itemBlacklisted) {
            if (this.inventory[2] == null) {
                this.inventory[2] = Ic2Items.scrap.k();
            } else {
                ++this.inventory[2].a;
            }
        }
    }

    @Override
    public boolean canOperate() {
        if (this.inventory[0] == null) {
            return false;
        }
        return this.inventory[2] == null || this.inventory[2].a(Ic2Items.scrap) && this.inventory[2].a < Ic2Items.scrap.c();
    }

    @Override
    public aan getResultFor(aan itemstack, boolean adjustInput) {
        return null;
    }

    @Override
    public String c() {
        return "Recycler";
    }

    @Override
    public String getGuiClassName(yw entityPlayer) {
        return "GuiRecycler";
    }

    public static int recycleChance() {
        return 8;
    }

    @Override
    public String getStartSoundFile() {
        return "Machines/RecyclerOp.ogg";
    }

    @Override
    public String getInterruptSoundFile() {
        return "Machines/InterruptOne.ogg";
    }

    @Override
    public float getWrenchDropRate() {
        return 0.85f;
    }

    public static void addBlacklistItem(yr item) {
        TileEntityRecycler.addBlacklistItem(new aan(item));
    }

    public static void addBlacklistItem(pb block) {
        TileEntityRecycler.addBlacklistItem(new aan(block));
    }

    public static void addBlacklistItem(aan item) {
        blacklist.add(item);
    }

    public static boolean getIsItemBlacklisted(aan itemStack) {
        for (aan blackItem : blacklist) {
            if (!itemStack.a(blackItem) && (blackItem.i() != -1 || blackItem.c != itemStack.c)) continue;
            return true;
        }
        return false;
    }

    private static String getRecyclerBlacklistString() {
        StringBuilder ret = new StringBuilder();
        boolean first = true;
        for (aan entry : Ic2Recipes.getRecyclerBlacklist()) {
            if (entry == null) continue;
            if (first) {
                first = false;
            } else {
                ret.append(", ");
            }
            ret.append(entry.c);
            if (entry.i() == 0) continue;
            ret.append("-");
            ret.append(entry.i());
        }
        return ret.toString();
    }

    private static void setRecyclerBlacklistFromString(String str) {
        String[] strParts;
        for (String strPart : strParts = str.trim().split("\\s*,\\s*")) {
            String[] idMeta = strPart.split("\\s*-\\s*");
            if (idMeta[0].length() == 0) continue;
            int blockId = Integer.parseInt(idMeta[0]);
            int metaData = -1;
            if (idMeta.length == 2) {
                metaData = Integer.parseInt(idMeta[1]);
            }
            aan is = new aan(blockId, 1, metaData);
            Ic2Recipes.addRecyclerBlacklistItem(is);
        }
    }
}

