/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import forge.ISidedInventory;
import ic2.api.Direction;
import ic2.api.IElectricItem;
import ic2.api.IEnergySink;
import ic2.api.IEnergySource;
import ic2.api.INetworkClientTileEntityEventListener;
import ic2.common.ContainerElectricBlock;
import ic2.common.ContainerIC2;
import ic2.common.ElectricItem;
import ic2.common.EnergyNet;
import ic2.common.IHasGui;
import ic2.common.Ic2Items;
import ic2.common.TileEntityMachine;
import ic2.platform.Platform;

public abstract class TileEntityElectricBlock
extends TileEntityMachine
implements IEnergySink,
IEnergySource,
IHasGui,
ISidedInventory,
INetworkClientTileEntityEventListener {
    public adn translate;
    public int tier;
    public int output;
    public int maxStorage;
    public int energy = 0;
    public byte redstoneMode = 0;
    public static byte redstoneModes = (byte)6;
    public boolean addedToEnergyNet = false;

    public TileEntityElectricBlock(int tierc, int outputc, int maxStoragec) {
        super(2);
        this.tier = tierc;
        this.output = outputc;
        this.maxStorage = maxStoragec;
        this.translate = adn.a();
    }

    public String getNameByTier() {
        switch (this.tier) {
            case 1: {
                return this.translate.b("blockBatBox.name");
            }
            case 2: {
                return this.translate.b("blockMFE.name");
            }
            case 3: {
                return this.translate.b("blockMFSU.name");
            }
        }
        return null;
    }

    public float getChargeLevel() {
        float ret = (float)this.energy / (float)this.maxStorage;
        if (ret > 1.0f) {
            ret = 1.0f;
        }
        return ret;
    }

    @Override
    public void a(ady nbttagcompound) {
        super.a(nbttagcompound);
        this.setActiveWithoutNotify(nbttagcompound.o("active"));
        this.energy = nbttagcompound.f("energy");
        if (this.maxStorage > Integer.MAX_VALUE) {
            this.energy *= 10;
        }
        this.redstoneMode = nbttagcompound.d("redstoneMode");
    }

    @Override
    public void b(ady nbttagcompound) {
        super.b(nbttagcompound);
        int write = this.energy;
        if (this.maxStorage > Integer.MAX_VALUE) {
            write /= 10;
        }
        nbttagcompound.a("energy", write);
        nbttagcompound.a("active", this.getActive());
        nbttagcompound.a("redstoneMode", this.redstoneMode);
    }

    public void h() {
        if (Platform.isSimulating() && this.addedToEnergyNet) {
            EnergyNet.getForWorld(this.i).removeTileEntity(this);
            this.addedToEnergyNet = false;
        }
        super.h();
    }

    @Override
    public void n_() {
        super.n_();
        boolean needsInvUpdate = false;
        if (this.energy > 0 && this.inventory[0] != null && yr.e[this.inventory[0].c] instanceof IElectricItem) {
            int sent = ElectricItem.charge(this.inventory[0], this.energy, this.tier, false, false);
            this.energy -= sent;
            boolean bl = needsInvUpdate = sent > 0;
        }
        if (this.demandsEnergy() && this.inventory[1] != null) {
            if (yr.e[this.inventory[1].c] instanceof IElectricItem) {
                IElectricItem item = (IElectricItem)yr.e[this.inventory[1].c];
                if (item.canProvideEnergy()) {
                    int gain = ElectricItem.discharge(this.inventory[1], this.maxStorage - this.energy, this.tier, false, false);
                    this.energy += gain;
                    needsInvUpdate = gain > 0;
                }
            } else {
                int id = this.inventory[1].c;
                int gain = 0;
                if (id == yr.aC.bQ) {
                    gain = 500;
                }
                if (id == Ic2Items.suBattery.c) {
                    gain = 1000;
                }
                if (gain > 0 && gain <= this.maxStorage - this.energy) {
                    --this.inventory[1].a;
                    if (this.inventory[1].a <= 0) {
                        this.inventory[1] = null;
                    }
                    this.energy += gain;
                }
            }
        }
        boolean isFull = false;
        if (this.energy >= this.maxStorage) {
            isFull = true;
        }
        this.setActive(isFull);
        this.i.j(this.j, this.k, this.l, this.i.a(this.j, this.k, this.l));
        if (!(this.energy < this.output || this.redstoneMode == 4 && this.i.w(this.j, this.k, this.l) || this.redstoneMode == 5 && this.i.w(this.j, this.k, this.l) && this.energy < this.maxStorage)) {
            this.energy -= this.output - EnergyNet.getForWorld(this.i).emitEnergyFrom(this, this.output);
        }
        if (needsInvUpdate) {
            this.j();
        }
    }

    @Override
    public void onCreated() {
        super.onCreated();
        if (Platform.isSimulating()) {
            EnergyNet.getForWorld(this.i).addTileEntity(this);
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this.addedToEnergyNet;
    }

    @Override
    public boolean acceptsEnergyFrom(kw emitter, Direction direction) {
        return !this.facingMatchesDirection(direction);
    }

    @Override
    public boolean emitsEnergyTo(kw receiver, Direction direction) {
        return this.facingMatchesDirection(direction);
    }

    public boolean facingMatchesDirection(Direction direction) {
        return direction.toSideValue() == this.getFacing();
    }

    @Override
    public int getMaxEnergyOutput() {
        return this.output;
    }

    @Override
    public boolean demandsEnergy() {
        return this.energy < this.maxStorage;
    }

    @Override
    public int injectEnergy(Direction directionFrom, int amount) {
        if (amount > this.output) {
            mod_IC2.explodeMachineAt(this.i, this.j, this.k, this.l);
            return 0;
        }
        int need = amount;
        if (this.energy + amount >= this.maxStorage + this.output) {
            need = this.maxStorage + this.output - this.energy - 1;
        }
        this.energy += need;
        return amount - need;
    }

    @Override
    public ContainerIC2 getGuiContainer(yw entityPlayer) {
        return new ContainerElectricBlock(entityPlayer, this);
    }

    @Override
    public String getGuiClassName(yw entityPlayer) {
        return "GuiElectricBlock";
    }

    @Override
    public void onGuiClosed(yw entityPlayer) {
    }

    @Override
    public boolean wrenchCanSetFacing(yw entityPlayer, int side) {
        return this.getFacing() != side;
    }

    @Override
    public void setFacing(short facing) {
        if (this.addedToEnergyNet) {
            EnergyNet.getForWorld(this.i).removeTileEntity(this);
        }
        this.addedToEnergyNet = false;
        super.setFacing(facing);
        EnergyNet.getForWorld(this.i).addTileEntity(this);
        this.addedToEnergyNet = true;
    }

    public boolean isEmittingRedstone() {
        switch (this.redstoneMode) {
            case 1: {
                return this.energy >= this.maxStorage;
            }
            case 2: {
                return this.energy > this.output && this.energy < this.maxStorage;
            }
            case 3: {
                return this.energy < this.output;
            }
        }
        return false;
    }

    public int getStartInventorySide(int side) {
        switch (side) {
            case 0: {
                return 1;
            }
        }
        return 0;
    }

    public int getSizeInventorySide(int side) {
        return 1;
    }

    @Override
    public void onNetworkEvent(yw player, int event) {
        this.redstoneMode = (byte)(this.redstoneMode + 1);
        if (this.redstoneMode >= redstoneModes) {
            this.redstoneMode = 0;
        }
        switch (this.redstoneMode) {
            case 0: {
                Platform.messagePlayer(player, "Redstone Behavior: Nothing");
                break;
            }
            case 1: {
                Platform.messagePlayer(player, "Redstone Behavior: Emit if full");
                break;
            }
            case 2: {
                Platform.messagePlayer(player, "Redstone Behavior: Emit if partially filled");
                break;
            }
            case 3: {
                Platform.messagePlayer(player, "Redstone Behavior: Emit if empty");
                break;
            }
            case 4: {
                Platform.messagePlayer(player, "Redstone Behavior: Do not output energy");
                break;
            }
            case 5: {
                Platform.messagePlayer(player, "Redstone Behavior: Do not output energy unless full");
            }
        }
    }
}

