/*
 * Decompiled with CFR 0.152.
 */
package ee.network;

import ee.network.EEPacket;
import ee.network.PacketTypeHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class TileEntityPacket
extends EEPacket {
    public int x;
    public int y;
    public int z;
    public byte direction;
    String player;

    public TileEntityPacket() {
        super(PacketTypeHandler.TILE, true);
    }

    @Override
    public void setCoords(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public void setOrientation(byte direction) {
        this.direction = direction;
    }

    @Override
    public void setPlayerName(String player) {
        this.player = player;
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        data.writeInt(this.x);
        data.writeInt(this.y);
        data.writeInt(this.z);
        data.writeByte(this.direction);
        data.writeUTF(this.player);
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        this.x = data.readInt();
        this.y = data.readInt();
        this.z = data.readInt();
        this.direction = data.readByte();
        this.player = data.readUTF();
    }

    @Override
    public void execute(lg network) {
        EEProxy.handleTEPacket(this.x, this.y, this.z, this.direction, this.player);
    }
}

