/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.utils;

import buildcraft.api.core.Orientations;
import buildcraft.transport.utils.ConnectionMatrix;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class FacadeMatrix
extends ConnectionMatrix {
    private String[] _textureFiles = new String[Orientations.dirs().length];
    private int[] _textureIndex = new int[Orientations.dirs().length];
    private boolean dirty = false;

    public FacadeMatrix() {
        for (Orientations direction : Orientations.dirs()) {
            this._textureFiles[direction.ordinal()] = "";
        }
    }

    public String getTextureFile(Orientations direction) {
        return this._textureFiles[direction.ordinal()];
    }

    public void setTextureFile(Orientations direction, String filePath) {
        if (!this._textureFiles[direction.ordinal()].equals(filePath)) {
            this._textureFiles[direction.ordinal()] = filePath;
            this.dirty = true;
        }
    }

    public int getTextureIndex(Orientations direction) {
        return this._textureIndex[direction.ordinal()];
    }

    public void setTextureIndex(Orientations direction, int value) {
        if (this._textureIndex[direction.ordinal()] != value) {
            this._textureIndex[direction.ordinal()] = value;
            this.dirty = true;
        }
    }

    @Override
    public boolean isDirty() {
        return this.dirty || super.isDirty();
    }

    @Override
    public void clean() {
        super.clean();
        this.dirty = false;
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        super.readData(data);
        for (int i = 0; i < Orientations.dirs().length; ++i) {
            this._textureFiles[i] = data.readUTF();
            this._textureIndex[i] = data.readInt();
        }
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        super.writeData(data);
        for (int i = 0; i < Orientations.dirs().length; ++i) {
            data.writeUTF(this._textureFiles[i]);
            data.writeInt(this._textureIndex[i]);
        }
    }
}

