/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.api.core.Orientations;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import buildcraft.core.DefaultProps;
import buildcraft.core.Utils;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeLogicWood;
import buildcraft.transport.PipeTransportPower;
import buildcraft.transport.TileGenericPipe;

public class PipePowerWood
extends Pipe
implements IPowerReceptor {
    private IPowerProvider powerProvider = PowerFramework.currentFramework.createPowerProvider();
    private int baseTexture = 118;
    private int plainTexture = 31;

    public PipePowerWood(int itemID) {
        super(new PipeTransportPower(), new PipeLogicWood(), itemID);
        this.powerProvider.configure(50, 1, 1000, 1, 1000);
        this.powerProvider.configurePowerPerdition(1, 100);
    }

    @Override
    public String getTextureFile() {
        return DefaultProps.TEXTURE_BLOCKS;
    }

    @Override
    public int getTextureIndex(Orientations direction) {
        if (direction == Orientations.Unknown) {
            return this.baseTexture;
        }
        int metadata = this.worldObj.c(this.xCoord, this.yCoord, this.zCoord);
        if (metadata == direction.ordinal()) {
            return this.plainTexture;
        }
        return this.baseTexture;
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        provider = this.powerProvider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    @Override
    public void doWork() {
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        for (Orientations o : Orientations.dirs()) {
            qj tile;
            if (!Utils.checkPipesConnections(this.container, this.container.getTile(o)) || !((tile = this.container.getTile(o)) instanceof TileGenericPipe)) continue;
            if (((TileGenericPipe)tile).pipe == null) {
                System.out.println("PipePowerWood.pipe was null, this used to cause a NPE crash)");
                continue;
            }
            PipeTransportPower pow = (PipeTransportPower)((TileGenericPipe)tile).pipe.transport;
            float energyToRemove = 0.0f;
            energyToRemove = this.powerProvider.getEnergyStored() > 40.0f ? this.powerProvider.getEnergyStored() / 40.0f + 4.0f : (this.powerProvider.getEnergyStored() > 10.0f ? this.powerProvider.getEnergyStored() / 10.0f : 1.0f);
            float energyUsed = this.powerProvider.useEnergy(1.0f, energyToRemove, true);
            pow.receiveEnergy(o.reverse(), energyUsed);
            if (this.worldObj.F) {
                return;
            }
            int n = o.ordinal();
            ((PipeTransportPower)this.transport).displayPower[n] = (short)((float)((PipeTransportPower)this.transport).displayPower[n] + energyUsed);
        }
    }

    @Override
    public int powerRequest() {
        return this.getPowerProvider().getMaxEnergyReceived();
    }
}

