/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.api.core.Orientations;
import buildcraft.api.core.Position;
import buildcraft.api.liquids.ITankContainer;
import buildcraft.api.liquids.LiquidStack;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import buildcraft.api.transport.PipeManager;
import buildcraft.core.DefaultProps;
import buildcraft.core.network.TileNetworkData;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeLogicWood;
import buildcraft.transport.PipeTransportLiquids;

public class PipeLiquidsWood
extends Pipe
implements IPowerReceptor {
    @TileNetworkData
    public int liquidToExtract;
    private IPowerProvider powerProvider = PowerFramework.currentFramework.createPowerProvider();
    private int baseTexture = 112;
    private int plainTexture = 31;
    long lastMining = 0L;
    boolean lastPower = false;

    public PipeLiquidsWood(int itemID) {
        super(new PipeTransportLiquids(), new PipeLogicWood(), itemID);
        this.powerProvider.configure(50, 1, 1, 1, 1);
        this.powerProvider.configurePowerPerdition(1, 1);
    }

    @Override
    public void doWork() {
        if (this.powerProvider.getEnergyStored() <= 0.0f) {
            return;
        }
        ge w = this.worldObj;
        int meta = this.worldObj.c(this.xCoord, this.yCoord, this.zCoord);
        if (meta > 5) {
            return;
        }
        Position pos = new Position(this.xCoord, this.yCoord, this.zCoord, Orientations.values()[meta]);
        pos.moveForwards(1.0);
        qj tile = w.b((int)pos.x, (int)pos.y, (int)pos.z);
        if (tile instanceof ITankContainer) {
            if (!PipeManager.canExtractLiquids(this, w, (int)pos.x, (int)pos.y, (int)pos.z)) {
                return;
            }
            if (this.liquidToExtract <= 1000) {
                this.liquidToExtract = (int)((float)this.liquidToExtract + this.powerProvider.useEnergy(1.0f, 1.0f, true) * 1000.0f);
            }
        }
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        this.powerProvider = provider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        int meta = this.worldObj.c(this.xCoord, this.yCoord, this.zCoord);
        if (this.liquidToExtract > 0 && meta < 6) {
            Position pos = new Position(this.xCoord, this.yCoord, this.zCoord, Orientations.values()[meta]);
            pos.moveForwards(1.0);
            qj tile = this.worldObj.b((int)pos.x, (int)pos.y, (int)pos.z);
            if (tile instanceof ITankContainer) {
                ITankContainer container = (ITankContainer)tile;
                int flowRate = ((PipeTransportLiquids)this.transport).flowRate;
                LiquidStack extracted = container.drain(pos.orientation.reverse(), this.liquidToExtract > flowRate ? flowRate : this.liquidToExtract, false);
                int inserted = 0;
                if (extracted != null) {
                    inserted = ((PipeTransportLiquids)this.transport).fill(pos.orientation, extracted, true);
                    container.drain(pos.orientation.reverse(), inserted, true);
                }
                this.liquidToExtract -= inserted;
            }
        }
    }

    @Override
    public String getTextureFile() {
        return DefaultProps.TEXTURE_BLOCKS;
    }

    @Override
    public int getTextureIndex(Orientations direction) {
        if (direction == Orientations.Unknown) {
            return this.baseTexture;
        }
        int metadata = this.worldObj.c(this.xCoord, this.yCoord, this.zCoord);
        if (metadata == direction.ordinal()) {
            return this.plainTexture;
        }
        return this.baseTexture;
    }

    @Override
    public int powerRequest() {
        return this.getPowerProvider().getMaxEnergyReceived();
    }
}

