/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.api.core.Orientations;
import buildcraft.api.core.Position;
import buildcraft.api.inventory.ISpecialInventory;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import buildcraft.api.transport.PipeManager;
import buildcraft.core.DefaultProps;
import buildcraft.core.EntityPassiveItem;
import buildcraft.core.Utils;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeLogicWood;
import buildcraft.transport.PipeTransportItems;
import forge.ISidedInventory;

public class PipeItemsWood
extends Pipe
implements IPowerReceptor {
    private IPowerProvider powerProvider = PowerFramework.currentFramework.createPowerProvider();
    private int baseTexture = 16;
    private int plainTexture = 31;

    protected PipeItemsWood(int itemID, PipeTransportItems transport) {
        super(transport, new PipeLogicWood(), itemID);
        this.powerProvider.configure(50, 1, 64, 1, 64);
        this.powerProvider.configurePowerPerdition(64, 1);
    }

    public PipeItemsWood(int itemID) {
        this(itemID, new PipeTransportItems());
    }

    @Override
    public String getTextureFile() {
        return DefaultProps.TEXTURE_BLOCKS;
    }

    @Override
    public int getTextureIndex(Orientations direction) {
        if (direction == Orientations.Unknown) {
            return this.baseTexture;
        }
        int metadata = this.worldObj.c(this.xCoord, this.yCoord, this.zCoord);
        if (metadata == direction.ordinal()) {
            return this.plainTexture;
        }
        return this.baseTexture;
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        provider = this.powerProvider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    @Override
    public void doWork() {
        if (this.powerProvider.getEnergyStored() <= 0.0f) {
            return;
        }
        ge w = this.worldObj;
        int meta = this.worldObj.c(this.xCoord, this.yCoord, this.zCoord);
        if (meta > 5) {
            return;
        }
        Position pos = new Position(this.xCoord, this.yCoord, this.zCoord, Orientations.values()[meta]);
        pos.moveForwards(1.0);
        qj tile = w.b((int)pos.x, (int)pos.y, (int)pos.z);
        if (tile instanceof ni) {
            if (!PipeManager.canExtractItems(this, w, (int)pos.x, (int)pos.y, (int)pos.z)) {
                return;
            }
            ni inventory = (ni)tile;
            kp[] extracted = this.checkExtract(inventory, true, pos.orientation.reverse());
            if (extracted == null) {
                return;
            }
            for (kp stack : extracted) {
                if (stack == null || stack.a == 0) {
                    this.powerProvider.useEnergy(1.0f, 1.0f, false);
                    continue;
                }
                Position entityPos = new Position(pos.x + 0.5, pos.y + (double)Utils.getPipeFloorOf(stack), pos.z + 0.5, pos.orientation.reverse());
                entityPos.moveForwards(0.5);
                EntityPassiveItem entity = new EntityPassiveItem(w, entityPos.x, entityPos.y, entityPos.z, stack);
                ((PipeTransportItems)this.transport).entityEntering(entity, entityPos.orientation);
            }
        }
    }

    public kp[] checkExtract(ni inventory, boolean doRemove, Orientations from) {
        if (inventory instanceof ISpecialInventory) {
            return ((ISpecialInventory)inventory).extractItem(doRemove, from, 1);
        }
        if (inventory instanceof ISidedInventory) {
            ISidedInventory sidedInv = (ISidedInventory)inventory;
            int first = sidedInv.getStartInventorySide(from.ordinal());
            int last = first + sidedInv.getSizeInventorySide(from.ordinal()) - 1;
            ni inv = Utils.getInventory(inventory);
            kp result = this.checkExtractGeneric(inv, doRemove, from, first, last);
            if (result != null) {
                return new kp[]{result};
            }
        } else if (inventory.c() == 2) {
            int slotIndex = 0;
            slotIndex = from == Orientations.YNeg || from == Orientations.YPos ? 0 : 1;
            kp slot = inventory.g_(slotIndex);
            if (slot != null && slot.a > 0) {
                if (doRemove) {
                    return new kp[]{inventory.a(slotIndex, (int)this.powerProvider.useEnergy(1.0f, slot.a, true))};
                }
                return new kp[]{slot};
            }
        } else if (inventory.c() == 3) {
            int slotIndex = 0;
            slotIndex = from == Orientations.YPos ? 0 : (from == Orientations.YNeg ? 1 : 2);
            kp slot = inventory.g_(slotIndex);
            if (slot != null && slot.a > 0) {
                if (doRemove) {
                    return new kp[]{inventory.a(slotIndex, (int)this.powerProvider.useEnergy(1.0f, slot.a, true))};
                }
                return new kp[]{slot};
            }
        } else {
            ni inv = Utils.getInventory(inventory);
            kp result = this.checkExtractGeneric(inv, doRemove, from, 0, inv.c() - 1);
            if (result != null) {
                return new kp[]{result};
            }
        }
        return null;
    }

    public kp checkExtractGeneric(ni inventory, boolean doRemove, Orientations from, int start, int stop) {
        for (int k2 = start; k2 <= stop; ++k2) {
            kp slot;
            if (inventory.g_(k2) == null || inventory.g_((int)k2).a <= 0 || (slot = inventory.g_(k2)) == null || slot.a <= 0) continue;
            if (doRemove) {
                return inventory.a(k2, (int)this.powerProvider.useEnergy(1.0f, slot.a, true));
            }
            return slot;
        }
        return null;
    }

    @Override
    public int powerRequest() {
        return this.getPowerProvider().getMaxEnergyReceived();
    }
}

