/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftBlockUtil;
import buildcraft.BuildCraftTransport;
import buildcraft.api.core.Orientations;
import buildcraft.api.core.Position;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import buildcraft.core.CoreProxy;
import buildcraft.core.DefaultProps;
import buildcraft.core.EntityPassiveItem;
import buildcraft.core.Utils;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.EntityData;
import buildcraft.transport.IItemTravelingHook;
import buildcraft.transport.ItemPipe;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeLogicStripes;
import buildcraft.transport.PipeTransportItems;
import java.util.ArrayList;
import java.util.TreeMap;

public class PipeItemsStripes
extends Pipe
implements IItemTravelingHook,
IPowerReceptor {
    private IPowerProvider powerProvider;

    public PipeItemsStripes(int itemID) {
        super(new PipeTransportItems(), new PipeLogicStripes(), itemID);
        ((PipeTransportItems)this.transport).travelHook = this;
        this.powerProvider = PowerFramework.currentFramework.createPowerProvider();
        this.powerProvider.configure(25, 1, 1, 1, 1);
        this.powerProvider.configurePowerPerdition(1, 1);
    }

    @Override
    public String getTextureFile() {
        return DefaultProps.TEXTURE_BLOCKS;
    }

    @Override
    public int getTextureIndex(Orientations direction) {
        return 126;
    }

    @Override
    public void doWork() {
        Orientations o;
        if (this.powerProvider.useEnergy(1.0f, 1.0f, true) == 1.0f && (o = this.getOpenOrientation()) != Orientations.Unknown) {
            Position p = new Position(this.xCoord, this.yCoord, this.zCoord, o);
            p.moveForwards(1.0);
            ArrayList stacks = BuildCraftBlockUtil.getItemStackFromBlock(this.worldObj, (int)p.x, (int)p.y, (int)p.z);
            if (stacks != null) {
                for (kp s : stacks) {
                    if (s == null) continue;
                    EntityPassiveItem newItem = new EntityPassiveItem(this.worldObj, (double)this.xCoord + 0.5, (float)this.yCoord + Utils.getPipeFloorOf(s), (double)this.zCoord + 0.5, s);
                    this.container.entityEntering(newItem, o.reverse());
                }
            }
            this.worldObj.b((int)p.x, (int)p.y, (int)p.z, 0);
        }
    }

    @Override
    public void drop(PipeTransportItems pipe, EntityData data) {
        Position p = new Position(this.xCoord, this.yCoord, this.zCoord, data.orientation);
        p.moveForwards(1.0);
        if (this.convertPipe(pipe, data)) {
            BuildCraftTransport.pipeItemsStipes.a(new kp(BuildCraftTransport.pipeItemsStipes), CoreProxy.getBuildCraftPlayer(this.worldObj), this.worldObj, (int)p.x, (int)p.y - 1, (int)p.z, 1);
        } else if (this.worldObj.a((int)p.x, (int)p.y, (int)p.z) == 0) {
            data.item.getItemStack().a().a(data.item.getItemStack(), CoreProxy.getBuildCraftPlayer(this.worldObj), this.worldObj, (int)p.x, (int)p.y - 1, (int)p.z, 1);
        } else {
            data.item.getItemStack().a().a(data.item.getItemStack(), CoreProxy.getBuildCraftPlayer(this.worldObj), this.worldObj, (int)p.x, (int)p.y, (int)p.z, 1);
        }
    }

    @Override
    public void centerReached(PipeTransportItems pipe, EntityData data) {
        this.convertPipe(pipe, data);
    }

    public boolean convertPipe(PipeTransportItems pipe, EntityData data) {
        if (data.item.getItemStack().a() instanceof ItemPipe && data.item.getItemStack().c != BuildCraftTransport.pipeItemsStipes.bP) {
            Pipe newPipe = BlockGenericPipe.createPipe(data.item.getItemStack().c);
            newPipe.setTile(this.container);
            this.container.pipe = newPipe;
            ((PipeTransportItems)newPipe.transport).travelingEntities = (TreeMap)pipe.travelingEntities.clone();
            --data.item.getItemStack().a;
            if (data.item.getItemStack().a <= 0) {
                ((PipeTransportItems)newPipe.transport).travelingEntities.remove(data.item.getEntityId());
            }
            pipe.scheduleRemoval(data.item);
            return true;
        }
        return false;
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        this.powerProvider = provider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    @Override
    public int powerRequest() {
        return this.getPowerProvider().getMaxEnergyReceived();
    }

    @Override
    public void endReached(PipeTransportItems pipe, EntityData data, qj tile) {
    }
}

