/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.Orientations;
import buildcraft.api.core.Position;
import buildcraft.api.transport.IPipedItem;
import buildcraft.core.DefaultProps;
import buildcraft.core.Utils;
import buildcraft.transport.IPipeTransportItemsHook;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeLogicGold;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TileGenericPipe;
import java.util.LinkedList;

public class PipeItemsGold
extends Pipe
implements IPipeTransportItemsHook {
    public PipeItemsGold(int itemID) {
        super(new PipeTransportItems(), new PipeLogicGold(), itemID);
    }

    @Override
    public String getTextureFile() {
        return DefaultProps.TEXTURE_BLOCKS;
    }

    @Override
    public int getTextureIndex(Orientations direction) {
        if (this.worldObj != null && this.worldObj.x(this.xCoord, this.yCoord, this.zCoord)) {
            return 30;
        }
        return 20;
    }

    @Override
    public boolean isPipeConnected(qj tile) {
        if (!super.isPipeConnected(tile)) {
            return false;
        }
        Pipe pipe2 = null;
        if (tile instanceof TileGenericPipe) {
            pipe2 = ((TileGenericPipe)tile).pipe;
        }
        if (BuildCraftTransport.alwaysConnectPipes) {
            return super.isPipeConnected(tile);
        }
        return (pipe2 == null || !(pipe2.logic instanceof PipeLogicGold)) && super.isPipeConnected(tile);
    }

    @Override
    public LinkedList filterPossibleMovements(LinkedList possibleOrientations, Position pos, IPipedItem item) {
        return possibleOrientations;
    }

    @Override
    public void entityEntered(IPipedItem item, Orientations orientation) {
        if (this.worldObj.x(this.xCoord, this.yCoord, this.zCoord)) {
            item.setSpeed(Utils.pipeNormalSpeed * 20.0f);
        }
    }

    @Override
    public void readjustSpeed(IPipedItem item) {
        ((PipeTransportItems)this.transport).defaultReajustSpeed(item);
    }
}

