/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.Orientations;
import buildcraft.api.core.Position;
import buildcraft.api.transport.IPipedItem;
import buildcraft.core.DefaultProps;
import buildcraft.transport.IPipeTransportItemsHook;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeLogicDiamond;
import buildcraft.transport.PipeTransportItems;
import java.util.LinkedList;

public class PipeItemsDiamond
extends Pipe
implements IPipeTransportItemsHook {
    public PipeItemsDiamond(int itemID) {
        super(new PipeTransportItems(), new PipeLogicDiamond(), itemID);
    }

    @Override
    public String getTextureFile() {
        return DefaultProps.TEXTURE_BLOCKS;
    }

    @Override
    public int getTextureIndex(Orientations direction) {
        if (direction == Orientations.Unknown) {
            return 21;
        }
        return BuildCraftTransport.diamondTextures[direction.ordinal()];
    }

    @Override
    public LinkedList filterPossibleMovements(LinkedList possibleOrientations, Position pos, IPipedItem item) {
        LinkedList<Orientations> filteredOrientations = new LinkedList<Orientations>();
        LinkedList<Orientations> defaultOrientations = new LinkedList<Orientations>();
        for (Orientations dir : possibleOrientations) {
            boolean foundFilter = false;
            PipeLogicDiamond diamondLogic = (PipeLogicDiamond)this.logic;
            for (int slot = 0; slot < 9; ++slot) {
                kp stack = diamondLogic.g_(dir.ordinal() * 9 + slot);
                if (stack != null) {
                    foundFilter = true;
                }
                if (stack == null || stack.c != item.getItemStack().c) continue;
                if (id.d[item.getItemStack().c].g()) {
                    filteredOrientations.add(dir);
                    continue;
                }
                if (stack.h() != item.getItemStack().h()) continue;
                filteredOrientations.add(dir);
            }
            if (foundFilter) continue;
            defaultOrientations.add(dir);
        }
        if (filteredOrientations.size() != 0) {
            return filteredOrientations;
        }
        return defaultOrientations;
    }

    @Override
    public void entityEntered(IPipedItem item, Orientations orientation) {
    }

    @Override
    public void readjustSpeed(IPipedItem item) {
        ((PipeTransportItems)this.transport).defaultReajustSpeed(item);
    }
}

