/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.network;

import buildcraft.core.network.PacketCoordinates;
import buildcraft.core.network.PacketSlotChange;
import buildcraft.core.network.PacketUpdate;
import buildcraft.transport.CraftingGateInterface;
import buildcraft.transport.PipeLogicDiamond;
import buildcraft.transport.TileGenericPipe;
import forge.IPacketHandler;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;

public class PacketHandler
implements IPacketHandler {
    public void onPacketData(qq network, String channel, byte[] bytes) {
        DataInputStream data = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            mm net = (mm)network.getNetHandler();
            int packetID = data.read();
            switch (packetID) {
                case 31: {
                    PacketSlotChange packet = new PacketSlotChange();
                    packet.readData(data);
                    this.onDiamondPipeSelect(net.getPlayerEntity(), packet);
                    break;
                }
                case 41: {
                    PacketCoordinates packetU = new PacketCoordinates();
                    packetU.readData(data);
                    this.onGateInitRequest(net.getPlayerEntity(), packetU);
                    break;
                }
                case 42: {
                    PacketCoordinates packetS = new PacketCoordinates();
                    packetS.readData(data);
                    this.onGateSelectionRequest(net.getPlayerEntity(), packetS);
                    break;
                }
                case 44: {
                    PacketUpdate packetC = new PacketUpdate();
                    packetC.readData(data);
                    this.onGateSelectionChange(net.getPlayerEntity(), packetC);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void onGateSelectionChange(gi playerEntity, PacketUpdate packet) {
        if (!(playerEntity.m instanceof CraftingGateInterface)) {
            return;
        }
        ((CraftingGateInterface)playerEntity.m).handleSelectionChange(packet);
    }

    private void onGateSelectionRequest(gi playerEntity, PacketCoordinates packet) {
        if (!(playerEntity.m instanceof CraftingGateInterface)) {
            return;
        }
        ((CraftingGateInterface)playerEntity.m).sendSelection((ih)playerEntity);
    }

    private void onGateInitRequest(gi playerEntity, PacketCoordinates packet) {
        if (!(playerEntity.m instanceof CraftingGateInterface)) {
            return;
        }
        ((CraftingGateInterface)playerEntity.m).handleInitRequest((ih)playerEntity);
    }

    private TileGenericPipe getPipe(ge world, int x, int y, int z) {
        if (!world.i(x, y, z)) {
            return null;
        }
        qj tile = world.b(x, y, z);
        if (!(tile instanceof TileGenericPipe)) {
            return null;
        }
        return (TileGenericPipe)tile;
    }

    private void onDiamondPipeSelect(gi player, PacketSlotChange packet) {
        TileGenericPipe pipe = this.getPipe(player.bi, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe.logic instanceof PipeLogicDiamond)) {
            return;
        }
        ((PipeLogicDiamond)pipe.pipe.logic).a(packet.slot, packet.stack);
    }
}

