/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.Orientations;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.liquids.ILiquidTank;
import buildcraft.api.liquids.ITankContainer;
import buildcraft.api.liquids.LiquidStack;
import buildcraft.api.liquids.LiquidTank;
import buildcraft.api.transport.IPipeEntry;
import buildcraft.core.CoreProxy;
import buildcraft.core.DefaultProps;
import buildcraft.core.IMachine;
import buildcraft.core.Utils;
import buildcraft.mod_BuildCraftCore;
import buildcraft.transport.IPipeTransportLiquidsHook;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.network.PacketLiquidUpdate;

public class PipeTransportLiquids
extends PipeTransport
implements ITankContainer {
    public static int LIQUID_IN_PIPE = 250;
    public static short INPUT_TTL = (short)60;
    public static short OUTPUT_TTL = (short)80;
    public static short OUTPUT_COOLDOWN = (short)30;
    public short travelDelay = (short)12;
    public short flowRate = (short)20;
    public LiquidStack[] renderCache = new LiquidStack[Orientations.values().length];
    private final PipeSection[] internalTanks = new PipeSection[Orientations.values().length];
    private final TransferState[] transferState = new TransferState[Orientations.dirs().length];
    private final short[] inputTTL = new short[]{0, 0, 0, 0, 0, 0};
    private final short[] outputTTL = new short[]{OUTPUT_TTL, OUTPUT_TTL, OUTPUT_TTL, OUTPUT_TTL, OUTPUT_TTL, OUTPUT_TTL};
    private final short[] outputCooldown = new short[]{0, 0, 0, 0, 0, 0};
    private final SafeTimeTracker tracker = new SafeTimeTracker();

    public PipeTransportLiquids() {
        for (Orientations direction : Orientations.values()) {
            this.internalTanks[direction.ordinal()] = new PipeSection();
            if (direction == Orientations.Unknown) continue;
            this.transferState[direction.ordinal()] = TransferState.None;
        }
    }

    public boolean canReceiveLiquid(Orientations o) {
        qj entity = this.container.getTile(o);
        if (!Utils.checkPipesConnections(this.container, entity)) {
            return false;
        }
        if (entity instanceof TileGenericPipe && !((TileGenericPipe)entity).pipe.inputOpen(o.reverse())) {
            return false;
        }
        return entity instanceof IPipeEntry || entity instanceof ITankContainer;
    }

    @Override
    public void updateEntity() {
        if (CoreProxy.isClient(this.worldObj)) {
            return;
        }
        this.moveLiquids();
        for (Orientations direction : Orientations.values()) {
            LiquidStack liquid = this.internalTanks[direction.ordinal()].getLiquid();
            if (liquid != null) {
                if (this.renderCache[direction.ordinal()] == null) {
                    this.renderCache[direction.ordinal()] = liquid.copy();
                } else {
                    this.renderCache[direction.ordinal()].itemID = liquid.itemID;
                    this.renderCache[direction.ordinal()].itemMeta = liquid.itemMeta;
                }
            }
            if (this.renderCache[direction.ordinal()] == null) continue;
            int currentLiquid = liquid != null ? liquid.amount : 0;
            this.renderCache[direction.ordinal()].amount = (short)Math.min(LIQUID_IN_PIPE, (this.renderCache[direction.ordinal()].amount * 9 + currentLiquid) / 10);
            if (this.renderCache[direction.ordinal()].amount != 0 || currentLiquid <= 0) continue;
            this.renderCache[direction.ordinal()].amount = currentLiquid;
        }
        if (CoreProxy.isServerSide() && this.tracker.markTimeIfDelay(this.worldObj, 1 * BuildCraftCore.updateFactor)) {
            PacketLiquidUpdate packet = new PacketLiquidUpdate(this.xCoord, this.yCoord, this.zCoord);
            packet.displayLiquid = this.renderCache;
            CoreProxy.sendToPlayers(packet.getPacket(), this.worldObj, this.xCoord, this.yCoord, this.zCoord, DefaultProps.NETWORK_UPDATE_RANGE, mod_BuildCraftCore.instance);
        }
    }

    @Override
    public void readFromNBT(ph nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        for (Orientations direction : Orientations.values()) {
            if (nbttagcompound.c("tank[" + direction.ordinal() + "]")) {
                this.internalTanks[direction.ordinal()].readFromNBT(nbttagcompound.m("tank[" + direction.ordinal() + "]"));
            }
            if (direction == Orientations.Unknown) continue;
            this.transferState[direction.ordinal()] = TransferState.values()[nbttagcompound.e("transferState[" + direction.ordinal() + "]")];
        }
    }

    @Override
    public void writeToNBT(ph nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        for (Orientations direction : Orientations.values()) {
            ph subTag = new ph();
            this.internalTanks[direction.ordinal()].writeToNBT(subTag);
            nbttagcompound.a("tank[" + direction.ordinal() + "]", (jz)subTag);
            if (direction == Orientations.Unknown) continue;
            nbttagcompound.a("transferState[" + direction.ordinal() + "]", (short)this.transferState[direction.ordinal()].ordinal());
        }
    }

    private void moveLiquids() {
        short newTimeSlot = (short)(this.worldObj.o() % (long)this.travelDelay);
        for (Orientations direction : Orientations.values()) {
            this.internalTanks[direction.ordinal()].setTime(newTimeSlot);
            this.internalTanks[direction.ordinal()].moveLiquids();
        }
        for (Orientations direction : Orientations.dirs()) {
            if (this.transferState[direction.ordinal()] != TransferState.Input) continue;
            int n = direction.ordinal();
            short s = this.inputTTL[n];
            this.inputTTL[n] = (short)(s - 1);
            if (s >= 1) continue;
            this.transferState[direction.ordinal()] = TransferState.None;
        }
        short outputCount = this.computeOutputs();
        this.moveFromPipe(outputCount);
        this.moveFromCenter();
        this.moveToCenter();
    }

    private void moveFromPipe(short outputCount) {
        if (outputCount > 0) {
            for (Orientations o : Orientations.dirs()) {
                LiquidStack liquidToPush;
                qj target;
                if (this.transferState[o.ordinal()] != TransferState.Output || !((target = this.container.getTile(o)) instanceof ITankContainer) || (liquidToPush = this.internalTanks[o.ordinal()].drain(this.flowRate, false)) == null || liquidToPush.amount <= 0) continue;
                int filled = ((ITankContainer)target).fill(o.reverse(), liquidToPush, true);
                this.internalTanks[o.ordinal()].drain(filled, true);
                if (filled > 0) continue;
                int n = o.ordinal();
                this.outputTTL[n] = (short)(this.outputTTL[n] - 1);
            }
        }
    }

    private void moveFromCenter() {
        int[] maxOutput = new int[]{0, 0, 0, 0, 0, 0};
        int transferOutCount = 0;
        LiquidStack pushStack = this.internalTanks[Orientations.Unknown.ordinal()].getLiquid();
        int totalAvailable = this.internalTanks[Orientations.Unknown.ordinal()].getAvailable();
        if (totalAvailable < 1) {
            return;
        }
        if (pushStack != null) {
            LiquidStack testStack = pushStack.copy();
            testStack.amount = this.flowRate;
            for (Orientations direction : Orientations.dirs()) {
                if (this.transferState[direction.ordinal()] != TransferState.Output) continue;
                maxOutput[direction.ordinal()] = this.internalTanks[direction.ordinal()].fill(testStack, false);
                if (maxOutput[direction.ordinal()] <= 0) continue;
                ++transferOutCount;
            }
            if (transferOutCount <= 0) {
                return;
            }
            for (Orientations direction : Orientations.dirs()) {
                LiquidStack liquidToPush;
                if (this.transferState[direction.ordinal()] != TransferState.Output || maxOutput[direction.ordinal()] == 0) continue;
                int ammountToPush = (int)((double)maxOutput[direction.ordinal()] / (double)this.flowRate / (double)transferOutCount * (double)Math.min(this.flowRate, totalAvailable));
                if (ammountToPush < 1) {
                    ++ammountToPush;
                }
                if ((liquidToPush = this.internalTanks[Orientations.Unknown.ordinal()].drain(ammountToPush, false)) == null) continue;
                int filled = this.internalTanks[direction.ordinal()].fill(liquidToPush, true);
                this.internalTanks[Orientations.Unknown.ordinal()].drain(filled, true);
            }
        }
    }

    private void moveToCenter() {
        int[] maxInput = new int[]{0, 0, 0, 0, 0, 0};
        int transferInCount = 0;
        LiquidStack stackInCenter = this.internalTanks[Orientations.Unknown.ordinal()].drain(this.flowRate, false);
        int spaceAvailable = this.internalTanks[Orientations.Unknown.ordinal()].getCapacity();
        if (stackInCenter != null) {
            spaceAvailable -= stackInCenter.amount;
        }
        for (Orientations direction : Orientations.dirs()) {
            LiquidStack testStack = this.internalTanks[direction.ordinal()].drain(this.flowRate, false);
            if (testStack == null || stackInCenter != null && !stackInCenter.isLiquidEqual(testStack)) continue;
            maxInput[direction.ordinal()] = testStack.amount;
            ++transferInCount;
        }
        for (Orientations direction : Orientations.dirs()) {
            LiquidStack liquidToPush;
            if (this.transferState[direction.ordinal()] == TransferState.Output || maxInput[direction.ordinal()] <= 0) continue;
            int ammountToDrain = (int)((double)maxInput[direction.ordinal()] / (double)this.flowRate / (double)transferInCount * (double)Math.min(this.flowRate, spaceAvailable));
            if (ammountToDrain < 1) {
                ++ammountToDrain;
            }
            if ((liquidToPush = this.internalTanks[direction.ordinal()].drain(ammountToDrain, false)) == null) continue;
            int filled = this.internalTanks[Orientations.Unknown.ordinal()].fill(liquidToPush, true);
            this.internalTanks[direction.ordinal()].drain(filled, true);
        }
    }

    private short computeOutputs() {
        short outputCount = 0;
        for (Orientations o : Orientations.dirs()) {
            if (this.transferState[o.ordinal()] == TransferState.Input) continue;
            if (!this.container.pipe.outputOpen(o)) {
                this.transferState[o.ordinal()] = TransferState.None;
                continue;
            }
            if (this.outputCooldown[o.ordinal()] > 0) {
                int n = o.ordinal();
                this.outputCooldown[n] = (short)(this.outputCooldown[n] - 1);
                continue;
            }
            if (this.outputTTL[o.ordinal()] <= 0) {
                this.transferState[o.ordinal()] = TransferState.None;
                this.outputCooldown[o.ordinal()] = OUTPUT_COOLDOWN;
                this.outputTTL[o.ordinal()] = OUTPUT_TTL;
                continue;
            }
            if (!this.canReceiveLiquid(o)) continue;
            this.transferState[o.ordinal()] = TransferState.Output;
            outputCount = (short)(outputCount + 1);
        }
        return outputCount;
    }

    @Override
    public void onNeighborBlockChange(int blockId) {
        super.onNeighborBlockChange(blockId);
        for (Orientations direction : Orientations.dirs()) {
            if (Utils.checkPipesConnections(this.container.getTile(Orientations.values()[direction.ordinal()]), this.container)) continue;
            this.internalTanks[direction.ordinal()].reset();
            this.transferState[direction.ordinal()] = TransferState.None;
            this.renderCache[direction.ordinal()] = null;
        }
    }

    @Override
    public boolean isPipeConnected(qj tile) {
        ITankContainer liq;
        if (tile instanceof ITankContainer && (liq = (ITankContainer)tile).getTanks() != null && liq.getTanks().length > 0) {
            return true;
        }
        return tile instanceof TileGenericPipe || tile instanceof IMachine && ((IMachine)tile).manageLiquids();
    }

    public boolean isTriggerActive(ITrigger trigger) {
        return false;
    }

    @Override
    public boolean allowsConnect(PipeTransport with) {
        return with instanceof PipeTransportLiquids;
    }

    public void handleLiquidPacket(PacketLiquidUpdate packetLiquid) {
        this.renderCache = packetLiquid.displayLiquid;
    }

    @Override
    public int fill(Orientations from, LiquidStack resource, boolean doFill) {
        return this.fill(from.ordinal(), resource, doFill);
    }

    @Override
    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        int filled = this.container.pipe instanceof IPipeTransportLiquidsHook ? ((IPipeTransportLiquidsHook)((Object)this.container.pipe)).fill(Orientations.values()[tankIndex], resource, doFill) : this.internalTanks[tankIndex].fill(resource, doFill);
        if (filled > 0 && doFill && tankIndex != Orientations.Unknown.ordinal()) {
            this.transferState[tankIndex] = TransferState.Input;
            this.inputTTL[tankIndex] = INPUT_TTL;
        }
        return filled;
    }

    @Override
    public LiquidStack drain(Orientations from, int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public ILiquidTank[] getTanks() {
        return this.internalTanks;
    }

    public static enum TransferState {
        None,
        Input,
        Output;

    }

    public class PipeSection
    extends LiquidTank {
        private short currentTime;
        private short[] incomming;

        public PipeSection() {
            super(null, LIQUID_IN_PIPE);
            this.currentTime = 0;
            this.incomming = new short[PipeTransportLiquids.this.travelDelay];
        }

        @Override
        public int fill(LiquidStack resource, boolean doFill) {
            if (resource == null) {
                return 0;
            }
            int maxToFill = Math.min(resource.amount, PipeTransportLiquids.this.flowRate - this.incomming[this.currentTime]);
            if (maxToFill <= 0) {
                return 0;
            }
            LiquidStack stackToFill = resource.copy();
            stackToFill.amount = maxToFill;
            int filled = super.fill(stackToFill, doFill);
            if (doFill) {
                short s = this.currentTime;
                this.incomming[s] = (short)(this.incomming[s] + filled);
            }
            return filled;
        }

        @Override
        public LiquidStack drain(int maxDrain, boolean doDrain) {
            int maxToDrain = Math.min(maxDrain, Math.min(PipeTransportLiquids.this.flowRate, this.getAvailable()));
            if (maxToDrain < 0) {
                return null;
            }
            LiquidStack drained = super.drain(maxToDrain, doDrain);
            if (drained == null) {
                return null;
            }
            return drained;
        }

        public void moveLiquids() {
            this.incomming[this.currentTime] = 0;
        }

        public void setTime(short newTime) {
            this.currentTime = newTime;
        }

        public void reset() {
            this.setLiquid(null);
            this.incomming = new short[PipeTransportLiquids.this.travelDelay];
        }

        public int getAvailable() {
            int all = this.getLiquid() != null ? this.getLiquid().amount : 0;
            for (short slot : this.incomming) {
                all -= slot;
            }
            return all;
        }

        public void readFromNBT(ph compoundTag) {
            this.setCapacity(compoundTag.f("capacity"));
            for (int i = 0; i < PipeTransportLiquids.this.travelDelay; ++i) {
                this.incomming[i] = compoundTag.e("in[" + i + "]");
            }
            this.setLiquid(LiquidStack.loadLiquidStackFromNBT(compoundTag));
        }

        public void writeToNBT(ph subTag) {
            subTag.a("capacity", this.getCapacity());
            for (int i = 0; i < PipeTransportLiquids.this.travelDelay; ++i) {
                this.incomming[i] = subTag.e("in[" + i + "]");
            }
            if (this.getLiquid() != null) {
                this.getLiquid().writeToNBT(subTag);
            }
        }
    }
}

