/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftTransport;
import buildcraft.api.core.Orientations;
import buildcraft.api.core.Position;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.transport.IPipeEntry;
import buildcraft.api.transport.IPipedItem;
import buildcraft.core.CoreProxy;
import buildcraft.core.DefaultProps;
import buildcraft.core.EntityPassiveItem;
import buildcraft.core.IMachine;
import buildcraft.core.StackUtil;
import buildcraft.core.Utils;
import buildcraft.core.network.PacketPipeTransportContent;
import buildcraft.mod_BuildCraftTransport;
import buildcraft.transport.EntityData;
import buildcraft.transport.IItemTravelingHook;
import buildcraft.transport.IPipeTransportItemsHook;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.TileGenericPipe;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;

public class PipeTransportItems
extends PipeTransport {
    public boolean allowBouncing = false;
    public TreeMap travelingEntities = new TreeMap();
    private final Vector entitiesToLoad = new Vector();
    public IItemTravelingHook travelHook;
    HashSet toRemove = new HashSet();

    public void readjustSpeed(IPipedItem item) {
        if (this.container.pipe instanceof IPipeTransportItemsHook) {
            ((IPipeTransportItemsHook)((Object)this.container.pipe)).readjustSpeed(item);
        } else {
            this.defaultReajustSpeed(item);
        }
    }

    public void defaultReajustSpeed(IPipedItem item) {
        if (item.getSpeed() > Utils.pipeNormalSpeed) {
            item.setSpeed(item.getSpeed() - Utils.pipeNormalSpeed);
        }
        if (item.getSpeed() < Utils.pipeNormalSpeed) {
            item.setSpeed(Utils.pipeNormalSpeed);
        }
    }

    @Override
    public void entityEntering(IPipedItem item, Orientations orientation) {
        if (item.isCorrupted()) {
            return;
        }
        this.readjustSpeed(item);
        if (!this.travelingEntities.containsKey(new Integer(item.getEntityId()))) {
            this.travelingEntities.put(new Integer(item.getEntityId()), new EntityData(item, orientation));
            if (item.getContainer() != null && item.getContainer() != this.container) {
                ((PipeTransportItems)((TileGenericPipe)item.getContainer()).pipe.transport).scheduleRemoval(item);
            }
            item.setContainer(this.container);
        }
        if (orientation != Orientations.YPos && orientation != Orientations.YNeg) {
            item.setPosition(item.getPosition().x, (float)this.yCoord + Utils.getPipeFloorOf(item.getItemStack()), item.getPosition().z);
        }
        if (this.container.pipe instanceof IPipeTransportItemsHook) {
            ((IPipeTransportItemsHook)((Object)this.container.pipe)).entityEntered(item, orientation);
        }
        if (CoreProxy.isServerSide() && item.getSynchroTracker().markTimeIfDelay(this.worldObj, 6 * BuildCraftCore.updateFactor)) {
            CoreProxy.sendToPlayers(this.createItemPacket(item, orientation), this.worldObj, this.xCoord, this.yCoord, this.zCoord, DefaultProps.NETWORK_UPDATE_RANGE, mod_BuildCraftTransport.instance);
        }
        if (this.travelingEntities.size() > BuildCraftTransport.groupItemsTrigger) {
            this.groupEntities();
            if (this.travelingEntities.size() > BuildCraftTransport.maxItemsInPipes) {
                this.worldObj.a(null, (double)this.xCoord, (double)this.yCoord, (double)this.zCoord, 1.0f);
            }
        }
    }

    public LinkedList getPossibleMovements(Position pos, IPipedItem item) {
        LinkedList result = new LinkedList();
        for (Orientations o : Orientations.dirs()) {
            if (o == pos.orientation.reverse() || !this.container.pipe.outputOpen(o) || !this.canReceivePipeObjects(o, item)) continue;
            result.add(o);
        }
        if (result.size() == 0 && this.allowBouncing) {
            Position newPos = new Position(pos);
            newPos.orientation = newPos.orientation.reverse();
            if (this.canReceivePipeObjects(pos.orientation.reverse(), item)) {
                result.add(pos.orientation.reverse());
            }
        }
        if (this.container.pipe instanceof IPipeTransportItemsHook) {
            result = ((IPipeTransportItemsHook)((Object)this.container.pipe)).filterPossibleMovements(result, pos, item);
        }
        return result;
    }

    public boolean canReceivePipeObjects(Orientations o, IPipedItem item) {
        qj entity = this.container.getTile(o);
        if (!Utils.checkPipesConnections(entity, this.container)) {
            return false;
        }
        if (entity instanceof IPipeEntry) {
            return true;
        }
        if (entity instanceof TileGenericPipe) {
            TileGenericPipe pipe = (TileGenericPipe)entity;
            return pipe.pipe.transport instanceof PipeTransportItems;
        }
        return entity instanceof ni && new StackUtil(item.getItemStack()).checkAvailableSlot((ni)entity, false, o.reverse());
    }

    @Override
    public void updateEntity() {
        this.moveSolids();
    }

    public void scheduleRemoval(IPipedItem item) {
        if (!this.toRemove.contains(item.getEntityId())) {
            this.toRemove.add(item.getEntityId());
        }
    }

    public void performRemoval() {
        this.travelingEntities.keySet().removeAll(this.toRemove);
        this.toRemove = new HashSet();
    }

    private void moveSolids() {
        for (EntityData data : this.entitiesToLoad) {
            data.item.setWorld(this.worldObj);
            this.travelingEntities.put(new Integer(data.item.getEntityId()), data);
        }
        this.entitiesToLoad.clear();
        this.performRemoval();
        for (EntityData data : this.travelingEntities.values()) {
            if (data.item.isCorrupted()) {
                this.scheduleRemoval(data.item);
                data.item.remove();
                continue;
            }
            Position motion = new Position(0.0, 0.0, 0.0, data.orientation);
            motion.moveForwards(data.item.getSpeed());
            data.item.setPosition(data.item.getPosition().x + motion.x, data.item.getPosition().y + motion.y, data.item.getPosition().z + motion.z);
            if (data.toCenter && this.middleReached(data) || this.outOfBounds(data)) {
                data.toCenter = false;
                data.item.setPosition((double)this.xCoord + 0.5, (float)this.yCoord + Utils.getPipeFloorOf(data.item.getItemStack()), (double)this.zCoord + 0.5);
                Orientations nextOrientation = this.resolveDestination(data);
                if (nextOrientation == Orientations.Unknown) {
                    if (this.travelHook != null) {
                        this.travelHook.drop(this, data);
                    }
                    ja dropped = null;
                    if (!this.toRemove.contains(data.item.getEntityId())) {
                        dropped = data.item.toEntityItem(data.orientation);
                    }
                    this.scheduleRemoval(data.item);
                    if (dropped == null) continue;
                    this.onDropped(dropped);
                    continue;
                }
                data.orientation = nextOrientation;
                if (this.travelHook == null) continue;
                this.travelHook.centerReached(this, data);
                continue;
            }
            if (data.toCenter || !this.endReached(data)) continue;
            Position destPos = new Position(this.xCoord, this.yCoord, this.zCoord, data.orientation);
            destPos.moveForwards(1.0);
            qj tile = this.worldObj.b((int)destPos.x, (int)destPos.y, (int)destPos.z);
            if (this.travelHook != null) {
                this.travelHook.endReached(this, data, tile);
            }
            if (this.toRemove.contains(data.item.getEntityId())) continue;
            this.scheduleRemoval(data.item);
            this.handleTileReached(data, tile);
        }
        this.performRemoval();
    }

    private void handleTileReached(EntityData data, qj tile) {
        if (tile instanceof IPipeEntry) {
            ((IPipeEntry)tile).entityEntering(data.item, data.orientation);
        } else if (tile instanceof TileGenericPipe && ((TileGenericPipe)tile).pipe.transport instanceof PipeTransportItems) {
            TileGenericPipe pipe = (TileGenericPipe)tile;
            ((PipeTransportItems)pipe.pipe.transport).entityEntering(data.item, data.orientation);
        } else if (tile instanceof ni) {
            StackUtil utils = new StackUtil(data.item.getItemStack());
            if (!CoreProxy.isClient(this.worldObj)) {
                if (utils.checkAvailableSlot((ni)tile, true, data.orientation.reverse()) && utils.items.a == 0) {
                    data.item.remove();
                } else {
                    data.item.setItemStack(utils.items);
                    ja dropped = data.item.toEntityItem(data.orientation);
                    if (dropped != null) {
                        this.onDropped(dropped);
                    }
                }
            }
        } else {
            ja dropped;
            if (this.travelHook != null) {
                this.travelHook.drop(this, data);
            }
            if ((dropped = data.item.toEntityItem(data.orientation)) != null) {
                this.onDropped(dropped);
            }
        }
    }

    public boolean middleReached(EntityData entity) {
        float middleLimit = entity.item.getSpeed() * 1.01f;
        return Math.abs((double)this.xCoord + 0.5 - entity.item.getPosition().x) < (double)middleLimit && Math.abs((double)((float)this.yCoord + Utils.getPipeFloorOf(entity.item.getItemStack())) - entity.item.getPosition().y) < (double)middleLimit && Math.abs((double)this.zCoord + 0.5 - entity.item.getPosition().z) < (double)middleLimit;
    }

    public boolean endReached(EntityData entity) {
        return entity.item.getPosition().x > (double)this.xCoord + 1.0 || entity.item.getPosition().x < (double)this.xCoord || entity.item.getPosition().y > (double)this.yCoord + 1.0 || entity.item.getPosition().y < (double)this.yCoord || entity.item.getPosition().z > (double)this.zCoord + 1.0 || entity.item.getPosition().z < (double)this.zCoord;
    }

    public boolean outOfBounds(EntityData entity) {
        return entity.item.getPosition().x > (double)this.xCoord + 2.0 || entity.item.getPosition().x < (double)this.xCoord - 1.0 || entity.item.getPosition().y > (double)this.yCoord + 2.0 || entity.item.getPosition().y < (double)this.yCoord - 1.0 || entity.item.getPosition().z > (double)this.zCoord + 2.0 || entity.item.getPosition().z < (double)this.zCoord - 1.0;
    }

    public Position getPosition() {
        return new Position(this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public void readFromNBT(ph nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        tx nbttaglist = nbttagcompound.n("travelingEntities");
        for (int j = 0; j < nbttaglist.d(); ++j) {
            try {
                ph nbttagcompound2 = (ph)nbttaglist.a(j);
                EntityPassiveItem entity = new EntityPassiveItem(null);
                entity.readFromNBT(nbttagcompound2);
                if (entity.isCorrupted()) {
                    entity.remove();
                    continue;
                }
                entity.setContainer(this.container);
                EntityData data = new EntityData(entity, Orientations.values()[nbttagcompound2.f("orientation")]);
                data.toCenter = nbttagcompound2.o("toCenter");
                this.entitiesToLoad.add(data);
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    @Override
    public void writeToNBT(ph nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        tx nbttaglist = new tx();
        for (EntityData data : this.travelingEntities.values()) {
            ph nbttagcompound2 = new ph();
            nbttaglist.a((jz)nbttagcompound2);
            data.item.writeToNBT(nbttagcompound2);
            nbttagcompound2.a("toCenter", data.toCenter);
            nbttagcompound2.a("orientation", data.orientation.ordinal());
        }
        nbttagcompound.a("travelingEntities", (jz)nbttaglist);
    }

    public Orientations resolveDestination(EntityData data) {
        int i;
        LinkedList listOfPossibleMovements = this.getPossibleMovements(new Position(this.xCoord, this.yCoord, this.zCoord, data.orientation), data.item);
        if (listOfPossibleMovements.size() == 0) {
            return Orientations.Unknown;
        }
        if (CoreProxy.isClient(this.worldObj) || CoreProxy.isServerSide()) {
            i = Math.abs(data.item.getEntityId() + this.xCoord + this.yCoord + this.zCoord + data.item.getDeterministicRandomization()) % listOfPossibleMovements.size();
            data.item.setDeterministicRandomization(data.item.getDeterministicRandomization() * 11);
        } else {
            i = this.worldObj.r.nextInt(listOfPossibleMovements.size());
        }
        return (Orientations)((Object)listOfPossibleMovements.get(i));
    }

    protected void doWork() {
    }

    public void handleItemPacket(PacketPipeTransportContent packet) {
        if (packet.getID() != 2) {
            return;
        }
        IPipedItem item = EntityPassiveItem.getOrCreate(this.worldObj, packet.getEntityId());
        item.setItemStack(new kp(packet.getItemId(), packet.getStackSize(), packet.getItemDamage()));
        item.setPosition(packet.getPosX(), packet.getPosY(), packet.getPosZ());
        item.setSpeed(packet.getSpeed());
        item.setDeterministicRandomization(packet.getRandomization());
        if (item.getContainer() != this.container || !this.travelingEntities.containsKey(item.getEntityId())) {
            if (item.getContainer() != null) {
                ((PipeTransportItems)((TileGenericPipe)item.getContainer()).pipe.transport).scheduleRemoval(item);
            }
            this.travelingEntities.put(new Integer(item.getEntityId()), new EntityData(item, packet.getOrientation()));
            item.setContainer(this.container);
        } else {
            ((EntityData)this.travelingEntities.get((Object)new Integer((int)item.getEntityId()))).orientation = packet.getOrientation();
        }
    }

    public lx createItemPacket(IPipedItem item, Orientations orientation) {
        item.setDeterministicRandomization(item.getDeterministicRandomization() + this.worldObj.r.nextInt(6));
        PacketPipeTransportContent packet = new PacketPipeTransportContent(this.container.l, this.container.m, this.container.n, item, orientation);
        return packet.getPacket();
    }

    public int getNumberOfItems() {
        return this.travelingEntities.size();
    }

    public void onDropped(ja item) {
        this.container.pipe.onDropped(item);
    }

    protected void neighborChange() {
    }

    @Override
    public boolean isPipeConnected(qj tile) {
        return tile instanceof TileGenericPipe || tile instanceof IPipeEntry || tile instanceof ni || tile instanceof IMachine && ((IMachine)tile).manageSolids();
    }

    @Override
    public boolean acceptItems() {
        return true;
    }

    public boolean isTriggerActive(ITrigger trigger) {
        return false;
    }

    public void groupEntities() {
        EntityData[] entities = this.travelingEntities.values().toArray(new EntityData[this.travelingEntities.size()]);
        TreeSet<Integer> toRemove = new TreeSet<Integer>();
        for (int i = 0; i < entities.length; ++i) {
            EntityData data1 = entities[i];
            for (int j = i + 1; j < entities.length; ++j) {
                EntityData data2 = entities[j];
                if (data1.item.getItemStack().c != data2.item.getItemStack().c || data1.item.getItemStack().h() != data2.item.getItemStack().h() || toRemove.contains(data1.item.getEntityId()) || toRemove.contains(data2.item.getEntityId()) || data1.item.hasContributions() || data2.item.hasContributions() || data1.item.getItemStack().a + data2.item.getItemStack().a >= data1.item.getItemStack().b()) continue;
                data1.item.getItemStack().a += data2.item.getItemStack().a;
                toRemove.add(data2.item.getEntityId());
            }
        }
        for (Integer i : toRemove) {
            ((EntityData)this.travelingEntities.get((Object)i)).item.remove();
            this.travelingEntities.remove(i);
        }
    }

    @Override
    public void dropContents() {
        this.groupEntities();
        for (EntityData data : this.travelingEntities.values()) {
            Utils.dropItems(this.worldObj, data.item.getItemStack(), this.xCoord, this.yCoord, this.zCoord);
        }
        this.travelingEntities.clear();
    }

    @Override
    public boolean allowsConnect(PipeTransport with) {
        return with instanceof PipeTransportItems;
    }
}

