/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.core.DefaultProps;
import buildcraft.transport.utils.ConnectionMatrix;
import buildcraft.transport.utils.FacadeMatrix;
import buildcraft.transport.utils.TextureMatrix;
import buildcraft.transport.utils.WireMatrix;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class PipeRenderState {
    private String textureFile = DefaultProps.TEXTURE_BLOCKS;
    private boolean hasGate = false;
    private int gateTextureIndex = 0;
    public final ConnectionMatrix pipeConnectionMatrix = new ConnectionMatrix();
    public final TextureMatrix textureMatrix = new TextureMatrix();
    public final WireMatrix wireMatrix = new WireMatrix();
    public final FacadeMatrix facadeMatrix = new FacadeMatrix();
    private boolean dirty = false;
    public int currentTextureIndex;

    public void setTextureFile(String textureFile) {
        if (this.textureFile != textureFile) {
            this.textureFile = textureFile;
            this.dirty = true;
        }
    }

    public String getTextureFile() {
        return this.textureFile;
    }

    public void setHasGate(boolean value) {
        if (this.hasGate != value) {
            this.hasGate = value;
            this.dirty = true;
        }
    }

    public boolean hasGate() {
        return this.hasGate;
    }

    public void setGateTexture(int value) {
        if (this.gateTextureIndex != value) {
            this.gateTextureIndex = value;
            this.dirty = true;
        }
    }

    public int getGateTextureIndex() {
        return this.gateTextureIndex;
    }

    public void clean() {
        this.dirty = false;
        this.pipeConnectionMatrix.clean();
        this.textureMatrix.clean();
        this.wireMatrix.clean();
        this.facadeMatrix.clean();
    }

    public boolean isDirty() {
        return this.dirty || this.pipeConnectionMatrix.isDirty() || this.textureMatrix.isDirty() || this.wireMatrix.isDirty() || this.facadeMatrix.isDirty();
    }

    public void writeData(DataOutputStream data) throws IOException {
        data.writeUTF(this.textureFile);
        data.writeBoolean(this.hasGate);
        data.writeInt(this.gateTextureIndex);
        this.pipeConnectionMatrix.writeData(data);
        this.textureMatrix.writeData(data);
        this.wireMatrix.writeData(data);
        this.facadeMatrix.writeData(data);
    }

    public void readData(DataInputStream data) throws IOException {
        this.textureFile = data.readUTF();
        this.hasGate = data.readBoolean();
        this.gateTextureIndex = data.readInt();
        this.pipeConnectionMatrix.readData(data);
        this.textureMatrix.readData(data);
        this.wireMatrix.readData(data);
        this.facadeMatrix.readData(data);
    }
}

