/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.Orientations;
import buildcraft.api.liquids.ITankContainer;
import buildcraft.api.tools.IToolWrench;
import buildcraft.api.transport.PipeManager;
import buildcraft.core.CoreProxy;
import buildcraft.core.Utils;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeLogic;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.pipes.PipeLiquidsWood;

public class PipeLogicWood
extends PipeLogic {
    public void switchSource() {
        int meta = this.worldObj.c(this.xCoord, this.yCoord, this.zCoord);
        int newMeta = 6;
        for (int i = meta + 1; i <= meta + 6; ++i) {
            Orientations o = Orientations.values()[i % 6];
            vz block = vz.m[this.container.getBlockId(o)];
            qj tile = this.container.getTile(o);
            if (!this.isInput(tile) || !PipeManager.canExtractItems(this.container.getPipe(), tile.k, tile.l, tile.m, tile.n) && !PipeManager.canExtractLiquids(this.container.getPipe(), tile.k, tile.l, tile.m, tile.n)) continue;
            newMeta = o.ordinal();
            break;
        }
        if (newMeta != meta) {
            this.worldObj.d(this.xCoord, this.yCoord, this.zCoord, newMeta);
            this.container.scheduleRenderUpdate();
        }
    }

    public boolean isInput(qj tile) {
        return !(tile instanceof TileGenericPipe) && (tile instanceof ni || tile instanceof ITankContainer) && Utils.checkPipesConnections(this.container, tile);
    }

    @Override
    public boolean blockActivated(ih entityplayer) {
        id equipped;
        id id2 = equipped = entityplayer.U() != null ? entityplayer.U().a() : null;
        if (equipped instanceof IToolWrench && ((IToolWrench)equipped).canWrench(entityplayer, this.xCoord, this.yCoord, this.zCoord)) {
            this.switchSource();
            ((IToolWrench)equipped).wrenchUsed(entityplayer, this.xCoord, this.yCoord, this.zCoord);
            return true;
        }
        return false;
    }

    @Override
    public boolean isPipeConnected(qj tile) {
        Pipe pipe2 = null;
        if (tile instanceof TileGenericPipe) {
            pipe2 = ((TileGenericPipe)tile).pipe;
        }
        if (BuildCraftTransport.alwaysConnectPipes) {
            return super.isPipeConnected(tile);
        }
        return (pipe2 == null || !(pipe2.logic instanceof PipeLogicWood)) && super.isPipeConnected(tile);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!CoreProxy.isClient(this.worldObj)) {
            this.switchSourceIfNeeded();
        }
    }

    private void switchSourceIfNeeded() {
        int meta = this.worldObj.c(this.xCoord, this.yCoord, this.zCoord);
        if (meta > 5) {
            this.switchSource();
        } else {
            qj tile = this.container.getTile(Orientations.values()[meta]);
            if (!this.isInput(tile)) {
                this.switchSource();
            }
        }
    }

    @Override
    public void onNeighborBlockChange(int blockId) {
        super.onNeighborBlockChange(blockId);
        if (!CoreProxy.isClient(this.worldObj)) {
            this.switchSourceIfNeeded();
        }
    }

    @Override
    public boolean outputOpen(Orientations to) {
        if (this.container.pipe instanceof PipeLiquidsWood) {
            int meta = this.worldObj.c(this.xCoord, this.yCoord, this.zCoord);
            return meta != to.ordinal();
        }
        return super.outputOpen(to);
    }
}

