/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftTransport;
import buildcraft.api.gates.IAction;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.transport.IPipe;
import buildcraft.core.CoreProxy;
import buildcraft.core.DefaultProps;
import buildcraft.core.Utils;
import buildcraft.mod_BuildCraftTransport;
import buildcraft.transport.ActionEnergyPulser;
import buildcraft.transport.EnergyPulser;
import buildcraft.transport.Gate;
import buildcraft.transport.Pipe;
import java.util.LinkedList;

public class GateVanilla
extends Gate {
    private EnergyPulser pulser;

    public GateVanilla(Pipe pipe) {
        super(pipe);
    }

    public GateVanilla(Pipe pipe, kp stack) {
        super(pipe, stack);
        if (stack.c == BuildCraftTransport.pipeGateAutarchic.bP) {
            this.addEnergyPulser(pipe);
        }
    }

    @Override
    public void writeToNBT(ph nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        if (this.pulser != null) {
            ph nbttagcompoundC = new ph();
            this.pulser.writeToNBT(nbttagcompoundC);
            nbttagcompound.a("Pulser", (jz)nbttagcompoundC);
        }
    }

    @Override
    public void readFromNBT(ph nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        if (nbttagcompound.c("Pulser")) {
            ph nbttagcompoundP = nbttagcompound.m("Pulser");
            this.pulser = new EnergyPulser((IPowerReceptor)((Object)this.pipe));
            this.pulser.readFromNBT(nbttagcompoundP);
        }
    }

    @Override
    public void openGui(ih player) {
        if (!CoreProxy.isClient(player.bi)) {
            player.openGui((BaseMod)mod_BuildCraftTransport.instance, 51, this.pipe.worldObj, this.pipe.xCoord, this.pipe.yCoord, this.pipe.zCoord);
        }
    }

    @Override
    public void update() {
        if (this.hasPulser()) {
            this.pulser.update();
        }
    }

    private boolean hasPulser() {
        return this.pulser != null;
    }

    @Override
    public String getName() {
        switch (this.kind) {
            case Single: {
                return "Gate";
            }
            case AND_2: {
                return "Iron AND Gate";
            }
            case AND_3: {
                return "Golden AND Gate";
            }
            case AND_4: {
                return "Diamond AND Gate";
            }
            case OR_2: {
                return "Iron OR Gate";
            }
            case OR_3: {
                return "Golden OR Gate";
            }
            case OR_4: {
                return "Diamond OR Gate";
            }
        }
        return "";
    }

    @Override
    public Gate.GateConditional getConditional() {
        if (this.kind == Gate.GateKind.OR_2 || this.kind == Gate.GateKind.OR_3 || this.kind == Gate.GateKind.OR_4) {
            return Gate.GateConditional.OR;
        }
        if (this.kind == Gate.GateKind.AND_2 || this.kind == Gate.GateKind.AND_3 || this.kind == Gate.GateKind.AND_4) {
            return Gate.GateConditional.AND;
        }
        return Gate.GateConditional.None;
    }

    private boolean addEnergyPulser(Pipe pipe) {
        if (!(pipe instanceof IPowerReceptor)) {
            this.pulser = new EnergyPulser(null);
            return false;
        }
        this.pulser = new EnergyPulser((IPowerReceptor)((Object)pipe));
        return true;
    }

    @Override
    public void dropGate(ge world, int i, int j, int k2) {
        int gateDamage = 0;
        switch (this.kind) {
            case Single: {
                gateDamage = 0;
                break;
            }
            case AND_2: {
                gateDamage = 1;
                break;
            }
            case OR_2: {
                gateDamage = 2;
                break;
            }
            case AND_3: {
                gateDamage = 3;
                break;
            }
            case OR_3: {
                gateDamage = 4;
                break;
            }
            case AND_4: {
                gateDamage = 5;
                break;
            }
            case OR_4: {
                gateDamage = 6;
            }
        }
        id gateItem = this.hasPulser() ? BuildCraftTransport.pipeGateAutarchic : BuildCraftTransport.pipeGate;
        Utils.dropItems(world, new kp(gateItem, 1, gateDamage), i, j, k2);
    }

    @Override
    public void addActions(LinkedList list) {
        if (this.pipe.wireSet[IPipe.WireColor.Red.ordinal()] && this.kind.ordinal() >= Gate.GateKind.AND_2.ordinal()) {
            list.add(BuildCraftTransport.actionRedSignal);
        }
        if (this.pipe.wireSet[IPipe.WireColor.Blue.ordinal()] && this.kind.ordinal() >= Gate.GateKind.AND_3.ordinal()) {
            list.add(BuildCraftTransport.actionBlueSignal);
        }
        if (this.pipe.wireSet[IPipe.WireColor.Green.ordinal()] && this.kind.ordinal() >= Gate.GateKind.AND_4.ordinal()) {
            list.add(BuildCraftTransport.actionGreenSignal);
        }
        if (this.pipe.wireSet[IPipe.WireColor.Yellow.ordinal()] && this.kind.ordinal() >= Gate.GateKind.AND_4.ordinal()) {
            list.add(BuildCraftTransport.actionYellowSignal);
        }
        if (this.hasPulser()) {
            list.add(BuildCraftTransport.actionEnergyPulser);
        }
    }

    @Override
    public void startResolution() {
        if (this.hasPulser()) {
            this.pulser.disablePulse();
        }
    }

    @Override
    public boolean resolveAction(IAction action) {
        if (action instanceof ActionEnergyPulser) {
            this.pulser.enablePulse();
            return true;
        }
        return false;
    }

    @Override
    public void addTrigger(LinkedList list) {
        if (this.pipe.wireSet[IPipe.WireColor.Red.ordinal()] && this.kind.ordinal() >= Gate.GateKind.AND_2.ordinal()) {
            list.add(BuildCraftTransport.triggerRedSignalActive);
            list.add(BuildCraftTransport.triggerRedSignalInactive);
        }
        if (this.pipe.wireSet[IPipe.WireColor.Blue.ordinal()] && this.kind.ordinal() >= Gate.GateKind.AND_3.ordinal()) {
            list.add(BuildCraftTransport.triggerBlueSignalActive);
            list.add(BuildCraftTransport.triggerBlueSignalInactive);
        }
        if (this.pipe.wireSet[IPipe.WireColor.Green.ordinal()] && this.kind.ordinal() >= Gate.GateKind.AND_4.ordinal()) {
            list.add(BuildCraftTransport.triggerGreenSignalActive);
            list.add(BuildCraftTransport.triggerGreenSignalInactive);
        }
        if (this.pipe.wireSet[IPipe.WireColor.Yellow.ordinal()] && this.kind.ordinal() >= Gate.GateKind.AND_4.ordinal()) {
            list.add(BuildCraftTransport.triggerYellowSignalActive);
            list.add(BuildCraftTransport.triggerYellowSignalInactive);
        }
    }

    @Override
    public final int getTexture(boolean isSignalActive) {
        boolean isGateActive = isSignalActive;
        if (this.hasPulser() && this.pulser.isActive()) {
            isGateActive = true;
        }
        int n = this.getTextureRow();
        switch (this.kind) {
            case None: {
                break;
            }
            case Single: {
                if (!isGateActive) {
                    return n * 16 + 12;
                }
                return n * 16 + 13;
            }
            case AND_2: {
                if (!isGateActive) {
                    if (this.hasPulser()) {
                        return 144;
                    }
                    return 103;
                }
                if (this.hasPulser()) {
                    return 145;
                }
                return 104;
            }
            case OR_2: {
                if (!isGateActive) {
                    if (this.hasPulser()) {
                        return 146;
                    }
                    return 105;
                }
                if (this.hasPulser()) {
                    return 147;
                }
                return 106;
            }
            case AND_3: {
                if (!isGateActive) {
                    return n * 16 + 4;
                }
                return n * 16 + 5;
            }
            case OR_3: {
                if (!isGateActive) {
                    return n * 16 + 6;
                }
                return n * 16 + 7;
            }
            case AND_4: {
                if (!isGateActive) {
                    return n * 16 + 8;
                }
                return n * 16 + 9;
            }
            case OR_4: {
                if (!isGateActive) {
                    return n * 16 + 10;
                }
                return n * 16 + 11;
            }
        }
        return 0;
    }

    private int getTextureRow() {
        if (this.hasPulser()) {
            return 9;
        }
        return 8;
    }

    @Override
    public String getGuiFile() {
        if (this.kind == Gate.GateKind.Single) {
            return DefaultProps.TEXTURE_PATH_GUI + "/gate_interface_1.png";
        }
        if (this.kind == Gate.GateKind.AND_2 || this.kind == Gate.GateKind.OR_2) {
            return DefaultProps.TEXTURE_PATH_GUI + "/gate_interface_2.png";
        }
        if (this.kind == Gate.GateKind.AND_3 || this.kind == Gate.GateKind.OR_3) {
            return DefaultProps.TEXTURE_PATH_GUI + "/gate_interface_3.png";
        }
        return DefaultProps.TEXTURE_PATH_GUI + "/gate_interface_4.png";
    }
}

