/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.network;

import buildcraft.core.network.PacketCoordinates;
import buildcraft.core.network.PacketUpdate;
import buildcraft.factory.TileAssemblyTable;
import forge.IPacketHandler;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;

public class PacketHandler
implements IPacketHandler {
    public void onPacketData(qq network, String channel, byte[] bytes) {
        DataInputStream data = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            mm net = (mm)network.getNetHandler();
            int packetID = data.read();
            switch (packetID) {
                case 21: {
                    PacketUpdate packet = new PacketUpdate();
                    packet.readData(data);
                    this.onAssemblySelect(net.getPlayerEntity(), packet);
                    break;
                }
                case 20: {
                    PacketCoordinates packetC = new PacketCoordinates();
                    packetC.readData(data);
                    this.onAssemblyGetSelection(net.getPlayerEntity(), packetC);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private TileAssemblyTable getAssemblyTable(ge world, int x, int y, int z) {
        if (!world.i(x, y, z)) {
            return null;
        }
        qj tile = world.b(x, y, z);
        if (!(tile instanceof TileAssemblyTable)) {
            return null;
        }
        return (TileAssemblyTable)tile;
    }

    private void onAssemblyGetSelection(gi player, PacketCoordinates packet) {
        TileAssemblyTable tile = this.getAssemblyTable(player.bi, packet.posX, packet.posY, packet.posZ);
        if (tile == null) {
            return;
        }
        tile.sendSelectionTo((ih)player);
    }

    private void onAssemblySelect(gi player, PacketUpdate packet) {
        TileAssemblyTable tile = this.getAssemblyTable(player.bi, packet.posX, packet.posY, packet.posZ);
        if (tile == null) {
            return;
        }
        TileAssemblyTable.SelectionMessage message = new TileAssemblyTable.SelectionMessage();
        TileAssemblyTable.selectionMessageWrapper.fromPayload(message, packet.payload);
        tile.handleSelectionMessage(message);
    }
}

