/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.Orientations;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.liquids.ILiquidTank;
import buildcraft.api.liquids.ITankContainer;
import buildcraft.api.liquids.LiquidStack;
import buildcraft.api.liquids.LiquidTank;
import buildcraft.core.CoreProxy;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.network.PacketPayload;
import buildcraft.core.network.PacketUpdate;

public class TileTank
extends TileBuildCraft
implements ITankContainer {
    public final ILiquidTank tank = new LiquidTank(16000);
    public boolean hasUpdate = false;
    public SafeTimeTracker tracker = new SafeTimeTracker();

    @Override
    public void q_() {
        if (CoreProxy.isServerSide() && this.hasUpdate && this.tracker.markTimeIfDelay(this.k, 2 * BuildCraftCore.updateFactor)) {
            this.sendNetworkUpdate();
            this.hasUpdate = false;
        }
        if (CoreProxy.isRemote()) {
            return;
        }
        if (this.tank.getLiquid() != null) {
            this.moveLiquidBelow();
        }
    }

    @Override
    public PacketPayload getPacketPayload() {
        PacketPayload payload = new PacketPayload(3, 0, 0);
        if (this.tank.getLiquid() != null) {
            payload.intPayload[0] = this.tank.getLiquid().itemID;
            payload.intPayload[1] = this.tank.getLiquid().itemMeta;
            payload.intPayload[2] = this.tank.getLiquid().amount;
        } else {
            payload.intPayload[0] = 0;
            payload.intPayload[1] = 0;
            payload.intPayload[2] = 0;
        }
        return payload;
    }

    @Override
    public void handleUpdatePacket(PacketUpdate packet) {
        if (packet.payload.intPayload[0] > 0) {
            LiquidStack liquid = new LiquidStack(packet.payload.intPayload[0], packet.payload.intPayload[2], packet.payload.intPayload[1]);
            this.tank.setLiquid(liquid);
        } else {
            this.tank.setLiquid(null);
        }
    }

    public void a(ph data) {
        super.a(data);
        LiquidStack liquid = new LiquidStack(0, 0, 0);
        liquid.readFromNBT(data.m("tank"));
        this.tank.setLiquid(liquid);
    }

    public void b(ph data) {
        super.b(data);
        if (this.tank.getLiquid() != null) {
            data.a("tank", (jz)this.tank.getLiquid().writeToNBT(new ph()));
        }
    }

    public TileTank getBottomTank() {
        TileTank below;
        TileTank lastTank = this;
        while ((below = TileTank.getTankBelow(lastTank)) != null) {
            lastTank = below;
        }
        return lastTank;
    }

    public TileTank getTopTank() {
        TileTank above;
        TileTank lastTank = this;
        while ((above = TileTank.getTankAbove(lastTank)) != null) {
            lastTank = above;
        }
        return lastTank;
    }

    public static TileTank getTankBelow(TileTank tile) {
        qj below = tile.k.b(tile.l, tile.m - 1, tile.n);
        if (below instanceof TileTank) {
            return (TileTank)below;
        }
        return null;
    }

    public static TileTank getTankAbove(TileTank tile) {
        qj above = tile.k.b(tile.l, tile.m + 1, tile.n);
        if (above instanceof TileTank) {
            return (TileTank)above;
        }
        return null;
    }

    public void moveLiquidBelow() {
        TileTank below = TileTank.getTankBelow(this);
        if (below == null) {
            return;
        }
        int used = below.tank.fill(this.tank.getLiquid(), true);
        this.tank.drain(used, true);
    }

    @Override
    public int fill(Orientations from, LiquidStack resource, boolean doFill) {
        return this.fill(0, resource, doFill);
    }

    @Override
    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        if (tankIndex != 0 || resource == null) {
            return 0;
        }
        resource = resource.copy();
        int totalUsed = 0;
        TileTank tankToFill = this.getBottomTank();
        while (tankToFill != null && resource.amount > 0) {
            int used = tankToFill.tank.fill(resource, doFill);
            resource.amount -= used;
            totalUsed += used;
            tankToFill = TileTank.getTankAbove(tankToFill);
        }
        return totalUsed;
    }

    @Override
    public LiquidStack drain(Orientations from, int maxEmpty, boolean doDrain) {
        return this.drain(0, maxEmpty, doDrain);
    }

    @Override
    public LiquidStack drain(int tankIndex, int maxEmpty, boolean doDrain) {
        return this.getBottomTank().tank.drain(maxEmpty, doDrain);
    }

    @Override
    public ILiquidTank[] getTanks() {
        LiquidTank compositeTank = new LiquidTank(this.tank.getCapacity());
        TileTank tile = this.getBottomTank();
        int capacity = this.tank.getCapacity();
        if (tile == null || tile.tank.getLiquid() == null) {
            return new ILiquidTank[]{compositeTank};
        }
        compositeTank.setLiquid(tile.tank.getLiquid().copy());
        tile = TileTank.getTankAbove(tile);
        while (tile != null && tile.tank.getLiquid() != null && compositeTank.getLiquid().isLiquidEqual(tile.tank.getLiquid())) {
            compositeTank.getLiquid().amount += tile.tank.getLiquid().amount;
            capacity += tile.tank.getCapacity();
            tile = TileTank.getTankAbove(tile);
        }
        compositeTank.setCapacity(capacity);
        return new ILiquidTank[]{compositeTank};
    }
}

