/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.Orientations;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.liquids.ILiquidTank;
import buildcraft.api.liquids.ITankContainer;
import buildcraft.api.liquids.LiquidStack;
import buildcraft.api.liquids.LiquidTank;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import buildcraft.api.recipes.RefineryRecipe;
import buildcraft.core.CoreProxy;
import buildcraft.core.IMachine;
import buildcraft.core.network.TileNetworkData;
import buildcraft.factory.TileMachine;

public class TileRefinery
extends TileMachine
implements ITankContainer,
IPowerReceptor,
ni,
IMachine {
    private int[] filters = new int[2];
    public static int LIQUID_PER_SLOT = 4000;
    @TileNetworkData
    public Slot slot1 = new Slot();
    @TileNetworkData
    public Slot slot2 = new Slot();
    @TileNetworkData
    public Slot result = new Slot();
    @TileNetworkData
    public float animationSpeed = 1.0f;
    private int animationStage = 0;
    SafeTimeTracker time = new SafeTimeTracker();
    SafeTimeTracker updateNetworkTime = new SafeTimeTracker();
    IPowerProvider powerProvider = PowerFramework.currentFramework.createPowerProvider();
    private boolean isActive;

    public TileRefinery() {
        this.powerProvider.configure(20, 25, 25, 25, 1000);
        this.filters[0] = 0;
        this.filters[1] = 0;
    }

    public int c() {
        return 0;
    }

    public kp g_(int i) {
        return null;
    }

    public kp a(int i, int j) {
        return null;
    }

    public void a(int i, kp itemstack) {
    }

    public String e() {
        return null;
    }

    public int a() {
        return 0;
    }

    public boolean a(ih entityplayer) {
        return this.k.b(this.l, this.m, this.n) == this;
    }

    public kp b(int var1) {
        return null;
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        this.powerProvider = provider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    @Override
    public void doWork() {
    }

    @Override
    public void q_() {
        if (CoreProxy.isClient(this.k)) {
            this.simpleAnimationIterate();
        } else if (CoreProxy.isServerSide() && this.updateNetworkTime.markTimeIfDelay(this.k, 2 * BuildCraftCore.updateFactor)) {
            this.sendNetworkUpdate();
        }
        this.isActive = false;
        RefineryRecipe currentRecipe = null;
        currentRecipe = RefineryRecipe.findRefineryRecipe(new LiquidStack(this.slot1.liquidId, this.slot1.quantity, 0), new LiquidStack(this.slot2.liquidId, this.slot2.quantity, 0));
        if (currentRecipe == null) {
            this.decreaseAnimation();
            return;
        }
        if (this.result.quantity != 0 && this.result.liquidId != currentRecipe.result.itemID) {
            this.decreaseAnimation();
            return;
        }
        if (this.result.quantity + currentRecipe.result.amount > LIQUID_PER_SLOT) {
            this.decreaseAnimation();
            return;
        }
        this.isActive = true;
        if (!(this.powerProvider.getEnergyStored() >= (float)currentRecipe.energy)) {
            this.decreaseAnimation();
            return;
        }
        this.increaseAnimation();
        if (!this.time.markTimeIfDelay(this.k, currentRecipe.delay)) {
            return;
        }
        if (!this.containsInput(currentRecipe.ingredient1) || !this.containsInput(currentRecipe.ingredient2)) {
            this.decreaseAnimation();
            return;
        }
        float energyUsed = this.powerProvider.useEnergy(currentRecipe.energy, currentRecipe.energy, true);
        if (energyUsed != 0.0f && this.consumeInput(currentRecipe.ingredient1) && this.consumeInput(currentRecipe.ingredient2)) {
            this.result.liquidId = currentRecipe.result.itemID;
            this.result.quantity += currentRecipe.result.amount;
        }
    }

    private boolean containsInput(LiquidStack liquid) {
        if (liquid == null) {
            return true;
        }
        return new LiquidStack(this.slot1.liquidId, this.slot1.quantity, 0).containsLiquid(liquid) || new LiquidStack(this.slot2.liquidId, this.slot2.quantity, 0).containsLiquid(liquid);
    }

    private boolean consumeInput(LiquidStack liquid) {
        if (liquid == null) {
            return true;
        }
        if (liquid.isLiquidEqual(new LiquidStack(this.slot1.liquidId, this.slot1.quantity, 0))) {
            this.slot1.quantity -= liquid.amount;
            return true;
        }
        if (liquid.isLiquidEqual(new LiquidStack(this.slot2.liquidId, this.slot2.quantity, 0))) {
            this.slot2.quantity -= liquid.amount;
            return true;
        }
        return false;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public boolean manageLiquids() {
        return true;
    }

    @Override
    public boolean manageSolids() {
        return true;
    }

    public void a(ph nbttagcompound) {
        super.a(nbttagcompound);
        if (nbttagcompound.c("slot1")) {
            this.slot1.readFromNBT(nbttagcompound.m("slot1"));
            this.slot2.readFromNBT(nbttagcompound.m("slot2"));
            this.result.readFromNBT(nbttagcompound.m("result"));
        }
        this.animationStage = nbttagcompound.f("animationStage");
        this.animationSpeed = nbttagcompound.h("animationSpeed");
        PowerFramework.currentFramework.loadPowerProvider(this, nbttagcompound);
        this.powerProvider.configure(20, 25, 25, 25, 1000);
        this.filters[0] = nbttagcompound.f("filters_0");
        this.filters[1] = nbttagcompound.f("filters_1");
    }

    public void b(ph nbttagcompound) {
        super.b(nbttagcompound);
        ph NBTslot1 = new ph();
        ph NBTslot2 = new ph();
        ph NBTresult = new ph();
        this.slot1.writeFromNBT(NBTslot1);
        this.slot2.writeFromNBT(NBTslot2);
        this.result.writeFromNBT(NBTresult);
        nbttagcompound.a("slot1", (jz)NBTslot1);
        nbttagcompound.a("slot2", (jz)NBTslot2);
        nbttagcompound.a("result", (jz)NBTresult);
        nbttagcompound.a("animationStage", this.animationStage);
        nbttagcompound.a("animationSpeed", this.animationSpeed);
        PowerFramework.currentFramework.savePowerProvider(this, nbttagcompound);
        nbttagcompound.a("filters_0", this.filters[0]);
        nbttagcompound.a("filters_1", this.filters[1]);
    }

    public int getAnimationStage() {
        return this.animationStage;
    }

    public void simpleAnimationIterate() {
        if (this.animationSpeed > 1.0f) {
            this.animationStage = (int)((float)this.animationStage + this.animationSpeed);
            if (this.animationStage > 300) {
                this.animationStage = 100;
            }
        } else if (this.animationStage > 0) {
            --this.animationStage;
        }
    }

    public void increaseAnimation() {
        if (this.animationSpeed < 2.0f) {
            this.animationSpeed = 2.0f;
        } else if (this.animationSpeed <= 5.0f) {
            this.animationSpeed = (float)((double)this.animationSpeed + 0.1);
        }
        this.animationStage = (int)((float)this.animationStage + this.animationSpeed);
        if (this.animationStage > 300) {
            this.animationStage = 100;
        }
    }

    public void decreaseAnimation() {
        if (this.animationSpeed >= 1.0f) {
            this.animationSpeed = (float)((double)this.animationSpeed - 0.1);
            this.animationStage = (int)((float)this.animationStage + this.animationSpeed);
            if (this.animationStage > 300) {
                this.animationStage = 100;
            }
        } else if (this.animationStage > 0) {
            --this.animationStage;
        }
    }

    public void f() {
    }

    public void g() {
    }

    public void setFilter(int number, int liquidId) {
        this.filters[number] = liquidId;
    }

    public int getFilter(int number) {
        return this.filters[number];
    }

    @Override
    public boolean allowActions() {
        return false;
    }

    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.filters[0] = j;
                break;
            }
            case 1: {
                this.filters[1] = j;
            }
        }
    }

    public void sendGUINetworkData(ew container, ff iCrafting) {
        iCrafting.a(container, 0, this.filters[0]);
        iCrafting.a(container, 1, this.filters[1]);
    }

    @Override
    public int fill(Orientations from, LiquidStack resource, boolean doFill) {
        int used = 0;
        if (this.filters[0] != 0 || this.filters[1] != 0) {
            if (this.filters[0] == resource.itemID) {
                used += this.slot1.fill(from, resource.amount, resource.itemID, doFill);
            }
            if (this.filters[1] == resource.itemID) {
                used += this.slot2.fill(from, resource.amount - used, resource.itemID, doFill);
            }
        } else {
            used += this.slot1.fill(from, resource.amount, resource.itemID, doFill);
            used += this.slot2.fill(from, resource.amount - used, resource.itemID, doFill);
        }
        if (doFill && used > 0) {
            this.updateNetworkTime.markTime(this.k);
            this.sendNetworkUpdate();
        }
        return used;
    }

    @Override
    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return 0;
    }

    @Override
    public LiquidStack drain(Orientations from, int maxEmpty, boolean doDrain) {
        return this.drain(2, maxEmpty, doDrain);
    }

    @Override
    public LiquidStack drain(int tankIndex, int maxEmpty, boolean doDrain) {
        int res = 0;
        if (this.result.quantity >= maxEmpty) {
            res = maxEmpty;
            if (doDrain) {
                this.result.quantity -= maxEmpty;
            }
        } else {
            res = this.result.quantity;
            if (doDrain) {
                this.result.quantity = 0;
            }
        }
        if (doDrain && res > 0) {
            this.updateNetworkTime.markTime(this.k);
            this.sendNetworkUpdate();
        }
        return new LiquidStack(this.result.liquidId, res);
    }

    @Override
    public ILiquidTank[] getTanks() {
        return new ILiquidTank[]{new LiquidTank(this.slot1.liquidId, this.slot1.quantity, LIQUID_PER_SLOT), new LiquidTank(this.slot2.liquidId, this.slot2.quantity, LIQUID_PER_SLOT), new LiquidTank(this.result.liquidId, this.result.quantity, LIQUID_PER_SLOT)};
    }

    public static class Slot {
        @TileNetworkData
        public int liquidId = 0;
        @TileNetworkData
        public int quantity = 0;

        public int fill(Orientations from, int amount, int id2, boolean doFill) {
            if (this.quantity != 0 && this.liquidId != id2) {
                return 0;
            }
            if (this.quantity + amount <= LIQUID_PER_SLOT) {
                if (doFill) {
                    this.quantity += amount;
                }
                this.liquidId = id2;
                return amount;
            }
            int used = LIQUID_PER_SLOT - this.quantity;
            if (doFill) {
                this.quantity = LIQUID_PER_SLOT;
            }
            this.liquidId = id2;
            return used;
        }

        public void writeFromNBT(ph nbttagcompound) {
            nbttagcompound.a("liquidId", this.liquidId);
            nbttagcompound.a("quantity", this.quantity);
        }

        public void readFromNBT(ph nbttagcompound) {
            this.liquidId = nbttagcompound.f("liquidId");
            this.quantity = this.liquidId != 0 ? nbttagcompound.f("quantity") : 0;
        }
    }
}

