/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.Orientations;
import buildcraft.api.core.Position;
import buildcraft.api.liquids.ITankContainer;
import buildcraft.api.liquids.LiquidStack;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import buildcraft.core.BlockIndex;
import buildcraft.core.CoreProxy;
import buildcraft.core.EntityBlock;
import buildcraft.core.IMachine;
import buildcraft.core.Utils;
import buildcraft.core.network.PacketUpdate;
import buildcraft.core.network.TileNetworkData;
import buildcraft.factory.TileMachine;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.TreeSet;

public class TilePump
extends TileMachine
implements IMachine,
IPowerReceptor {
    EntityBlock tube;
    private TreeMap blocksToPump = new TreeMap();
    @TileNetworkData
    public int internalLiquid;
    @TileNetworkData
    public double tubeY = Double.NaN;
    @TileNetworkData
    public int aimY = 0;
    @TileNetworkData
    public int liquidId = 0;
    private IPowerProvider powerProvider = PowerFramework.currentFramework.createPowerProvider();

    public TilePump() {
        this.powerProvider.configure(20, 10, 10, 10, 100);
    }

    @Override
    public void q_() {
        super.q_();
        if (this.tube == null) {
            return;
        }
        if (!CoreProxy.isClient(this.k)) {
            if (this.tube.bn - (double)this.aimY > 0.01) {
                this.tubeY = this.tube.bn - 0.01;
                this.setTubePosition();
                if (CoreProxy.isServerSide()) {
                    this.sendNetworkUpdate();
                }
                return;
            }
            if (this.internalLiquid <= 0) {
                BlockIndex index = this.getNextIndexToPump(false);
                if (this.isPumpableLiquid(index)) {
                    int liquidToPump = Utils.liquidId(this.k.a(index.i, index.j, index.k));
                    if (this.internalLiquid == 0 || this.liquidId == liquidToPump) {
                        this.liquidId = liquidToPump;
                        if (this.powerProvider.useEnergy(10.0f, 10.0f, true) == 10.0f) {
                            index = this.getNextIndexToPump(true);
                            if (this.liquidId != vz.B.bO || BuildCraftCore.consumeWaterSources) {
                                this.k.e(index.i, index.j, index.k, 0);
                            }
                            this.internalLiquid = this.internalLiquid += 1000;
                            if (CoreProxy.isServerSide()) {
                                this.sendNetworkUpdate();
                            }
                        }
                    }
                } else if (this.k.o() % 100L == 0L) {
                    this.initializePumpFromPosition(this.l, this.aimY, this.n);
                    if (this.getNextIndexToPump(false) == null) {
                        for (int y = this.m - 1; y > 0; --y) {
                            if (this.isLiquid(new BlockIndex(this.l, y, this.n))) {
                                this.aimY = y;
                                return;
                            }
                            if (this.k.a(this.l, y, this.n) == 0) continue;
                            return;
                        }
                    }
                }
            }
        }
        if (this.internalLiquid >= 0) {
            for (int i = 0; i < 6; ++i) {
                Position p = new Position(this.l, this.m, this.n, Orientations.values()[i]);
                p.moveForwards(1.0);
                qj tile = this.k.b((int)p.x, (int)p.y, (int)p.z);
                if (!(tile instanceof ITankContainer)) continue;
                this.internalLiquid -= ((ITankContainer)tile).fill(p.orientation.reverse(), new LiquidStack(this.liquidId, this.internalLiquid), true);
                if (this.internalLiquid <= 0) break;
            }
        }
    }

    @Override
    public void initialize() {
        this.tube = new EntityBlock(this.k);
        this.tube.texture = 102;
        this.tube.bn = !Double.isNaN(this.tubeY) ? this.tubeY : (double)this.m;
        this.tubeY = this.tube.bn;
        if (this.aimY == 0) {
            this.aimY = this.m;
        }
        this.setTubePosition();
        this.k.b((tv)this.tube);
        if (CoreProxy.isServerSide()) {
            this.sendNetworkUpdate();
        }
    }

    private BlockIndex getNextIndexToPump(boolean remove) {
        LinkedList topLayer = null;
        int topLayerHeight = 0;
        for (Integer layer : this.blocksToPump.keySet()) {
            if (layer <= topLayerHeight || ((LinkedList)this.blocksToPump.get(layer)).size() == 0) continue;
            topLayerHeight = layer;
            topLayer = (LinkedList)this.blocksToPump.get(layer);
        }
        if (topLayer != null) {
            if (remove) {
                BlockIndex index = (BlockIndex)topLayer.pop();
                if (topLayer.size() == 0) {
                    this.blocksToPump.remove(topLayerHeight);
                }
                return index;
            }
            return (BlockIndex)topLayer.getLast();
        }
        return null;
    }

    private void initializePumpFromPosition(int x, int y, int z) {
        int liquidId = 0;
        TreeSet markedBlocks = new TreeSet();
        TreeSet lastFound = new TreeSet();
        if (!this.blocksToPump.containsKey(y)) {
            this.blocksToPump.put(y, new LinkedList());
        }
        LinkedList pumpList = (LinkedList)this.blocksToPump.get(y);
        liquidId = this.k.a(x, y, z);
        if (!this.isLiquid(new BlockIndex(x, y, z))) {
            return;
        }
        this.addToPumpIfLiquid(new BlockIndex(x, y, z), markedBlocks, lastFound, pumpList, liquidId);
        while (lastFound.size() > 0) {
            TreeSet visitIteration = new TreeSet(lastFound);
            lastFound.clear();
            for (BlockIndex index : visitIteration) {
                this.addToPumpIfLiquid(new BlockIndex(index.i + 1, index.j, index.k), markedBlocks, lastFound, pumpList, liquidId);
                this.addToPumpIfLiquid(new BlockIndex(index.i - 1, index.j, index.k), markedBlocks, lastFound, pumpList, liquidId);
                this.addToPumpIfLiquid(new BlockIndex(index.i, index.j, index.k + 1), markedBlocks, lastFound, pumpList, liquidId);
                this.addToPumpIfLiquid(new BlockIndex(index.i, index.j, index.k - 1), markedBlocks, lastFound, pumpList, liquidId);
                if (!this.blocksToPump.containsKey(index.j + 1)) {
                    this.blocksToPump.put(index.j + 1, new LinkedList());
                }
                pumpList = (LinkedList)this.blocksToPump.get(index.j + 1);
                this.addToPumpIfLiquid(new BlockIndex(index.i, index.j + 1, index.k), markedBlocks, lastFound, pumpList, liquidId);
            }
        }
    }

    public void addToPumpIfLiquid(BlockIndex index, TreeSet markedBlocks, TreeSet lastFound, LinkedList pumpList, int liquidId) {
        if (liquidId != this.k.a(index.i, index.j, index.k)) {
            return;
        }
        if (!markedBlocks.contains(index)) {
            markedBlocks.add(index);
            if ((index.i - this.l) * (index.i - this.l) + (index.k - this.n) * (index.k - this.n) > 4096) {
                return;
            }
            if (this.isPumpableLiquid(index)) {
                pumpList.push(index);
            }
            if (this.isLiquid(index)) {
                lastFound.add(index);
            }
        }
    }

    private boolean isPumpableLiquid(BlockIndex index) {
        return this.isLiquid(index) && this.k.c(index.i, index.j, index.k) == 0;
    }

    private boolean isLiquid(BlockIndex index) {
        return index != null && Utils.liquidId(this.k.a(index.i, index.j, index.k)) != 0;
    }

    public void a(ph nbttagcompound) {
        super.a(nbttagcompound);
        this.internalLiquid = nbttagcompound.f("internalLiquid");
        this.aimY = nbttagcompound.f("aimY");
        this.tubeY = nbttagcompound.h("tubeY");
        this.liquidId = nbttagcompound.f("liquidId");
        PowerFramework.currentFramework.loadPowerProvider(this, nbttagcompound);
        this.powerProvider.configure(20, 10, 10, 10, 100);
    }

    public void b(ph nbttagcompound) {
        super.b(nbttagcompound);
        PowerFramework.currentFramework.savePowerProvider(this, nbttagcompound);
        nbttagcompound.a("internalLiquid", this.internalLiquid);
        nbttagcompound.a("aimY", this.aimY);
        if (this.tube != null) {
            nbttagcompound.a("tubeY", (float)this.tube.bn);
        } else {
            nbttagcompound.a("tubeY", (float)this.m);
        }
        nbttagcompound.a("liquidId", this.liquidId);
    }

    @Override
    public boolean isActive() {
        return this.isPumpableLiquid(this.getNextIndexToPump(false));
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        this.powerProvider = provider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    @Override
    public void doWork() {
    }

    @Override
    public void handleDescriptionPacket(PacketUpdate packet) {
        super.handleDescriptionPacket(packet);
        this.setTubePosition();
    }

    @Override
    public void handleUpdatePacket(PacketUpdate packet) {
        super.handleDescriptionPacket(packet);
        this.setTubePosition();
    }

    private void setTubePosition() {
        if (this.tube != null) {
            this.tube.iSize = 0.5;
            this.tube.kSize = 0.5;
            this.tube.jSize = (double)this.m - this.tube.bn;
            this.tube.c((float)this.l + 0.25f, this.tubeY, (float)this.n + 0.25f);
        }
    }

    @Override
    public void j() {
        super.j();
        this.destroy();
    }

    @Override
    public void destroy() {
        if (this.tube != null) {
            CoreProxy.removeEntity(this.tube);
            this.tube = null;
            this.tubeY = Double.NaN;
            this.aimY = 0;
            this.blocksToPump.clear();
        }
    }

    @Override
    public boolean manageLiquids() {
        return true;
    }

    @Override
    public boolean manageSolids() {
        return false;
    }

    @Override
    public boolean allowActions() {
        return false;
    }
}

